package org.gcube.data.access.storagehub.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response.Status;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("api-docs")
public class DocsGenerator {

    private static Logger logger = LoggerFactory.getLogger(DocsGenerator.class);

    @GET
    @Path("/{any: .*}")
    public InputStream toDoc(@Context HttpServletRequest req) throws WebApplicationException {
        logger.info(DocsGenerator.class.getSimpleName() + " toDoc called");

        String pathInfo = req.getPathInfo();
        logger.debug("pathInfo {}", pathInfo);
        try {

            if (pathInfo.endsWith("/api-docs")) {
                pathInfo += "index.html";
            }

            if (pathInfo.endsWith("/api-docs/")) {
                pathInfo += "index.html";
            }

            logger.info("going to {}", pathInfo);

            String realPath = req.getServletContext().getRealPath(pathInfo);
            return new FileInputStream(new File(realPath));

        } catch (Exception e) {
        	logger.error("error getting the docs", e);
            throw new WebApplicationException(e,Status.SERVICE_UNAVAILABLE);
        }
    }
}