/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.version.Version;
import org.apache.commons.io.FilenameUtils;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.PluginInitializationException;
import org.gcube.common.storagehub.model.exceptions.PluginNotFoundException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.StorageIdNotFoundException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.data.access.storagehub.SingleFileStreamingOutput;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.CompressHandler;
import org.gcube.data.access.storagehub.handlers.DownloadHandler;
import org.gcube.data.access.storagehub.handlers.StorageAccountingHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DownloadHandler {
    private static final Logger log = LoggerFactory.getLogger(DownloadHandler.class);
    @Inject
    private AccountingHandler accountingHandler;
    @Inject
    private StorageBackendHandler storageBackendHandler;
    @Inject
    private CompressHandler compressHandler;
    @Inject
    private VersionHandler versionHandler;
    @Inject
    private Node2ItemConverter node2Item;
    @Inject
    private StorageAccountingHandler storageAccountingHandler;

    public Response downloadFolderItem(Session ses, String login, FolderItem item, boolean withAccounting) throws StorageHubException, RepositoryException {
        try {
            Deque allNodes = this.compressHandler.getAllNodesForZip(item, login, ses, this.accountingHandler, Excludes.GET_ONLY_CONTENT);
            Path originalPath = Paths.getPath((String)item.getParentPath());
            long totalSize = allNodes.stream().filter(i -> i instanceof AbstractFileItem).map(i -> (AbstractFileItem)i).collect(Collectors.summarizingLong(i -> i.getContent().getSize())).getSum();
            1 so = new /* Unavailable Anonymous Inner Class!! */;
            Response response = Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + item.getTitle() + ".zip")).header("Content-Type", (Object)"application/zip").header("Content-Length", (Object)-1L).build();
            if (withAccounting) {
                this.accountingHandler.createReadObj(item.getTitle(), null, ses, (Node)item.getRelatedNode(), login, false);
            }
            this.storageAccountingHandler.read(login, item.getOwner(), "application/zip", totalSize);
            Response response2 = response;
            return response2;
        }
        finally {
            if (ses != null) {
                ses.save();
            }
        }
    }

    public Response downloadFileItem(Session ses, AbstractFileItem fileItem, String login, boolean withAccounting) throws RepositoryException, PluginInitializationException, PluginNotFoundException, StorageHubException {
        Content content = fileItem.getContent();
        StorageBackendFactory sbf = this.storageBackendHandler.get(content.getPayloadBackend());
        StorageBackend sb = sbf.create(content.getPayloadBackend());
        InputStream streamToWrite = sb.download(content);
        if (withAccounting) {
            String versionName = null;
            try {
                Version version = this.versionHandler.getCurrentVersion((Node)fileItem.getRelatedNode());
                versionName = version.getName();
            }
            catch (RepositoryException repositoryException) {
                log.warn("current version of {} cannot be retreived", (Object)fileItem.getId());
            }
            this.accountingHandler.createReadObj(fileItem.getTitle(), versionName, ses, (Node)fileItem.getRelatedNode(), login, true);
        }
        this.storageAccountingHandler.read(login, fileItem.getOwner(), content.getMimeType(), content.getSize().longValue());
        SingleFileStreamingOutput so = new SingleFileStreamingOutput(streamToWrite);
        return Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + fileItem.getName())).header("Content-Length", (Object)fileItem.getContent().getSize()).header("Content-Type", (Object)fileItem.getContent().getMimeType()).build();
    }

    public Response downloadVersionedItem(Session ses, String login, AbstractFileItem currentItem, String versionName, boolean withAccounting) throws RepositoryException, StorageHubException {
        List jcrVersions = this.versionHandler.getContentVersionHistory((Node)currentItem.getRelatedNode());
        for (Version version : jcrVersions) {
            log.debug("retrieved version id {}, name {}", (Object)version.getIdentifier(), (Object)version.getName());
            if (!version.getName().equals(versionName)) continue;
            Content content = this.node2Item.getContentFromVersion(version);
            StorageBackendFactory sbf = this.storageBackendHandler.get(content.getPayloadBackend());
            StorageBackend sb = sbf.create(content.getPayloadBackend());
            InputStream streamToWrite = null;
            try {
                streamToWrite = sb.download(content);
            }
            catch (StorageIdNotFoundException e) {
                if (sbf.getName().equals("gcube-mongo")) {
                    sbf = this.storageBackendHandler.get("default-gcube-s3");
                    sbf.create(new PayloadBackend("default-gcube-s3", null));
                }
                throw e;
            }
            log.debug("retrieved storage id is {} with storageBackend {} (stream is null? {})", new Object[]{content.getStorageId(), sbf.getName(), streamToWrite == null});
            String oldfilename = FilenameUtils.getBaseName((String)currentItem.getTitle());
            String ext = FilenameUtils.getExtension((String)currentItem.getTitle());
            String fileName = String.format("%s_v%s.%s", oldfilename, version.getName(), ext);
            if (withAccounting) {
                this.accountingHandler.createReadObj(currentItem.getTitle(), versionName, ses, (Node)currentItem.getRelatedNode(), login, true);
            }
            this.storageAccountingHandler.read(login, currentItem.getOwner(), content.getMimeType(), content.getSize().longValue());
            SingleFileStreamingOutput so = new SingleFileStreamingOutput(streamToWrite);
            return Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + fileName)).header("Content-Length", (Object)content.getSize()).header("Content-Type", (Object)content.getMimeType()).build();
        }
        throw new InvalidItemException("the version is not valid");
    }

    public Response downloadFileFromStorageBackend(String storageId, String storageName) throws RepositoryException, PluginInitializationException, PluginNotFoundException, StorageHubException {
        StorageBackendFactory sbf = this.storageBackendHandler.get(storageName);
        StorageBackend sb = sbf.create(new PayloadBackend(storageName, null));
        InputStream streamToWrite = sb.download(storageId);
        Map userMetadata = sb.getFileMetadata(storageId);
        log.info("returned metadata from storageBackend are: {}", (Object)userMetadata);
        long size = Long.parseLong((String)userMetadata.get("size"));
        String title = (String)userMetadata.get("title");
        String contentType = (String)userMetadata.get("content-type");
        SingleFileStreamingOutput so = new SingleFileStreamingOutput(streamToWrite);
        return Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + title)).header("Content-Length", (Object)size).header("Content-Type", (Object)contentType).build();
    }
}

