/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import jakarta.inject.Singleton;
import java.net.URI;
import org.gcube.accounting.datamodel.UsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageUsageRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageUsageRecord;
import org.gcube.accounting.persistence.AccountingPersistence;
import org.gcube.accounting.persistence.AccountingPersistenceFactory;
import org.gcube.documentstore.records.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StorageAccountingHandler {
    private static final Logger log = LoggerFactory.getLogger(StorageAccountingHandler.class);

    public void update(String user, String owner, String fileType, long size) {
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        StorageUsageRecord storageUsageRecord = new StorageUsageRecord();
        try {
            storageUsageRecord.setConsumerId(user);
            storageUsageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            storageUsageRecord.setResourceOwner(owner);
            storageUsageRecord.setProviderURI(new URI("data.d4science.org"));
            storageUsageRecord.setOperationType(AbstractStorageUsageRecord.OperationType.UPDATE);
            storageUsageRecord.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
            storageUsageRecord.setDataVolume(size);
            storageUsageRecord.setQualifier(fileType);
            accountingPersistence.account((Record)storageUsageRecord);
        }
        catch (Throwable e) {
            log.error("error accounting storage read operation", e);
        }
    }

    public void delete(String user, String owner, String fileType, long size) {
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        StorageUsageRecord storageUsageRecord = new StorageUsageRecord();
        try {
            storageUsageRecord.setConsumerId(user);
            storageUsageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            storageUsageRecord.setResourceOwner(owner);
            storageUsageRecord.setProviderURI(new URI("data.d4science.org"));
            storageUsageRecord.setOperationType(AbstractStorageUsageRecord.OperationType.DELETE);
            storageUsageRecord.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
            storageUsageRecord.setDataVolume(size);
            storageUsageRecord.setQualifier(fileType);
            accountingPersistence.account((Record)storageUsageRecord);
        }
        catch (Throwable e) {
            log.error("error accounting storage read operation", e);
        }
    }

    public void create(String user, String owner, String fileType, long size) {
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        StorageUsageRecord storageUsageRecord = new StorageUsageRecord();
        try {
            storageUsageRecord.setConsumerId(user);
            storageUsageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            storageUsageRecord.setResourceOwner(owner);
            storageUsageRecord.setProviderURI(new URI("data.d4science.org"));
            storageUsageRecord.setOperationType(AbstractStorageUsageRecord.OperationType.CREATE);
            storageUsageRecord.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
            storageUsageRecord.setDataVolume(size);
            storageUsageRecord.setQualifier(fileType);
            accountingPersistence.account((Record)storageUsageRecord);
        }
        catch (Throwable e) {
            log.error("error accounting storage read operation", e);
        }
    }

    public void read(String user, String owner, String fileType, long size) {
        AccountingPersistence accountingPersistence = AccountingPersistenceFactory.getPersistence();
        StorageUsageRecord storageUsageRecord = new StorageUsageRecord();
        try {
            storageUsageRecord.setConsumerId(user);
            storageUsageRecord.setOperationResult(UsageRecord.OperationResult.SUCCESS);
            storageUsageRecord.setResourceOwner(owner);
            storageUsageRecord.setProviderURI(new URI("data.d4science.org"));
            storageUsageRecord.setOperationType(AbstractStorageUsageRecord.OperationType.READ);
            storageUsageRecord.setDataType(AbstractStorageUsageRecord.DataType.STORAGE);
            storageUsageRecord.setDataVolume(size);
            storageUsageRecord.setQualifier(fileType);
            accountingPersistence.account((Record)storageUsageRecord);
        }
        catch (Throwable e) {
            log.error("error accounting storage read operation", e);
        }
    }
}

