/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.RootItem;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.StorageAccountingHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.gcube.data.access.storagehub.types.ContentPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TrashHandler {
    private static Logger log = LoggerFactory.getLogger(TrashHandler.class);
    ExecutorService executor = Executors.newFixedThreadPool(100);
    @Inject
    VersionHandler versionHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    PathUtil pathUtil;
    @Inject
    StorageBackendHandler storageBackendHandler;
    @Inject
    private StorageAccountingHandler storageAccountingHandler;

    public void removeNodes(Session ses, List<Item> itemsToDelete) throws RepositoryException, StorageHubException {
        log.debug("defnitively removing nodes with ids {}", itemsToDelete);
        for (Item item : itemsToDelete) {
            this.removeNodesInternally(ses, item, false);
        }
    }

    public void removeOnlyNodesContent(Session ses, List<Item> itemsToDelete) throws RepositoryException, StorageHubException {
        log.debug("defnitively removing nodes with ids {}", itemsToDelete);
        for (Item item : itemsToDelete) {
            this.removeNodesInternally(ses, item, true);
        }
    }

    private void retrieveItemsToDelete(Set<AbstractFileItem> itemsToDelete, Item itemToDelete) throws Exception {
        if (itemToDelete instanceof AbstractFileItem) {
            itemsToDelete.add((AbstractFileItem)itemToDelete);
        } else if (itemToDelete instanceof FolderItem) {
            if (itemToDelete.isShared()) {
                return;
            }
            List items = Utils.getItemList((Node)((Node)itemToDelete.getRelatedNode()), (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null);
            for (Item item : items) {
                this.retrieveItemsToDelete(itemsToDelete, item);
            }
        }
    }

    private Set<ContentPair> retrieveContentToDelete(Collection<AbstractFileItem> itemsToDelete) {
        HashSet<ContentPair> contentSet = new HashSet<ContentPair>();
        for (AbstractFileItem item : itemsToDelete) {
            if (item.getContent() == null || item.getContent().getStorageId() == null) {
                log.warn("item with id {} contains null content", (Object)item.getId());
                continue;
            }
            try {
                StorageBackendFactory sbf = this.storageBackendHandler.get(item.getContent().getPayloadBackend());
                StorageBackend sb = sbf.create(item.getContent().getPayloadBackend());
                contentSet.add(new ContentPair(item.getContent(), item.getOwner(), sb));
                List versions = this.versionHandler.getContentVersionHistory((Node)item.getRelatedNode());
                for (Version version : versions) {
                    try {
                        Content content = this.node2Item.getContentFromVersion(version);
                        if (content != null && content.getStorageId() != null) {
                            contentSet.add(new ContentPair(content, item.getOwner(), sb));
                            continue;
                        }
                        log.warn("invalid version {}", (Object)version.getName());
                    }
                    catch (Throwable t) {
                        log.warn("error retrieving version content for {}", (Object)version.getName(), (Object)t);
                    }
                }
            }
            catch (Exception e) {
                log.warn("item with id {} cannot be deleted", (Object)item.getId(), (Object)e);
            }
        }
        return contentSet;
    }

    private void removeNodesInternally(Session ses, Item itemToDelete, boolean onlyContent) throws RepositoryException, StorageHubException {
        try {
            HashSet itemsToDelete = new HashSet();
            Node nodeToDelete = (Node)itemToDelete.getRelatedNode();
            if (itemToDelete instanceof TrashItem) {
                List trashChildren = Utils.getItemList((Node)nodeToDelete, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null);
                for (Item itemContentToRetrieve : trashChildren) {
                    this.retrieveItemsToDelete(itemsToDelete, itemContentToRetrieve);
                }
            } else {
                this.retrieveItemsToDelete(itemsToDelete, itemToDelete);
            }
            Set contentToDelete = this.retrieveContentToDelete(itemsToDelete);
            if (!onlyContent) {
                nodeToDelete.remove();
            }
            String ids = itemsToDelete.stream().map(i -> i.getId()).collect(Collectors.joining(","));
            log.debug("content ids to remove are {}", (Object)ids);
            Runnable deleteFromStorageRunnable = AuthorizedTasks.bind((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.executor.execute(deleteFromStorageRunnable);
            if (!onlyContent) {
                ses.save();
            }
        }
        catch (LockException e) {
            throw new ItemLockedException("the selected node or his parent is locked", (Throwable)e);
        }
        catch (Exception e) {
            throw new BackendGenericError("error permanetly deleting items", (Throwable)e);
        }
    }

    public void moveToTrash(Session ses, Node nodeToDelete, Item item, String login) throws RepositoryException, BackendGenericError {
        log.debug("moving node {} to trash ", (Object)item.getId());
        Node trashFolder = ses.getNode(this.pathUtil.getTrashPath(login, ses).toPath());
        try {
            try {
                ses.getWorkspace().getLockManager().lock(trashFolder.getPath(), true, true, 0L, login);
                ses.getWorkspace().getLockManager().lock(nodeToDelete.getPath(), true, true, 0L, login);
                log.debug("preparing thrash item");
                TrashItem trashItem = new TrashItem();
                trashItem.setDeletedBy(login);
                trashItem.setDeletedFrom(nodeToDelete.getParent().getPath());
                Calendar now = Calendar.getInstance();
                trashItem.setDeletedTime(now);
                trashItem.setHidden(false);
                trashItem.setLastAction(ItemAction.CREATED);
                trashItem.setDescription("trash item of node " + nodeToDelete.getPath());
                trashItem.setParentId(trashFolder.getIdentifier());
                trashItem.setParentPath(trashFolder.getPath());
                trashItem.setTitle(item.getTitle());
                trashItem.setName(item.getId());
                trashItem.setOriginalParentId(nodeToDelete.getParent().getIdentifier());
                trashItem.setOwner(login);
                trashItem.setLastModificationTime(item.getLastModificationTime());
                trashItem.setLastModifiedBy(item.getLastModifiedBy());
                trashItem.setLenght(0L);
                if (item instanceof FolderItem) {
                    trashItem.setFolder(true);
                } else if (item instanceof AbstractFileItem) {
                    AbstractFileItem file = (AbstractFileItem)item;
                    if (file.getContent() != null) {
                        trashItem.setMimeType(file.getContent().getMimeType());
                        trashItem.setLenght(file.getContent().getSize().longValue());
                    }
                    trashItem.setFolder(false);
                }
                log.debug("creating node");
                Node newTrashItemNode = this.item2Node.getNode(trashFolder, (RootItem)trashItem);
                ses.save();
                log.debug("calling jcr move");
                ses.getWorkspace().move(nodeToDelete.getPath(), Paths.append((Path)Paths.getPath((String)newTrashItemNode.getPath()), (String)nodeToDelete.getName()).toPath());
                String mimetype = null;
                if (item instanceof AbstractFileItem) {
                    AbstractFileItem file = (AbstractFileItem)item;
                    if (file.getContent() != null) {
                        mimetype = file.getContent().getMimeType();
                    } else {
                        log.warn("the AbstractFileItem with id {} has no content (check it!!)", (Object)file.getId());
                    }
                }
                this.accountingHandler.createFolderRemoveObj(item.getName(), item.getClass().getSimpleName(), mimetype, ses, login, (Node)item.getRelatedNode(), true);
            }
            catch (Throwable t) {
                log.error("error exceuting move to trash", t);
                throw new BackendGenericError(t);
            }
        }
        finally {
            ses.getWorkspace().getLockManager().unlock(nodeToDelete.getPath());
            ses.getWorkspace().getLockManager().unlock(trashFolder.getPath());
        }
    }

    public String restoreItem(Session ses, TrashItem item, FolderItem destination, String login) throws RepositoryException, StorageHubException, BackendGenericError {
        String newNodePath;
        block11: {
            log.debug("restoring node from trash with user ");
            Node destinationNode = null;
            if (destination == null) {
                boolean originalParentExists = true;
                boolean originalParentTrashed = false;
                Node originalParent = null;
                try {
                    originalParent = ses.getNodeByIdentifier(item.getOriginalParentId());
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    originalParentExists = false;
                }
                Item originalParentItem = null;
                if (originalParentExists) {
                    originalParentItem = this.node2Item.getItem(originalParent, Excludes.ALL);
                    originalParentTrashed = originalParentItem.isTrashed();
                }
                if (originalParentExists && !originalParentTrashed) {
                    destinationNode = originalParent;
                } else {
                    Node node;
                    String homeWS = this.pathUtil.getWorkspacePath(login).toPath();
                    destinationNode = node = ses.getNode(homeWS);
                }
            } else {
                Node node = (Node)destination.getRelatedNode();
                if (!this.node2Item.checkNodeType(node, FolderItem.class)) {
                    throw new InvalidCallParameters("destination Node is not a folder");
                }
                destinationNode = node;
            }
            this.authChecker.checkWriteAuthorizationControl(ses, login, destinationNode.getIdentifier(), true);
            ses.getWorkspace().getLockManager().lock(destinationNode.getPath(), true, true, 0L, login);
            newNodePath = null;
            try {
                List items = Utils.getItemList((Node)ses.getNodeByIdentifier(item.getId()), (List)Excludes.ALL, null, (boolean)false, null);
                if (items.size() != 1) {
                    log.warn("a problem occurred restoring item from trash");
                    throw new BackendGenericError("An error occurred on trash item");
                }
                Item itemToMove = (Item)items.get(0);
                this.item2Node.updateOwnerOnSubTree(ses.getNodeByIdentifier(itemToMove.getId()), login);
                String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destinationNode, (String)itemToMove.getName());
                newNodePath = Paths.append((Path)Paths.getPath((String)destinationNode.getPath()), (String)uniqueName).toPath();
                ses.move(itemToMove.getPath(), newNodePath);
                Utils.setPropertyOnChangeNode((Node)ses.getNode(newNodePath), (String)login, (ItemAction)ItemAction.MOVED);
                ses.removeItem(item.getPath());
                ses.save();
            }
            catch (Exception exception) {
                if (!ses.getWorkspace().getLockManager().isLocked(destinationNode.getPath())) break block11;
                ses.getWorkspace().getLockManager().unlock(destinationNode.getPath());
            }
        }
        return ses.getNode(newNodePath).getIdentifier();
    }
}

