/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.health;

import org.gcube.common.health.api.HealthCheck;
import org.gcube.common.health.api.ReadinessChecker;
import org.gcube.common.health.api.response.HealthCheckResponse;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.gcube.data.access.storagehub.storage.backend.impl.GcubeDefaultS3StorageBackendFactory;
import org.gcube.data.access.storagehub.storage.backend.impl.S3Backend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ReadinessChecker
public class DefaultStorageCheck
implements HealthCheck {
    private static Logger log = LoggerFactory.getLogger(DefaultStorageCheck.class);
    PayloadBackend defaultPayload = StorageBackendHandler.getDefaultPayloadForFolder();

    public String getName() {
        return String.format("default storage (%s)", this.defaultPayload.getStorageName());
    }

    public HealthCheckResponse check() {
        try {
            GcubeDefaultS3StorageBackendFactory storageFactory = new GcubeDefaultS3StorageBackendFactory();
            storageFactory.init();
            if (((S3Backend)storageFactory.create(this.defaultPayload)).isAlive()) {
                return HealthCheckResponse.builder((String)this.getName()).up().build();
            }
            return HealthCheckResponse.builder((String)this.getName()).down().error("error contacting storage").build();
        }
        catch (Exception e) {
            log.error("error checking defaultStorage", (Throwable)e);
            return HealthCheckResponse.builder((String)this.getName()).down().error(e.getMessage()).build();
        }
    }
}

