/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.plugins;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.InputStream;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.items.nodes.PayloadBackend;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.data.access.storagehub.handlers.plugins.StorageBackendHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StorageOperationMediator {
    Logger log = LoggerFactory.getLogger(StorageOperationMediator.class);
    @Inject
    StorageBackendHandler storageBackendHandler;

    public MetaInfo copy(Content source, PayloadBackend destination, String newName, String newParentPath, String login) throws StorageHubException {
        this.log.info("creating Storages for source {} and destination {}", (Object)source.getPayloadBackend(), (Object)destination.getStorageName());
        StorageBackendFactory sourceSBF = this.storageBackendHandler.get(source.getPayloadBackend());
        StorageBackend sourceSB = sourceSBF.create(source.getPayloadBackend());
        StorageBackendFactory destSBF = this.storageBackendHandler.get(destination);
        StorageBackend destSB = destSBF.create(destination);
        if (sourceSB.equals((Object)destSB)) {
            this.log.info("source and destintiona are the same storage");
            return sourceSB.onCopy(source, newParentPath, newName);
        }
        this.log.info("source and destintiona are different storage");
        InputStream stream = sourceSB.download(source);
        MetaInfo info = destSB.upload(stream, newParentPath, newName, source.getSize(), login);
        return info;
    }

    public boolean move() {
        return true;
    }
}

