/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.RootItem;
import org.gcube.common.storagehub.model.items.nodes.Owner;
import org.gcube.common.storagehub.model.messages.Message;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.MessageList;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.plugins.FolderPluginHandler;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.data.access.storagehub.types.MessageSharable;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="messages")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class MessageManager
extends Impersonable {
    private static final Logger log = LoggerFactory.getLogger(MessageManager.class);
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    AccountingHandler accountingHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    PathUtil pathUtil;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    TrashHandler trashHandler;
    @Inject
    FolderPluginHandler folderPluginHandler;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public Message getById() {
        InnerMethodName.instance.set("getMessageById");
        Session ses = null;
        Message toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node messageNode = ses.getNodeByIdentifier(this.id);
                toReturn = this.node2Item.getMessageItem(messageNode);
                this.checkRights(this.currentUser, toReturn);
                return toReturn;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("jcr error getting item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Path(value="{id}")
    public void deleteById() {
        InnerMethodName.instance.set("deleteMessageById");
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node messageNode = ses.getNodeByIdentifier(this.id);
                Message message = this.node2Item.getMessageItem(messageNode);
                Node personalNode = this.checkRights(this.currentUser, message);
                if (this.countSharedSet(messageNode) > 1) {
                    personalNode.removeShare();
                } else {
                    if (message.isWithAttachments()) {
                        Node attachmentNode = messageNode.getNode("hl:attachments");
                        List attachments = Utils.getItemList((Node)attachmentNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, AbstractFileItem.class);
                        this.trashHandler.removeOnlyNodesContent(ses, attachments);
                    }
                    messageNode.removeSharedSet();
                }
                ses.save();
                return;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (RepositoryException re) {
                log.error("jcr error getting item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}/attachments")
    @Produces(value={"application/json"})
    public ItemList getAttachments() {
        InnerMethodName.instance.set("getAttachmentsByMessageId");
        Session ses = null;
        List attachments = new ArrayList();
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node messageNode = ses.getNodeByIdentifier(this.id);
            Message messageItem = this.node2Item.getMessageItem(messageNode);
            this.checkRights(this.currentUser, messageItem);
            Node attachmentNode = messageNode.getNode("hl:attachments");
            attachments = Utils.getItemList((Node)attachmentNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, AbstractFileItem.class);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(attachments);
            ses.logout();
            return new ItemList(attachments);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
            return new ItemList(attachments);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(attachments);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(attachments);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(attachments);
        ses.logout();
        return new ItemList(attachments);
    }

    @GET
    @Path(value="inbox")
    @Produces(value={"application/json"})
    public MessageList getReceivedMessages(@QueryParam(value="reduceBody") Integer reduceBody) {
        List toReturn;
        block8: {
            InnerMethodName.instance.set("getReceivedMessages");
            Session ses = null;
            toReturn = null;
            try {
                try {
                    ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                    Node node = ses.getNode(this.pathUtil.getInboxPath(this.currentUser).toPath());
                    toReturn = this.getMessages(node, reduceBody);
                }
                catch (RepositoryException re) {
                    log.error("jcr error getting item", (Throwable)re);
                    GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
                    if (ses != null) {
                        ses.logout();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (ses != null) {
                    ses.logout();
                }
                throw throwable;
            }
            if (ses != null) {
                ses.logout();
            }
        }
        return new MessageList(toReturn);
    }

    @GET
    @Path(value="sent")
    @Produces(value={"application/json"})
    public MessageList getSentMessages(@QueryParam(value="reduceBody") Integer reduceBody) {
        List toReturn;
        block8: {
            InnerMethodName.instance.set("getSentMessages");
            Session ses = null;
            toReturn = null;
            try {
                try {
                    ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                    Node node = ses.getNode(this.pathUtil.getOutboxPath(this.currentUser).toPath());
                    toReturn = this.getMessages(node, reduceBody);
                }
                catch (RepositoryException re) {
                    log.error("jcr error getting item", (Throwable)re);
                    GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
                    if (ses != null) {
                        ses.logout();
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (ses != null) {
                    ses.logout();
                }
                throw throwable;
            }
            if (ses != null) {
                ses.logout();
            }
        }
        return new MessageList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{id}/{prop}")
    @Consumes(value={"application/json"})
    public void setProperty(@PathParam(value="prop") String property, Object value) {
        InnerMethodName.instance.set("setPropertyOnMessage(" + property + ")");
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node messageNode = ses.getNodeByIdentifier(this.id);
                Message messageItem = this.node2Item.getMessageItem(messageNode);
                this.checkRights(this.currentUser, messageItem);
                Item2NodeConverter.Values val = Item2NodeConverter.getObjectValue(value.getClass(), (Object)value);
                messageNode.setProperty(property, val.getValue());
                ses.save();
                return;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (Exception re) {
                log.error("jcr error getting item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
                if (ses == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Path(value="send")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String sendMessage(@FormParam(value="to[]") List<String> addresses, @FormParam(value="subject") String subject, @FormParam(value="body") String body, @FormParam(value="attachments[]") List<String> attachments) {
        InnerMethodName.instance.set("sendMessage");
        JackrabbitSession ses = null;
        String messageId = null;
        try {
            try {
                if (addresses.size() == 0 || body == null || subject == null) {
                    throw new InvalidCallParameters();
                }
                log.debug("attachments send are {}", attachments);
                ses = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                MessageSharable message = new MessageSharable();
                message.setAddresses(addresses.toArray(new String[0]));
                message.setSubject(subject);
                message.setBody(body);
                message.setName(UUID.randomUUID().toString());
                User user = (User)ses.getUserManager().getAuthorizable(this.currentUser, User.class);
                Owner owner = new Owner();
                owner.setUserId(user.getID());
                owner.setUserName(user.getPrincipal().getName());
                message.setSender(owner);
                Node outbox = ses.getNode(this.pathUtil.getOutboxPath(this.currentUser).toPath());
                Node messageNode = this.item2Node.getNode(outbox, (RootItem)message);
                ses.save();
                if (attachments != null && !attachments.isEmpty()) {
                    this.saveAttachments((Session)ses, messageNode, attachments);
                    ses.save();
                }
                for (String to : addresses) {
                    try {
                        String userMessagePath = Paths.append((org.gcube.common.storagehub.model.Path)this.pathUtil.getInboxPath(to), (String)messageNode.getName()).toPath();
                        ses.getWorkspace().clone(ses.getWorkspace().getName(), messageNode.getPath(), userMessagePath, false);
                    }
                    catch (Exception e) {
                        log.warn("message not send to {}", (Object)to, (Object)e);
                    }
                }
                ses.save();
                messageId = messageNode.getIdentifier();
                return messageId;
            }
            catch (RepositoryException re) {
                log.error("jcr error getting item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item", (Throwable)re)));
                if (ses == null) return messageId;
                ses.logout();
                return messageId;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return messageId;
                ses.logout();
                return messageId;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private Node saveAttachments(Session ses, Node messageNode, List<String> attachments) throws RepositoryException, BackendGenericError {
        Node attachmentNode = messageNode.getNode("hl:attachments");
        for (String itemId : attachments) {
            Node node = ses.getNodeByIdentifier(itemId);
            Item item = this.node2Item.getItem(node, Excludes.GET_ONLY_CONTENT);
            Node newNode = this.copyNode(ses, attachmentNode, item);
            if (!newNode.hasNode(NodeProperty.ACCOUNTING.toString())) continue;
            newNode.getNode(NodeProperty.ACCOUNTING.toString()).remove();
        }
        return messageNode;
    }

    private List<Message> getMessages(Node node, Integer reduceBody) throws RepositoryException {
        ArrayList<Message> messages = new ArrayList<Message>();
        NodeIterator nodeIt = node.getNodes();
        while (nodeIt.hasNext()) {
            Node child = nodeIt.nextNode();
            log.info("message type " + child.getPrimaryNodeType().getName());
            Message message = this.node2Item.getMessageItem(child);
            if (message == null) {
                log.info("message discarded");
                continue;
            }
            if (reduceBody != null && reduceBody > 0 && message.getBody().length() > reduceBody) {
                message.setBody(message.getBody().substring(0, reduceBody));
            }
            this.insertOrdered(messages, message);
        }
        return messages;
    }

    private void insertOrdered(List<Message> messages, Message toInsert) {
        if (messages.isEmpty()) {
            messages.add(toInsert);
        } else {
            int i = 0;
            while (i < messages.size()) {
                if (messages.get(i).getCreationTime().getTimeInMillis() <= toInsert.getCreationTime().getTimeInMillis()) break;
                ++i;
            }
            messages.add(i, toInsert);
        }
    }

    private Node checkRights(String user, Message messageItem) throws RepositoryException, StorageHubException {
        Node personalNode = null;
        Node messageNode = (Node)messageItem.getRelatedNode();
        if (messageNode.getPath().startsWith(this.pathUtil.getWorkspacePath(this.currentUser).toPath())) {
            return messageNode;
        }
        NodeIterator nodeIt = messageNode.getSharedSet();
        while (nodeIt.hasNext()) {
            Node node = nodeIt.nextNode();
            if (!node.getPath().startsWith(this.pathUtil.getWorkspacePath(this.currentUser).toPath())) continue;
            personalNode = node;
        }
        if (personalNode == null && !messageItem.getSender().getUserName().equals(user) && !Arrays.asList(messageItem.getAddresses()).contains(user)) {
            throw new UserNotAuthorizedException("user " + this.currentUser + "cannot read message with id " + this.id);
        }
        return personalNode == null ? messageNode : personalNode;
    }

    private Node copyNode(Session session, Node destination, Item itemToCopy) throws RepositoryException, BackendGenericError {
        Node nodeToCopy = (Node)itemToCopy.getRelatedNode();
        String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)session, (Node)destination, (String)itemToCopy.getName());
        String newPath = String.format("%s/%s", destination.getPath(), uniqueName);
        session.getWorkspace().copy(nodeToCopy.getPath(), newPath);
        Node newNode = session.getNode(newPath);
        if (itemToCopy instanceof AbstractFileItem) {
            AbstractFileItem newNodeItem = (AbstractFileItem)this.node2Item.getItem(newNode, Excludes.EXCLUDE_ACCOUNTING);
            newNodeItem.getContent().setRemotePath(newPath);
            String newStorageID = this.folderPluginHandler.getDefault().getStorageBackend().onCopy(newNodeItem);
            newNodeItem.getContent().setStorageId(newStorageID);
            this.item2Node.replaceContent(newNode, newNodeItem, ItemAction.CLONED);
        }
        Utils.setPropertyOnChangeNode((Node)newNode, (String)this.currentUser, (ItemAction)ItemAction.CLONED);
        newNode.setProperty(NodeProperty.PORTAL_LOGIN.toString(), this.currentUser);
        newNode.setProperty(NodeProperty.IS_PUBLIC.toString(), false);
        newNode.setProperty(NodeProperty.TITLE.toString(), uniqueName);
        return newNode;
    }

    private int countSharedSet(Node node) throws RepositoryException {
        int count = 0;
        NodeIterator it = node.getSharedSet();
        while (it.hasNext()) {
            ++count;
            it.next();
        }
        return count;
    }
}

