/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.storage.backend.impl;

import java.io.InputStream;
import java.util.UUID;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.nodes.Content;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class GCubeStorageBackend
implements StorageBackend {
    private static final Logger log = LoggerFactory.getLogger(GCubeStorageBackend.class);
    private static final String SERVICE_NAME = "home-library";
    private static final String SERVICE_CLASS = "org.gcube.portlets.user";

    protected GCubeStorageBackend() {
    }

    public InputStream download(Content content) {
        return GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient().get().RFileAsInputStream(content.getStorageId());
    }

    public String getName() {
        return GCubeStorageBackend.class.getName();
    }

    public String onCopy(AbstractFileItem item) {
        log.info("copying storage Id {} to newPath {}", (Object)item.getContent().getStorageId(), (Object)item.getPath());
        String newStorageID = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient().copyFile(true).from(item.getContent().getStorageId()).to(item.getPath());
        log.info("The id returned by storage is {}", (Object)newStorageID);
        return newStorageID;
    }

    public String onMove(AbstractFileItem item) {
        return item.getContent().getStorageId();
    }

    public MetaInfo upload(InputStream stream, String relPath, String name) {
        log.debug("uploading file");
        IClient storageClient = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient();
        String uid = UUID.randomUUID().toString();
        String remotePath = String.format("%s/%s-%s", relPath, uid, name);
        String storageId = storageClient.put(true).LFile(stream).RFile(remotePath);
        long size = storageClient.getSize().RFileById(storageId);
        MetaInfo info = new MetaInfo();
        info.setSize(size);
        info.setStorageId(storageId);
        info.setRemotePath(remotePath);
        return info;
    }

    public void onDelete(Content content) {
        log.debug("deleting");
        IClient storageClient = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient();
        storageClient.remove().RFileById(content.getStorageId());
    }

    private static StorageClient getStorageClient(String login) {
        return new StorageClient("org.gcube.portlets.user", "home-library", login, AccessType.SHARED, MemoryType.PERSISTENT);
    }

    public String getTotalSizeStored() {
        IClient storageClient = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient();
        return storageClient.getTotalUserVolume();
    }

    public String getTotalItemsCount() {
        IClient storageClient = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient();
        return storageClient.getUserTotalItems();
    }
}

