/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.services.GroupManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroupHandler {
    private static final Logger log = LoggerFactory.getLogger(GroupManager.class);
    @Inject
    PathUtil pathUtil;

    public boolean removeUserFromGroup(String groupId, String userId, JackrabbitSession session) throws StorageHubException, RepositoryException {
        User user;
        UserManager usrManager = session.getUserManager();
        Group group = (Group)usrManager.getAuthorizable(groupId);
        if (!group.isMember((Authorizable)(user = (User)usrManager.getAuthorizable(userId)))) {
            throw new InvalidCallParameters("user " + userId + " is not member of group " + groupId);
        }
        String folderName = group.getPrincipal().getName();
        Node folder = this.getFolderNodeRelatedToGroup(session, folderName);
        NodeIterator ni = folder.getSharedSet();
        while (ni.hasNext()) {
            Node node = ni.nextNode();
            if (!node.getPath().startsWith(this.pathUtil.getWorkspacePath(user.getPrincipal().getName()).toPath())) continue;
            node.removeShare();
            break;
        }
        return group.removeMember((Authorizable)user);
    }

    public Node getFolderNodeRelatedToGroup(JackrabbitSession session, String name) throws ItemNotFoundException, RepositoryException {
        Node sharedRootNode = session.getNode("/Share");
        Node vreFolder = null;
        try {
            vreFolder = sharedRootNode.getNode(name);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.debug("is an old HL VRE");
        }
        if (vreFolder == null) {
            NodeIterator nodes = sharedRootNode.getNodes();
            while (nodes.hasNext()) {
                Node node = nodes.nextNode();
                if (!node.hasProperty(NodeProperty.TITLE.toString()) || !node.getProperty(NodeProperty.TITLE.toString()).getString().equals(name)) continue;
                vreFolder = node;
                break;
            }
        }
        if (vreFolder == null) {
            throw new ItemNotFoundException("vre folder not found for group " + name);
        }
        return vreFolder;
    }
}

