/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.plugins.FolderManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.plugins.FolderPluginHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressHandler {
    private Logger logger = LoggerFactory.getLogger(CompressHandler.class);
    @Inject
    FolderPluginHandler pluginHandler;

    public Deque<Item> getAllNodesForZip(FolderItem directory, Session session, String login, AccountingHandler accountingHandler, List<String> excludes) throws RepositoryException, BackendGenericError {
        LinkedList<Item> queue = new LinkedList<Item>();
        Node currentNode = session.getNodeByIdentifier(directory.getId());
        queue.push((Item)directory);
        LinkedList tempQueue = new LinkedList();
        this.logger.trace("adding directory {}", (Object)currentNode.getPath());
        for (Item item : Utils.getItemList((Node)currentNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)false, null)) {
            if (excludes.contains(item.getId())) continue;
            if (item instanceof FolderItem) {
                tempQueue.addAll(this.getAllNodesForZip((FolderItem)item, session, login, accountingHandler, excludes));
                continue;
            }
            if (!(item instanceof AbstractFileItem)) continue;
            this.logger.trace("adding file {}", (Object)item.getPath());
            AbstractFileItem fileItem = (AbstractFileItem)item;
            accountingHandler.createReadObj(fileItem.getTitle(), session, session.getNodeByIdentifier(item.getId()), login, false);
            queue.addLast(item);
        }
        queue.addAll(tempQueue);
        return queue;
    }

    public void zipNode(ZipOutputStream zos, Deque<Item> queue, String login, Path originalPath) throws Exception {
        this.logger.trace("originalPath is {}", (Object)originalPath.toPath());
        Path actualPath = Paths.getPath((String)"");
        while (!queue.isEmpty()) {
            Item item = queue.pop();
            if (item instanceof FolderItem) {
                actualPath = Paths.getPath((String)item.getPath());
                this.logger.trace("actualPath is {}", (Object)actualPath.toPath());
                String name = Paths.remove((Path)actualPath, (Path)originalPath).toPath().replaceFirst("/", "");
                this.logger.trace("writing dir {}", (Object)name);
                if (name.isEmpty()) continue;
                try {
                    zos.putNextEntry(new ZipEntry(name));
                    continue;
                }
                finally {
                    zos.closeEntry();
                }
            }
            if (!(item instanceof AbstractFileItem)) continue;
            try {
                block22: {
                    AbstractFileItem fileItem = (AbstractFileItem)item;
                    FolderManager manager = this.pluginHandler.getFolderManager((Item)fileItem);
                    InputStream streamToWrite = manager.getStorageBackend().download(fileItem.getContent());
                    if (streamToWrite == null) {
                        this.logger.warn("discarding item {} ", (Object)item.getName());
                        continue;
                    }
                    try {
                        try {
                            Throwable throwable = null;
                            Object var11_15 = null;
                            try (BufferedInputStream is = new BufferedInputStream(streamToWrite);){
                                String name = (String.valueOf(Paths.remove((Path)actualPath, (Path)originalPath).toPath()) + item.getName()).replaceFirst("/", "");
                                this.logger.trace("writing file {}", (Object)name);
                                zos.putNextEntry(new ZipEntry(name));
                                Utils.copyStream((InputStream)is, (OutputStream)zos);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            this.logger.warn("error writing item {}", (Object)item.getName(), (Object)e);
                            zos.closeEntry();
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        zos.closeEntry();
                        throw throwable;
                    }
                    zos.closeEntry();
                }
                zos.flush();
            }
            catch (Throwable e) {
                this.logger.warn("error reading content for item {}", (Object)item.getPath(), (Object)e);
            }
        }
        zos.close();
    }
}

