/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;

@Singleton
public class PathUtil {
    public Path getWorkspacePath(String login) {
        return Paths.getPath((String)String.format("/Home/%s/%s", login, "Workspace"));
    }

    public Path getHome(String login) {
        return Paths.getPath((String)String.format("/Home/%s", login));
    }

    public Path getInboxPath(String login) {
        return Paths.append((Path)this.getHome(login), (String)"InBox");
    }

    public Path getOutboxPath(String login) {
        return Paths.append((Path)this.getHome(login), (String)"OutBox");
    }

    @Deprecated
    private Path getOldTrashPath(String login) {
        return Paths.append((Path)this.getWorkspacePath(login), (String)"Trash");
    }

    private Path getNewTrashPath(String login) {
        return Paths.append((Path)this.getHome(login), (String)"Trash");
    }

    @Deprecated
    private Path getOldVREsPath(String login) {
        return Paths.append((Path)this.getWorkspacePath(login), (String)"MySpecialFolders");
    }

    private Path getNewVREsPath(String login) {
        return Paths.append((Path)this.getHome(login), (String)"VREs");
    }

    public Path getSharedWithMePath(String login) {
        return Paths.append((Path)this.getWorkspacePath(login), (String)"SharedWithMe");
    }

    public Path getVREsPath(String login, Session session) throws RepositoryException {
        Path home = this.getHome(login);
        Node node = session.getNode(home.toPath());
        if (node.hasProperty("hl:version") && node.getProperty("hl:version").getLong() > 0L) {
            return this.getNewVREsPath(login);
        }
        return this.getOldVREsPath(login);
    }

    public Path getTrashPath(String login, Session session) throws RepositoryException {
        Path home = this.getHome(login);
        Node node = session.getNode(home.toPath());
        if (node.hasProperty("hl:version") && node.getProperty("hl:version").getLong() > 0L) {
            return this.getNewTrashPath(login);
        }
        return this.getOldTrashPath(login);
    }
}

