/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import org.gcube.data.access.storagehub.MultipleOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleOutputStream {
    private Logger logger = LoggerFactory.getLogger(MultipleOutputStream.class);
    private MyPipedInputStream[] pipedInStreams;
    private InputStream is;
    private MyPipedOututStream[] pipedOutStreams;
    private int index = 0;

    public MultipleOutputStream(InputStream is, int number) throws IOException {
        this.is = is;
        this.logger.debug("requested {} piped streams ", (Object)number);
        this.pipedInStreams = new MyPipedInputStream[number];
        this.pipedOutStreams = new MyPipedOututStream[number];
        int i = 0;
        while (i < number) {
            this.pipedOutStreams[i] = new MyPipedOututStream(this);
            this.pipedInStreams[i] = new MyPipedInputStream(this, (PipedOutputStream)this.pipedOutStreams[i]);
            ++i;
        }
    }

    public void startWriting() throws IOException {
        int i;
        BufferedInputStream bis = new BufferedInputStream(this.is);
        byte[] buf = new byte[65536];
        int read = -1;
        int writeTot = 0;
        while ((read = bis.read(buf)) != -1) {
            i = 0;
            while (i < this.pipedInStreams.length) {
                if (!this.pipedInStreams[i].isClosed()) {
                    this.pipedOutStreams[i].write(buf, 0, read);
                }
                ++i;
            }
            writeTot += read;
            if (this.allOutStreamClosed()) break;
        }
        i = 0;
        while (i < this.pipedOutStreams.length) {
            if (!this.pipedOutStreams[i].isClosed()) {
                this.logger.debug("closing outputstream {}", (Object)i);
                this.pipedOutStreams[i].close();
            }
            ++i;
        }
        this.logger.debug("total written {} ", (Object)writeTot);
    }

    private boolean allOutStreamClosed() {
        int i = 0;
        while (i < this.pipedOutStreams.length) {
            if (!this.pipedOutStreams[i].isClosed()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public synchronized InputStream get() {
        this.logger.debug("requesting piped streams {}", (Object)this.index);
        if (this.index >= this.pipedInStreams.length) {
            return null;
        }
        return this.pipedInStreams[this.index++];
    }

    static /* synthetic */ Logger access$0(MultipleOutputStream multipleOutputStream) {
        return multipleOutputStream.logger;
    }
}

