package org.gcube.data.access.storagehub.handlers.plugins;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;

import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.PluginInitializationException;
import org.gcube.common.storagehub.model.exceptions.PluginNotFoundException;
import org.gcube.common.storagehub.model.items.ExternalFolder;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.plugins.FolderManager;
import org.gcube.common.storagehub.model.plugins.FolderManagerConnector;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.storage.backend.impl.GcubeFolderManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FolderPluginHandler {
	
	private static Logger log = LoggerFactory.getLogger(FolderPluginHandler.class);
	
	@Inject
	Node2ItemConverter node2Item;
	
	private GcubeFolderManager defaultManager = new GcubeFolderManager();
	
	public FolderManager getDefault() {
		return defaultManager;
	}
	
	@Inject
	Instance<FolderManagerConnector> connectors;
	
	private Map<String, FolderManagerConnector> connectorsMap;
	
	FolderPluginHandler(){
		if (connectors !=null)
			connectorsMap = connectors.stream().collect(Collectors.toMap(FolderManagerConnector::getName, e -> e ));
		else {
			log.info("connectors are null");
			connectorsMap = Collections.emptyMap();
		}
	}
	
	public FolderManagerConnector getConnector(String name) throws PluginNotFoundException  {
		if (!connectorsMap.containsKey(name)) throw new PluginNotFoundException("plugin "+name+" not found");
		return connectorsMap.get(name);
	}
	
	public FolderManager getFolderManager(Item item) throws PluginInitializationException, PluginNotFoundException, RepositoryException, BackendGenericError{
		if (!item.isExternalManaged())
			return defaultManager;
		Session session = ((Node)item.getRelatedNode()).getSession();
		Item parent = null;
		do {
			String parentId = item.getParentId();
			Node node = session.getNodeByIdentifier(parentId);
			parent = node2Item.getItem(node, Excludes.ALL);
			
			if (parent !=null && parent instanceof ExternalFolder) {
				ExternalFolder extParent = (ExternalFolder) parent;
				String plugin = extParent.getManagedBy();
				Map<String, Object> parameters = extParent.getConnectionParameters().getMap();
				return getConnector(plugin).connect(extParent, parameters);				
			}
		} while (parent!=null);
		throw new BackendGenericError("selected external managed item doesn't have a parent external folder");
	}
}
