/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.vres;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.handlers.GroupHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.vres.VRE;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VREManager {
    private static final Logger logger = LoggerFactory.getLogger(VREManager.class);
    private Map<String, VRE> vreMap = new HashMap();
    @Inject
    RepositoryInitializer repository;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    PathUtil pathUtil;
    @Inject
    GroupHandler groupHandler;
    ExecutorService executor = Executors.newFixedThreadPool(5);
    SimpleCredentials credentials;

    @Inject
    public VREManager(ServletContext context) {
        this.credentials = new SimpleCredentials(context.getInitParameter("admin-username"), context.getInitParameter("admin-pwd").toCharArray());
    }

    public synchronized VRE getVRE(String completeName) {
        logger.trace("requesting VRE {}", (Object)completeName);
        if (this.vreMap.containsKey(completeName)) {
            return (VRE)this.vreMap.get(completeName);
        }
        return null;
    }

    private synchronized VRE putVRE(Item vreFolder) {
        logger.trace("inserting VRE {}", (Object)vreFolder.getTitle());
        if (this.vreMap.containsKey(vreFolder.getTitle())) {
            throw new RuntimeException("something went wrong (vre already present in the map)");
        }
        VRE toReturn = new VRE(vreFolder, this.repository.getRepository(), this.credentials, this.node2Item, this.executor);
        this.vreMap.put(vreFolder.getTitle(), toReturn);
        return toReturn;
    }

    public synchronized VRE getVreFolderItem(JackrabbitSession ses, String userId, List<String> excludes) throws RepositoryException, StorageHubException {
        ScopeBean bean = new ScopeBean(ScopeProvider.instance.get());
        if (!bean.is(ScopeBean.Type.VRE)) {
            throw new BackendGenericError("the current scope is not a VRE");
        }
        String entireScopeName = bean.toString().replaceAll("^/(.*)/?$", "$1").replaceAll("/", "-");
        return this.getVreFolderItemByGroupName(ses, entireScopeName, userId, excludes);
    }

    public synchronized VRE getVreFolderItemByGroupName(JackrabbitSession ses, String groupName, String userId, List<String> excludes) throws RepositoryException, StorageHubException {
        UserManager um = ses.getUserManager();
        Group groupAuth = (Group)um.getAuthorizable(groupName, Group.class);
        User userAuth = (User)um.getAuthorizable(userId, User.class);
        if (groupAuth == null || userAuth == null || !groupAuth.isMember((Authorizable)userAuth)) {
            throw new InvalidCallParameters("error getting VRE with user " + userId + " for group " + groupName);
        }
        VRE vre = this.getVRE(groupName);
        if (vre != null) {
            return vre;
        }
        Node vreFolderNode = this.groupHandler.getFolderNodeRelatedToGroup(ses, groupName);
        Item vreFolder = this.node2Item.getItem(vreFolderNode, excludes);
        return this.putVRE(vreFolder);
    }
}

