/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.items.builders;

import java.util.Objects;
import javax.jcr.Session;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.CreateParameters;

public abstract class ItemsParameterBuilder<T extends CreateParameters> {
    T parameters;

    protected ItemsParameterBuilder(T parameters) {
        this.parameters = parameters;
    }

    public ItemsParameterBuilder<T> on(String parentId) {
        this.parameters.parentId = parentId;
        return this;
    }

    public ItemsParameterBuilder<T> author(String author) {
        this.parameters.user = author;
        return this;
    }

    public ItemsParameterBuilder<T> with(Session session) {
        this.parameters.session = session;
        return this;
    }

    public T build() throws InvalidCallParameters {
        if (!this.parameters.isValid() || !Objects.nonNull(this.parameters.parentId)) {
            throw new InvalidCallParameters("invalid call");
        }
        return (T)this.parameters;
    }
}

