/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.util.Collections;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.handlers.plugins.FolderPluginHandler;
import org.gcube.data.access.storagehub.handlers.vres.VRE;
import org.gcube.data.access.storagehub.handlers.vres.VREManager;
import org.gcube.data.access.storagehub.query.sql2.evaluators.Evaluators;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class WorkspaceManager
extends Impersonable {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceManager.class);
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    Evaluators evaluator;
    @Inject
    PathUtil pathUtil;
    @Inject
    VREManager vreManager;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    TrashHandler trashHandler;
    @RequestScoped
    @QueryParam(value="exclude")
    private List<String> excludes = Collections.emptyList();
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    FolderPluginHandler folderHandler;

    @Path(value="/")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getWorkspace(@QueryParam(value="relPath") String relPath) {
        Item toReturn;
        block10: {
            InnerMethodName.instance.set("getWorkspace");
            Session ses = null;
            org.gcube.common.storagehub.model.Path absolutePath = relPath == null ? this.pathUtil.getWorkspacePath(this.currentUser) : Paths.append((org.gcube.common.storagehub.model.Path)this.pathUtil.getWorkspacePath(this.currentUser), (String)relPath);
            toReturn = null;
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                org.gcube.common.storagehub.model.Path trashPath = this.pathUtil.getTrashPath(this.currentUser, ses);
                if (!ses.nodeExists(trashPath.toPath())) {
                    Node wsNode = ses.getNode(this.pathUtil.getWorkspacePath(this.currentUser).toPath());
                    FolderCreationParameters trashFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("Trash").description("trash of " + this.currentUser).author(this.currentUser).on(wsNode.getIdentifier()).with(ses).build();
                    Utils.createFolderInternally((FolderCreationParameters)trashFolderParameters, null);
                    ses.save();
                }
                Node node = ses.getNode(absolutePath.toPath());
                this.authChecker.checkReadAuthorizationControl(ses, this.currentUser, node.getIdentifier());
                toReturn = this.node2Item.getItem(node, this.excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting workspace item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block10;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block10;
            ses.logout();
        }
        return new ItemWrapper(toReturn);
    }

    @Path(value="vrefolder")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getVreRootFolder() {
        Item vreItem;
        block9: {
            InnerMethodName.instance.set("getVreRootFolder");
            JackrabbitSession ses = null;
            vreItem = null;
            try {
                ses = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                vreItem = this.vreManager.getVreFolderItem(ses, this.currentUser, this.excludes).getVreFolder();
            }
            catch (RepositoryException re) {
                log.error("jcr error getting vrefolder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemWrapper(vreItem);
    }

    @Path(value="vrefolder/recents")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFolderRecentsDocument() {
        InnerMethodName.instance.set("getVreFolderRecents");
        JackrabbitSession ses = null;
        List recentItems = Collections.emptyList();
        try {
            ses = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            VRE vre = this.vreManager.getVreFolderItem(ses, this.currentUser, this.excludes);
            log.trace("VRE retrieved {}", (Object)vre.getVreFolder().getTitle());
            recentItems = vre.getRecents();
            log.trace("recents retrieved {}", (Object)vre.getVreFolder().getTitle());
            ItemList itemList = new ItemList(recentItems);
            return itemList;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting recents", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(recentItems);
    }

    @Path(value="trash")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getTrashRootFolder() {
        Item item;
        block9: {
            InnerMethodName.instance.set("getTrashRootFolder");
            Session ses = null;
            item = null;
            try {
                long start = System.currentTimeMillis();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                org.gcube.common.storagehub.model.Path trashPath = this.pathUtil.getTrashPath(this.currentUser, ses);
                log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
                Node folder = ses.getNode(trashPath.toPath());
                item = this.node2Item.getItem(folder, this.excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting trash", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemWrapper(item);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Path(value="trash/empty")
    @DELETE
    public String emptyTrash() {
        InnerMethodName.instance.set("emptyTrash");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                org.gcube.common.storagehub.model.Path trashPath = this.pathUtil.getTrashPath(this.currentUser, ses);
                Node trashNode = ses.getNode(trashPath.toPath());
                List itemsToDelete = Utils.getItemList((Node)trashNode, (List)Excludes.ALL, null, (boolean)true, null);
                this.trashHandler.removeNodes(ses, itemsToDelete);
                toReturn = trashNode.getIdentifier();
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("jcr error emptying trash", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="trash/restore")
    public String restoreItem(@FormParam(value="trashedItemId") String trashedItemId, @FormParam(value="destinationId") String destinationFolderId) {
        InnerMethodName.instance.set("restoreItem");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                log.info("restoring node with id {}", (Object)trashedItemId);
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node nodeToRestore = ses.getNodeByIdentifier(trashedItemId);
                Item itemToRestore = this.node2Item.getItem(nodeToRestore, Excludes.ALL);
                if (!(itemToRestore instanceof TrashItem)) {
                    throw new InvalidItemException("Only trash items can be restored");
                }
                org.gcube.common.storagehub.model.Path trashPath = this.pathUtil.getTrashPath(this.currentUser, ses);
                if (!itemToRestore.getPath().startsWith(trashPath.toPath())) {
                    throw new UserNotAuthorizedException("this item is not in the user " + this.currentUser + " trash");
                }
                Item destinationItem = null;
                if (destinationFolderId != null) {
                    destinationItem = this.node2Item.getItem(ses.getNodeByIdentifier(destinationFolderId), Excludes.ALL);
                    if (!(destinationItem instanceof FolderItem)) {
                        throw new InvalidCallParameters("destintation item is not a folder");
                    }
                    toReturn = this.trashHandler.restoreItem(ses, (TrashItem)itemToRestore, (FolderItem)destinationItem, this.currentUser);
                    return toReturn;
                } else {
                    toReturn = this.trashHandler.restoreItem(ses, (TrashItem)itemToRestore, null, this.currentUser);
                }
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("error restoring item with id {}", (Object)trashedItemId, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @Path(value="vrefolders")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFolders() {
        List toReturn;
        block9: {
            InnerMethodName.instance.set("getVreFolders");
            Session ses = null;
            toReturn = null;
            org.gcube.common.storagehub.model.Path vrePath = null;
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                vrePath = this.pathUtil.getVREsPath(this.currentUser, ses);
                log.info("vres folder path is {}", (Object)vrePath.toPath());
                toReturn = Utils.getItemList((Node)ses.getNode(vrePath.toPath()), (List)this.excludes, null, (boolean)false, null);
            }
            catch (RepositoryException re) {
                log.error("error reading the node children of {}", vrePath, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemList(toReturn);
    }

    @Path(value="vrefolders/paged")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFoldersPaged(@QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        List toReturn;
        block9: {
            InnerMethodName.instance.set("getVreFoldersPaged");
            Session ses = null;
            org.gcube.common.storagehub.model.Path vrePath = null;
            toReturn = null;
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                vrePath = this.pathUtil.getVREsPath(this.currentUser, ses);
                toReturn = Utils.getItemList((Node)ses.getNode(vrePath.toPath()), (List)this.excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)false, null);
            }
            catch (RepositoryException re) {
                log.error("(paged) error reading the node children of {}", vrePath, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemList(toReturn);
    }

    @Path(value="count")
    @GET
    public String getTotalItemsCount() {
        InnerMethodName.instance.set("getTotalItemsCount");
        return this.folderHandler.getDefault().getStorageBackend().getTotalItemsCount();
    }

    @Path(value="size")
    @GET
    public String getTotalVolume() {
        InnerMethodName.instance.set("getTotalSize");
        return this.folderHandler.getDefault().getStorageBackend().getTotalSizeStored();
    }
}

