/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.items;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.RootItem;
import org.gcube.common.storagehub.model.plugins.FolderManager;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.MultipleOutputStream;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandlerFactory;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.ItemHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.items.builders.ArchiveStructureCreationParameter;
import org.gcube.data.access.storagehub.handlers.items.builders.CreateParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.FileCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.GCubeItemCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.URLCreationParameters;
import org.gcube.data.access.storagehub.handlers.plugins.FolderPluginHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ItemHandler {
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    ContentHandlerFactory contenthandlerFactory;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    VersionHandler versionHandler;
    @Inject
    FolderPluginHandler pluginHandler;
    private static ExecutorService executor = Executors.newFixedThreadPool(100);
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    private static Logger log = LoggerFactory.getLogger(ItemHandler.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType;

    /*
     * Exception decompiling
     */
    public <T extends CreateParameters> String create(T parameters) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Node create(FolderCreationParameters params, Node destination) throws Exception {
        Utils.acquireLockWithWait((Session)params.getSession(), (String)destination.getPath(), (boolean)false, (String)params.getUser(), (int)10);
        Node newNode = Utils.createFolderInternally((FolderCreationParameters)params, (AccountingHandler)this.accountingHandler);
        params.getSession().save();
        return newNode;
    }

    private Node create(FileCreationParameters params, Node destination) throws Exception {
        Node newNode = this.createFileItemInternally(params.getSession(), destination, params.getStream(), params.getName(), params.getDescription(), params.getUser(), true);
        params.getSession().save();
        this.versionHandler.checkinContentNode(newNode);
        log.info("file with id {} correctly created", (Object)newNode.getIdentifier());
        return newNode;
    }

    private Node create(URLCreationParameters params, Node destination) throws Exception {
        Utils.acquireLockWithWait((Session)params.getSession(), (String)destination.getPath(), (boolean)false, (String)params.getUser(), (int)10);
        Node newNode = Utils.createURLInternally((Session)params.getSession(), (Node)destination, (String)params.getName(), (URL)params.getUrl(), (String)params.getDescription(), (String)params.getUser(), (AccountingHandler)this.accountingHandler);
        params.getSession().save();
        return newNode;
    }

    /*
     * Exception decompiling
     */
    private Node create(ArchiveStructureCreationParameter params, Node destination) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[UNCONDITIONALDOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Node createPath(String parentPath, Map<String, Node> directoryNodeMap, Node rootNode, Session ses, String user) throws StorageHubException, RepositoryException {
        String[] parentPathSplit = parentPath.split("/");
        String name = parentPathSplit[parentPathSplit.length - 1];
        StringBuilder relParentPath = new StringBuilder();
        int i = 0;
        while (i <= parentPathSplit.length - 2) {
            relParentPath.append(parentPathSplit[i]).append("/");
            ++i;
        }
        if (relParentPath.toString().isEmpty()) {
            FolderCreationParameters folderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name(name).author(user).on(rootNode.getIdentifier()).with(ses).build();
            Node createdNode = Utils.createFolderInternally((FolderCreationParameters)folderParameters, (AccountingHandler)this.accountingHandler);
            directoryNodeMap.put(String.valueOf(name) + "/", createdNode);
            return createdNode;
        }
        Node relParentNode = directoryNodeMap.get(relParentPath.toString());
        if (relParentNode == null) {
            relParentNode = this.createPath(relParentPath.toString(), directoryNodeMap, rootNode, ses, user);
        }
        FolderCreationParameters folderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name(name).author(user).on(relParentNode.getIdentifier()).with(ses).build();
        Node createdNode = Utils.createFolderInternally((FolderCreationParameters)folderParameters, (AccountingHandler)this.accountingHandler);
        directoryNodeMap.put(relParentPath.append(name).append("/").toString(), createdNode);
        return createdNode;
    }

    private Node create(GCubeItemCreationParameters params, Node destination) throws Exception {
        Utils.acquireLockWithWait((Session)params.getSession(), (String)destination.getPath(), (boolean)false, (String)params.getUser(), (int)10);
        Node newNode = Utils.createGcubeItemInternally((Session)params.getSession(), (Node)destination, (String)params.getItem().getName(), (String)params.getItem().getDescription(), (String)params.getUser(), (GCubeItem)params.getItem(), (AccountingHandler)this.accountingHandler);
        params.getSession().save();
        return newNode;
    }

    private Node createFileItemInternally(Session ses, Node destinationNode, InputStream stream, String name, String description, String login, boolean withLock) throws RepositoryException, StorageHubException {
        Node newNode;
        String newNodePath;
        FolderItem destinationItem = (FolderItem)this.node2Item.getItem(destinationNode, Excludes.ALL);
        FolderManager folderManager = this.pluginHandler.getFolderManager((Item)destinationItem);
        StorageBackend storageBackend = folderManager.getStorageBackend();
        String relativePath = destinationNode.getPath();
        if (destinationItem.isExternalManaged()) {
            relativePath = relativePath.replace(folderManager.getRootFolder().getPath(), "");
        }
        if (ses.nodeExists(newNodePath = Paths.append((Path)Paths.getPath((String)destinationNode.getPath()), (String)name).toPath())) {
            if (!folderManager.manageVersion()) {
                throw new InvalidCallParameters("storage for plugin " + folderManager.getClass().getName() + " doesn't support versioning");
            }
            newNode = ses.getNode(newNodePath);
            this.authChecker.checkWriteAuthorizationControl(ses, login, newNode.getIdentifier(), false);
            AbstractFileItem item = this.fillItemWithContent(stream, storageBackend, name, description, relativePath, login);
            if (withLock) {
                try {
                    ses.getWorkspace().getLockManager().lock(newNode.getPath(), true, true, 0L, login);
                }
                catch (LockException le) {
                    throw new ItemLockedException((Throwable)le);
                }
            }
            try {
                this.versionHandler.checkoutContentNode(newNode);
                log.trace("replacing content of class {}", item.getContent().getClass());
                this.item2Node.replaceContent(newNode, item, ItemAction.UPDATED);
                this.accountingHandler.createFileUpdated(item.getTitle(), ses, newNode, login, false);
                ses.save();
            }
            finally {
                if (withLock) {
                    ses.getWorkspace().getLockManager().unlock(newNode.getPath());
                }
            }
        }
        this.authChecker.checkWriteAuthorizationControl(ses, login, destinationNode.getIdentifier(), true);
        AbstractFileItem item = this.fillItemWithContent(stream, storageBackend, name, description, relativePath, login);
        if (withLock) {
            try {
                log.debug("trying to acquire lock");
                Utils.acquireLockWithWait((Session)ses, (String)destinationNode.getPath(), (boolean)false, (String)login, (int)10);
            }
            catch (LockException le) {
                throw new ItemLockedException((Throwable)le);
            }
        }
        try {
            newNode = this.item2Node.getNode(destinationNode, (RootItem)item);
            this.accountingHandler.createEntryCreate(item.getTitle(), ses, newNode, login, false);
            ses.save();
        }
        finally {
            if (withLock) {
                ses.getWorkspace().getLockManager().unlock(destinationNode.getPath());
            }
        }
        this.versionHandler.makeVersionableContent(newNode);
        this.accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), item.getContent().getMimeType(), ses, login, destinationNode, false);
        return newNode;
    }

    private AbstractFileItem fillItemWithContent(InputStream stream, StorageBackend storageBackend, String name, String description, String relPath, String login) throws BackendGenericError {
        ContentHandler handler = this.getContentHandler(stream, storageBackend, name, relPath, login);
        AbstractFileItem item = handler.buildItem(name, description, login);
        return item;
    }

    private ContentHandler getContentHandler(InputStream stream, StorageBackend storageBackend, String name, String relPath, String login) throws BackendGenericError {
        MultipleOutputStream mos;
        try {
            mos = new MultipleOutputStream(stream, 2);
        }
        catch (IOException e) {
            throw new BackendGenericError((Throwable)e);
        }
        1 mimeTypeDector = new /* Unavailable Anonymous Inner Class!! */;
        2 uploader = new /* Unavailable Anonymous Inner Class!! */;
        Future detectorF = executor.submit(AuthorizedTasks.bind((Callable)mimeTypeDector));
        Future uploaderF = executor.submit(AuthorizedTasks.bind((Callable)uploader));
        long start = System.currentTimeMillis();
        log.debug("TIMING: writing the stream - start");
        try {
            mos.startWriting();
            log.debug("TIMING: writing the stream - finished in {}", (Object)(System.currentTimeMillis() - start));
            ContentHandler handler = (ContentHandler)detectorF.get();
            MetaInfo info = (MetaInfo)uploaderF.get();
            handler.getContent().setData("jcr:content");
            handler.getContent().setStorageId(info.getStorageId());
            handler.getContent().setSize(Long.valueOf(info.getSize()));
            handler.getContent().setRemotePath(info.getRemotePath());
            return handler;
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType() {
        if ($SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType != null) {
            return $SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType;
        }
        int[] nArray = new int[CreateParameters.ManagedType.values().length];
        try {
            nArray[CreateParameters.ManagedType.ARCHIVE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CreateParameters.ManagedType.FILE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CreateParameters.ManagedType.FOLDER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CreateParameters.ManagedType.GCUBEITEM.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[CreateParameters.ManagedType.URL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$data$access$storagehub$handlers$items$builders$CreateParameters$ManagedType = nArray;
        return nArray;
    }

    static /* synthetic */ Logger access$1() {
        return log;
    }
}

