package org.gcube.data.access.storagehub.handlers.items.builders;

import java.util.Objects;

import org.gcube.common.storagehub.model.plugins.PluginParameters;

public class FolderCreationParameters extends CreateParameters {
	
	private String name;
	private String description=""; 
	private boolean hidden = false;
	private String externalPluginName = null;
	private PluginParameters externalPluginParameters = null;
	
	protected FolderCreationParameters() {}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public boolean isHidden() {
		return hidden;
	}

	public boolean isExternal() {
		return externalPluginName!=null;
	}

	public String getPluginName(String name) {
		return this.externalPluginName;
	}
	
	public PluginParameters getPluginParameters() {
		return externalPluginParameters;
	}
	
	@Override
	protected boolean isValid() {
		return Objects.nonNull(name) && Objects.nonNull(description);
	}

	@Override
	public String toString() {
		return "FolderCreationParameters [name=" + name + ", description=" + description + ", hidden=" + hidden
				+ ", parentId=" + parentId + ", session=" + session + ", user=" + user + "]";
	}
	
	
	public static FolderCreationBuilder builder() {
		return new FolderCreationBuilder();
	}
	
	public static class FolderCreationBuilder extends ItemsParameterBuilder<FolderCreationParameters>{

		private FolderCreationBuilder() {
			super(new FolderCreationParameters());
		}
		
		public FolderCreationBuilder name(String name) {
			parameters.name = name;
			return this;		
		}

		public FolderCreationBuilder description(String description) {
			parameters.description = description;
			return this;
		}
		
		public ExternalFolderCreationBuilder onRepository(String pluginName) {
			return new ExternalFolderCreationBuilder(pluginName, this);
		}
		
		public FolderCreationBuilder hidden(boolean hidden) {
			parameters.hidden = hidden;
			return this;
		}

	}
	
	public static class ExternalFolderCreationBuilder {
		
		FolderCreationBuilder cb;
		
		protected ExternalFolderCreationBuilder(String pluginName, FolderCreationBuilder cb) {
			this.cb.parameters.externalPluginName = pluginName;
		}
		
		public FolderCreationBuilder withParameters(PluginParameters params){
			this.cb.parameters.externalPluginParameters = params;
			return this.cb;
		}
		
		
	}
	

	@Override
	public ManagedType getMangedType() {
		return ManagedType.FOLDER;
	}
}
