/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.exception.MyAuthException;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.GroupHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.UnshareHandler;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.data.access.storagehub.services.UserManager;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="users")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class UserManager {
    private static final String INFRASTRUCTURE_MANAGER_ROLE = "Infrastructure-Manager";
    @Context
    ServletContext context;
    private static final Logger log;
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    UnshareHandler unshareHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    TrashHandler trashHandler;
    @Inject
    GroupHandler groupHandler;
    @Inject
    PathUtil pathUtil;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        UserManager.ajc$preClinit();
        log = LoggerFactory.getLogger(UserManager.class);
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public List<String> getUsers() {
        InnerMethodName.instance.set("getUsers");
        JackrabbitSession session = null;
        ArrayList users = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Iterator result = session.getUserManager().findAuthorizables((Query)new /* Unavailable Anonymous Inner Class!! */);
                HashSet<String> usersSet = new HashSet<String>();
                String adminUser = this.context.getInitParameter("admin-username");
                while (result.hasNext()) {
                    Authorizable user = (Authorizable)result.next();
                    log.debug("user {} found", (Object)user.getPrincipal().getName());
                    if (user.getPrincipal().getName().equals(adminUser)) continue;
                    usersSet.add(user.getPrincipal().getName());
                }
                users = new ArrayList(usersSet);
                Collections.sort(users);
            }
            catch (Exception e) {
                log.error("jcr error getting users", (Throwable)e);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)e)));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return users;
    }

    /*
     * Unable to fully structure code
     */
    @GET
    @Path(value="{user}")
    public String getUser(@PathParam(value="user") String user) {
        block7: {
            block8: {
                InnerMethodName.instance.set("getUser");
                session = null;
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                usrManager = session.getUserManager();
                authorizable = usrManager.getAuthorizable(user);
                if (authorizable == null || authorizable.isGroup()) break block7;
                var6_6 = authorizable.getPrincipal().getName();
                if (session == null) break block8;
                session.logout();
            }
            return var6_6;
        }
        try {
            try {
                UserManager.log.debug("user {} not found", (Object)user);
            }
            catch (Exception e) {
                UserManager.log.error("jcr error getting user", (Throwable)e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
                if (session == null) ** GOTO lbl31
                session.logout();
            }
        }
        catch (Throwable var5_7) {
            if (session != null) {
                session.logout();
            }
            throw var5_7;
        }
        if (session != null) {
            session.logout();
        }
lbl31:
        // 5 sources

        GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(user));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Path(value="")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public String createUser(@FormParam(value="user") String user, @FormParam(value="password") String password) {
        String string = user;
        String string2 = password;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("createUser");
        JackrabbitSession session = null;
        String userId = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                org.apache.jackrabbit.api.security.user.UserManager usrManager = session.getUserManager();
                User createdUser = usrManager.createUser(user, password);
                userId = createdUser.getID();
                Node homeNode = session.getNode("/Home");
                Node userHome = homeNode.addNode(user, "nthl:home");
                userHome.setProperty("hl:version", 1L);
                FolderCreationParameters wsFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("Workspace").description("workspace of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
                Utils.createFolderInternally((FolderCreationParameters)wsFolderParameters, null);
                FolderCreationParameters trashFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("Trash").description("trash of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
                Utils.createFolderInternally((FolderCreationParameters)trashFolderParameters, null);
                FolderCreationParameters vreFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("VREs").description("vre folder container of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
                Utils.createFolderInternally((FolderCreationParameters)vreFolderParameters, null);
                FolderCreationParameters inboxFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("InBox").description("inbox of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
                Utils.createFolderInternally((FolderCreationParameters)inboxFolderParameters, null);
                FolderCreationParameters outboxFolderParameters = (FolderCreationParameters)FolderCreationParameters.builder().name("OutBox").description("outbox of " + user).author(user).on(userHome.getIdentifier()).with((Session)session).build();
                Utils.createFolderInternally((FolderCreationParameters)outboxFolderParameters, null);
                session.save();
                return userId;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error creating item", (Throwable)re)));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Path(value="{user}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public String deleteUser(@PathParam(value="user") String user) {
        String string = user;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("deleteUser");
        JackrabbitSession session = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                org.apache.jackrabbit.api.security.user.UserManager usrManager = session.getUserManager();
                User authorizable = (User)usrManager.getAuthorizable((Principal)new PrincipalImpl(user));
                if (authorizable != null) {
                    this.removeUserFromBelongingGroup(session, authorizable, usrManager);
                } else {
                    log.warn("user was already deleted from jackrabbit, trying to delete folders");
                }
                this.unshareUsersFolders(session, user);
                this.removeUserHomeAndDeleteFiles(session, user);
                if (authorizable != null && !authorizable.isGroup()) {
                    log.info("removing user {}", (Object)user);
                    authorizable.remove();
                } else {
                    log.warn("the user {} was already deleted, it should never happen", (Object)user);
                }
                session.save();
                return user;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return user;
                session.logout();
                return user;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error creating item", (Throwable)re)));
                if (session == null) return user;
                session.logout();
                return user;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void removeUserFromBelongingGroup(JackrabbitSession session, User authorizable, org.apache.jackrabbit.api.security.user.UserManager usrManager) throws RepositoryException, StorageHubException {
        Iterator groups = session.getUserManager().findAuthorizables((Query)new /* Unavailable Anonymous Inner Class!! */);
        String user = authorizable.getPrincipal().getName();
        while (groups.hasNext()) {
            Authorizable group = (Authorizable)groups.next();
            log.info("group found {}", (Object)group.getPrincipal().getName());
            if (!group.isGroup() || !((Group)group).isMember((Authorizable)authorizable)) continue;
            boolean success = this.groupHandler.removeUserFromGroup(group.getPrincipal().getName(), user, session);
            log.warn("user {} {} removed from vre {}", new Object[]{user, success ? "" : "not", group.getPrincipal().getName()});
        }
    }

    private void unshareUsersFolders(JackrabbitSession session, String user) {
        try {
            Node sharedFolderNode = session.getNode("/Share");
            3 sharedWithUserChecker = new /* Unavailable Anonymous Inner Class!! */;
            List items = Utils.getItemList((Predicate)sharedWithUserChecker, (Node)sharedFolderNode, (List)Excludes.ALL, null, (boolean)false, SharedFolder.class);
            log.debug(" Shared folder to unshare found are {}", (Object)items.size());
            for (SharedFolder item : items) {
                String title = item.getTitle();
                log.debug("in list folder name {} with title {} and path {} ", new Object[]{item.getName(), title, item.getPath()});
                if (item.isPublicItem() && !item.getUsers().getMap().containsKey(user) || item.isVreFolder()) continue;
                log.info("removing sharing for folder name {} with title {} and path {} ", new Object[]{item.getName(), title, item.getPath()});
                String owner = item.getOwner();
                Set<Object> usersToUnshare = owner.equals(user) ? Collections.emptySet() : Collections.singleton(user);
                try {
                    this.unshareHandler.unshareForRemoval((Session)session, usersToUnshare, session.getNodeByIdentifier(item.getId()), user);
                }
                catch (Throwable e) {
                    log.warn("error unsharing folder with title '{}' and id {} ", new Object[]{title, item.getId(), e});
                }
            }
        }
        catch (Throwable t) {
            log.warn("error getting folder shared with {}", (Object)user, (Object)t);
        }
    }

    private void removeUserHomeAndDeleteFiles(JackrabbitSession session, String user) throws RepositoryException, StorageHubException {
        org.gcube.common.storagehub.model.Path homePath = this.pathUtil.getHome(user);
        org.gcube.common.storagehub.model.Path workspacePath = this.pathUtil.getWorkspacePath(user);
        org.gcube.common.storagehub.model.Path trashPath = this.pathUtil.getTrashPath(user, (Session)session);
        try {
            Node workspaceNode = session.getNode(workspacePath.toPath());
            List workspaceItems = Utils.getItemList((Node)workspaceNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null).stream().filter(i -> !i.isShared()).collect(Collectors.toList());
            this.trashHandler.removeOnlyNodesContent((Session)session, workspaceItems);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.warn("{} workspace dir {} was already deleted", (Object)user, (Object)homePath.toPath());
        }
        try {
            Node trashNode = session.getNode(trashPath.toPath());
            List trashItems = Utils.getItemList((Node)trashNode, (List)Excludes.ALL, null, (boolean)true, null);
            this.trashHandler.removeOnlyNodesContent((Session)session, trashItems);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.warn("{} trash dir {} was already deleted", (Object)user, (Object)homePath.toPath());
        }
        try {
            Node homeNode = session.getNode(homePath.toPath());
            homeNode.remove();
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.warn("{} home dir {} was already deleted", (Object)user, (Object)homePath.toPath());
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserManager.java", UserManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createUser", "org.gcube.data.access.storagehub.services.UserManager", "java.lang.String:java.lang.String", "user:password", "", "java.lang.String"), 167);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUser", "org.gcube.data.access.storagehub.services.UserManager", "java.lang.String", "user", "", "java.lang.String"), 225);
    }
}

