package org.gcube.data.access.storagehub.services;


import static org.gcube.data.access.storagehub.Roles.INFRASTRUCTURE_MANAGER_ROLE;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;

import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("")
public abstract class Impersonable {

	Logger log = LoggerFactory.getLogger(Impersonable.class);	
			
	String currentUser;
	
	@RequestScoped
	@Inject
	public void setCurrentUser(@Context final HttpServletRequest request) {
		
		String impersonate = request!=null ? request.getParameter("impersonate") : null ; 
		ClientInfo info = AuthorizationProvider.instance.get().getClient();
		if(impersonate!=null && info.getRoles().contains(INFRASTRUCTURE_MANAGER_ROLE)) {
			this.currentUser = impersonate;
		} else 
			this.currentUser = info.getId();
		
		log.info("called with login {} and impersonate {}",info.getId(), impersonate);
	}
	
}
