package org.gcube.data.access.storagehub.handlers.vres;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;

import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.scope.impl.ScopeBean.Type;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.PathUtil;
import org.gcube.data.access.storagehub.handlers.GroupHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VREManager {

	private static final Logger logger = LoggerFactory.getLogger(VREManager.class);
	
	private Map<String, VRE> vreMap = new HashMap<>();
	
	@Inject 
	RepositoryInitializer repository;
	
	@Inject
	Node2ItemConverter node2Item;
	
	@Inject
	PathUtil pathUtil;
	
	@Inject 
	GroupHandler groupHandler;
	
	ExecutorService executor = Executors.newFixedThreadPool(5);
	
	SimpleCredentials credentials;
	
	@Inject
	public VREManager(ServletContext context) {
		credentials = new SimpleCredentials(context.getInitParameter(Constants.ADMIN_PARAM_NAME),context.getInitParameter(Constants.ADMIN_PARAM_PWD).toCharArray());
	}
	
	
	public synchronized VRE getVRE(String completeName) {
		logger.trace("requesting VRE {}",completeName);
		if (vreMap.containsKey(completeName))
			return vreMap.get(completeName);
		else 
			return null;
		
	}
	
	private synchronized VRE putVRE(Item vreFolder) {
		logger.trace("inserting VRE {}",vreFolder.getTitle());
		if (vreMap.containsKey(vreFolder.getTitle())) throw new RuntimeException("something went wrong (vre already present in the map)");
		else {
			VRE toReturn = new VRE(vreFolder, repository.getRepository(), credentials, node2Item, executor);
			vreMap.put(vreFolder.getTitle(), toReturn);
			return toReturn;
		}
		
	}

	public synchronized VRE getVreFolderItem(JackrabbitSession ses, String userId, List<String> excludes ) throws RepositoryException, StorageHubException{
		ScopeBean bean = new ScopeBean(ScopeProvider.instance.get());
		if (!bean.is(Type.VRE)) throw new BackendGenericError("the current scope is not a VRE");
		String entireScopeName= bean.toString().replaceAll("^/(.*)/?$", "$1").replaceAll("/", "-");
		return getVreFolderItemByGroupName(ses, entireScopeName, userId, excludes);
	}
	
	
	public synchronized VRE getVreFolderItemByGroupName(JackrabbitSession ses, String groupName, String userId,  List<String> excludes ) throws RepositoryException, StorageHubException{
		UserManager um = ses.getUserManager();
		Group groupAuth = um.getAuthorizable(groupName, Group.class);
		User userAuth = um.getAuthorizable(userId, User.class);
		
		if (groupAuth == null || userAuth == null || !groupAuth.isMember(userAuth))
			throw new InvalidCallParameters("error getting VRE with user "+userId+" for group "+groupName);
		
		
		VRE vre = this.getVRE(groupName);
		if (vre!=null) return vre;
		else {
			
			Node vreFolderNode = groupHandler.getFolderNodeRelatedToGroup(ses, groupName);

			Item vreFolder = node2Item.getItem(vreFolderNode, excludes);
			return this.putVRE(vreFolder);
		}	
	}

	
}
