/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.vres;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VREQueryRetriever
implements Callable<List<Item>> {
    private static final Logger logger = LoggerFactory.getLogger(VREQueryRetriever.class);
    private static final int CACHE_DIMENSION = 50;
    private Repository repository;
    private Credentials credentials;
    private Item vreFolder;
    Map<String, Long> cachedList = new HashMap(50);
    long higherTimestamp = Long.MAX_VALUE;
    long lastTimestamp = 0L;
    Node2ItemConverter node2Item;

    public VREQueryRetriever(Repository repository, Credentials credentials, Node2ItemConverter node2Item, Item vreFolder) {
        this.repository = repository;
        this.credentials = credentials;
        this.vreFolder = vreFolder;
        this.node2Item = node2Item;
    }

    @Override
    public List<Item> call() {
        logger.debug("executing recents task for {}", (Object)this.vreFolder.getTitle());
        Session ses = null;
        try {
            ses = this.repository.login(this.credentials);
            this.init(ses);
            List list = this.correctValues(ses);
            return list;
        }
        catch (Exception e) {
            logger.error("error preparing recents for folder {}", (Object)this.vreFolder.getTitle(), (Object)e);
            List<Item> list = Collections.emptyList();
            return list;
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
            logger.debug("recents task finished");
        }
    }

    private List<Item> correctValues(Session ses) {
        List cachedIds;
        logger.debug("preparing returning values for {}", (Object)this.vreFolder.getTitle());
        long start = System.currentTimeMillis();
        LinkedList list = new LinkedList(this.cachedList.entrySet());
        list.sort((c1, c2) -> ((Long)c1.getValue()).compareTo((Long)c2.getValue()) * -1);
        if (list.size() > 50) {
            int index = 49;
            while (index < list.size()) {
                this.cachedList.remove(((Map.Entry)list.get(index)).getKey());
                ++index;
            }
        }
        if ((cachedIds = list.stream().map(m -> (String)m.getKey()).collect(Collectors.toList())).size() > 10) {
            cachedIds.subList(0, 10);
        }
        ArrayList<Item> result = new ArrayList<Item>(10);
        for (String id : cachedIds) {
            try {
                Item item = this.node2Item.getItem(id, ses, Excludes.EXCLUDE_ACCOUNTING);
                if (item != null) {
                    result.add(item);
                    continue;
                }
                logger.warn("item with id {} is null", (Object)id);
            }
            catch (RepositoryException | BackendGenericError throwable) {}
        }
        logger.debug("returning values prepared in {} for {}", (Object)(System.currentTimeMillis() - start), (Object)this.vreFolder.getTitle());
        return result;
    }

    private void insertItemInTheRightPlace(Item item) {
        long lastModifiedTime = item.getLastModificationTime().getTime().getTime();
        if (lastModifiedTime <= this.higherTimestamp || this.cachedList.size() <= 50) {
            this.cachedList.put(item.getId(), lastModifiedTime);
            if (lastModifiedTime > this.higherTimestamp) {
                this.higherTimestamp = lastModifiedTime;
            }
        }
    }

    private void init(Session ses) {
        try {
            long start = System.currentTimeMillis();
            Calendar now = Calendar.getInstance();
            now.add(1, -1);
            this.lastTimestamp = System.currentTimeMillis();
            Node vreFolderNode = ses.getNodeByIdentifier(this.vreFolder.getId());
            logger.debug("starting visiting children for {}", (Object)this.vreFolder.getTitle());
            this.visitChildren(vreFolderNode);
            logger.debug("initializing recents for {} took {}", (Object)this.vreFolder.getTitle(), (Object)(System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            logger.error("error querying vre {}", (Object)this.vreFolder.getTitle(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void visitChildren(Node node) throws Exception {
        NodeIterator nodeIt = node.getNodes();
        while (nodeIt.hasNext()) {
            Node child = nodeIt.nextNode();
            Item item = this.node2Item.getItem(child, Excludes.ALL);
            if (item == null || item.isHidden()) continue;
            if (item instanceof FolderItem) {
                this.visitChildren(child);
                continue;
            }
            if (!(item instanceof AbstractFileItem)) continue;
            this.insertItemInTheRightPlace(item);
        }
    }
}

