/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services.delegates;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.services.interfaces.ACLManagerInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ACLManagerDelegate
implements ACLManagerInterface {
    @Inject
    Node2ItemConverter node2Item;
    private static final Logger log = LoggerFactory.getLogger(ACLManagerDelegate.class);

    public List<ACL> get(Item item, Session session) throws RepositoryException, BackendGenericError {
        ArrayList<ACL> acls = new ArrayList<ACL>();
        if (!item.isShared()) {
            return acls;
        }
        Node toRetrieve = (Node)item.getRelatedNode();
        if (!(item instanceof SharedFolder)) {
            toRetrieve = this.retrieveSharedFolderParent(toRetrieve, session);
        }
        JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)session, (String)toRetrieve.getPath());
        AccessControlEntry[] accessControlEntryArray = accessControlList.getAccessControlEntries();
        int n = accessControlEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessControlEntry aclEntry = accessControlEntryArray[n2];
            ACL acl = new ACL();
            acl.setPricipal(aclEntry.getPrincipal().getName());
            ArrayList<AccessType> types = new ArrayList<AccessType>();
            Privilege[] privilegeArray = aclEntry.getPrivileges();
            int n3 = privilegeArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Privilege priv = privilegeArray[n4];
                try {
                    types.add(AccessType.fromValue((String)priv.getName()));
                }
                catch (Exception e) {
                    log.warn(String.valueOf(priv.getName()) + " cannot be mapped to AccessTypes", (Throwable)e);
                }
                ++n4;
            }
            acl.setAccessTypes(types);
            acls.add(acl);
            ++n2;
        }
        return acls;
    }

    private Node retrieveSharedFolderParent(Node node, Session session) throws BackendGenericError, RepositoryException {
        if (this.node2Item.checkNodeType(node, SharedFolder.class)) {
            return node;
        }
        return this.retrieveSharedFolderParent(node.getParent(), session);
    }

    public void update(String targetUser, SharedFolder folder, AccessType accessType, Session session) throws RepositoryException, StorageHubException {
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)folder.getPath());
        Principal principal = AccessControlUtils.getPrincipal((Session)session, (String)targetUser);
        this._remove(acls, principal);
        Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(accessType.getValue())};
        acls.addAccessControlEntry(principal, userPrivileges);
        acm.setPolicy(folder.getPath(), (AccessControlPolicy)acls);
        session.save();
    }

    public void delete(String targetUser, SharedFolder folder, Session session) throws RepositoryException {
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)folder.getPath());
        Principal principal = AccessControlUtils.getPrincipal((Session)session, (String)targetUser);
        this._remove(acls, principal);
        acm.setPolicy(folder.getPath(), (AccessControlPolicy)acls);
    }

    private void _remove(JackrabbitAccessControlList acls, Principal principal) throws RepositoryException {
        AccessControlEntry aceToDelete = null;
        AccessControlEntry[] accessControlEntryArray = acls.getAccessControlEntries();
        int n = accessControlEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessControlEntry ace = accessControlEntryArray[n2];
            if (ace.getPrincipal().equals(principal)) {
                aceToDelete = ace;
                break;
            }
            ++n2;
        }
        if (aceToDelete != null) {
            acls.removeAccessControlEntry(aceToDelete);
        }
    }
}

