package org.gcube.data.access.storagehub.services.admin;

import java.util.List;
import java.util.function.Predicate;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.scripting.ScriptUtil;

@Singleton
public class ScriptUtilImpl implements ScriptUtil {
	
	@Inject Node2ItemConverter node2Item;
	
	@Override
	public List<Item> getChildren(Predicate<Node> checker, Node parent, List<String> excludes, boolean showHidden, Class<? extends Item> nodeTypeToInclude) throws RepositoryException, BackendGenericError {
		return Utils.getItemList(checker, parent, excludes, new Range(0, 100), showHidden, nodeTypeToInclude);
	}

	@Override
	public Item getItem(Node node, List<String> excludes) throws RepositoryException, BackendGenericError {
		return node2Item.getItem(node, excludes);
	}

}
