/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.compress.archivers.ArchiveException;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.items.ItemHandler;
import org.gcube.data.access.storagehub.handlers.items.builders.ArchiveStructureCreationParameter;
import org.gcube.data.access.storagehub.handlers.items.builders.CreateParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.FileCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.FolderCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.GCubeItemCreationParameters;
import org.gcube.data.access.storagehub.handlers.items.builders.ItemsParameterBuilder;
import org.gcube.data.access.storagehub.handlers.items.builders.URLCreationParameters;
import org.gcube.data.access.storagehub.services.Impersonable;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class ItemsCreator
extends Impersonable {
    private static final Logger log = LoggerFactory.getLogger(ItemsCreator.class);
    @Context
    ServletContext context;
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    ItemHandler itemHandler;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}/create/FOLDER")
    public Response createFolder(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="hidden") boolean hidden) {
        InnerMethodName.instance.set("createItem(FOLDER)");
        log.info("create folder item called");
        Session ses = null;
        String toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            ItemsParameterBuilder builder = FolderCreationParameters.builder().name(name).description(description).hidden(hidden).on(id).with(ses).author(this.currentUser);
            toReturn = this.itemHandler.create((CreateParameters)((FolderCreationParameters)builder.build()));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return Response.ok(toReturn).build();
            ses.logout();
            return Response.ok(toReturn).build();
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
            return Response.ok(toReturn).build();
        }
        catch (Throwable e) {
            log.error("unexpected error", e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
            if (ses == null) return Response.ok(toReturn).build();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return Response.ok(toReturn).build();
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return Response.ok(toReturn).build();
        ses.logout();
        return Response.ok(toReturn).build();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}/create/EXTERNALFOLDER")
    public Response createExternalFolder(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="hidden") boolean hidden, @FormParam(value="pluginName") String pluginName, @FormParam(value="parameters") String pluginParameters) {
        InnerMethodName.instance.set("createItem(EXTERNALFOLDER)");
        log.info("create folder item called");
        Session ses = null;
        String toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            ItemsParameterBuilder builder = FolderCreationParameters.builder().name(name).description(description).onRepository(pluginName).withParameters(null).hidden(hidden).on(id).with(ses).author(this.currentUser);
            toReturn = this.itemHandler.create((CreateParameters)((FolderCreationParameters)builder.build()));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return Response.ok(toReturn).build();
            ses.logout();
            return Response.ok(toReturn).build();
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
            return Response.ok(toReturn).build();
        }
        catch (Throwable e) {
            log.error("unexpected error", e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
            if (ses == null) return Response.ok(toReturn).build();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return Response.ok(toReturn).build();
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return Response.ok(toReturn).build();
        ses.logout();
        return Response.ok(toReturn).build();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}/create/URL")
    public Response createURL(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="value") URL value) {
        InnerMethodName.instance.set("createItem(URL)");
        log.info("create url called");
        Session ses = null;
        String toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            ItemsParameterBuilder builder = URLCreationParameters.builder().name(name).description(description).url(value).on(id).with(ses).author(this.currentUser);
            toReturn = this.itemHandler.create((CreateParameters)((URLCreationParameters)builder.build()));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return Response.ok(toReturn).build();
            ses.logout();
            return Response.ok(toReturn).build();
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
            return Response.ok(toReturn).build();
        }
        catch (Throwable e) {
            log.error("unexpected error", e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
            if (ses == null) return Response.ok(toReturn).build();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return Response.ok(toReturn).build();
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return Response.ok(toReturn).build();
        ses.logout();
        return Response.ok(toReturn).build();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/create/GCUBEITEM")
    public String createGcubeItem(@PathParam(value="id") String id, GCubeItem item) {
        InnerMethodName.instance.set("createItem(GCUBEITEM)");
        log.info("create Gcube item called");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                ItemsParameterBuilder builder = GCubeItemCreationParameters.builder().item(item).on(id).with(ses).author(this.currentUser);
                toReturn = this.itemHandler.create((CreateParameters)((GCubeItemCreationParameters)builder.build()));
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/{id}/create/FILE")
    public String createFileItem(@PathParam(value="id") String id, @FormDataParam(value="name") String name, @FormDataParam(value="description") String description, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.instance.set("createItem(FILE)");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                ItemsParameterBuilder builder = FileCreationParameters.builder().name(name).description(description).stream(stream).fileDetails(fileDetail).on(id).with(ses).author(this.currentUser);
                toReturn = this.itemHandler.create((CreateParameters)((FileCreationParameters)builder.build()));
            }
            catch (RepositoryException re) {
                log.error("jcr error creating file item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating file item", (Throwable)re));
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
        }
        finally {
            if (ses != null && ses.isLive()) {
                log.info("session closed");
                ses.logout();
            }
        }
        return toReturn;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/{id}/create/ARCHIVE")
    public String uploadArchive(@PathParam(value="id") String id, @FormDataParam(value="parentFolderName") String parentFolderName, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.instance.set("createItem(ARCHIVE)");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                ItemsParameterBuilder builder = ArchiveStructureCreationParameter.builder().parentName(parentFolderName).stream(stream).fileDetails(fileDetail).on(id).with(ses).author(this.currentUser);
                toReturn = this.itemHandler.create((CreateParameters)((ArchiveStructureCreationParameter)builder.build()));
                return toReturn;
            }
            catch (IOException | RepositoryException | ArchiveException re) {
                log.error("jcr error extracting archive", re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }
}

