/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.io.InputStream;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.common.storagehub.model.storages.StorageBackendFactory;
import org.gcube.data.access.storagehub.storage.backend.impl.GCubeStorageBackend;

@Singleton
public class StorageBackendHandler {
    @Inject
    @Any
    private Instance<StorageBackendFactory<? extends StorageBackend>> backends;
    @Inject
    private GCubeStorageBackend defaultBackend;

    public String move(Item item, FolderItem destination) {
        return this.defaultBackend.move(((AbstractFileItem)item).getContent().getStorageId());
    }

    public String copy(AbstractFileItem item) {
        return this.defaultBackend.copy(item.getContent().getStorageId(), item.getContent().getRemotePath());
    }

    public MetaInfo upload(InputStream stream, String itemPath) {
        return this.defaultBackend.upload(stream, itemPath);
    }

    public InputStream download(String id) {
        return this.defaultBackend.getContent(id);
    }

    public void delete(String id) {
        this.defaultBackend.delete(id);
    }

    public String getTotalVolume() {
        return this.defaultBackend.getTotalSizeStored();
    }

    public String getTotalItemsCount() {
        return this.defaultBackend.getTotalItemsCount();
    }
}

