package org.gcube.data.access.storagehub.handlers.items.builders;

import java.util.Objects;

public class FolderCreationParameters extends CreateParameters {
	
	String name;
	String description; 
	boolean hidden = false;
	
	
	protected FolderCreationParameters() {}

	public String getName() {
		return name;
	}

	public String getDescription() {
		return description;
	}

	public boolean isHidden() {
		return hidden;
	}

	@Override
	protected boolean isValid() {
		return Objects.nonNull(name) && Objects.nonNull(description);
	}

	@Override
	public String toString() {
		return "FolderCreationParameters [name=" + name + ", description=" + description + ", hidden=" + hidden
				+ ", parentId=" + parentId + ", session=" + session + ", user=" + user + "]";
	}
	
	
	public static FolderCreationBuilder builder() {
		return new FolderCreationBuilder();
	}
	
	public static class FolderCreationBuilder extends ItemsParameterBuilder<FolderCreationParameters>{

		private FolderCreationBuilder() {
			super(new FolderCreationParameters());
		}
		
		public FolderCreationBuilder name(String name) {
			parameters.name = name;
			return this;		
		}

		public FolderCreationBuilder description(String description) {
			parameters.description = description;
			return this;
		}
		
		public FolderCreationBuilder hidden(boolean hidden) {
			parameters.hidden = hidden;
			return this;
		}

	}

	@Override
	public ManagedType getMangedType() {
		return ManagedType.FOLDER;
	}
}
