package org.gcube.data.access.storagehub.services.admin;

import static org.gcube.data.access.storagehub.Roles.INFRASTRUCTURE_MANAGER_ROLE;

import java.util.ArrayList;
import java.util.List;

import javax.enterprise.context.RequestScoped;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import org.apache.jackrabbit.api.JackrabbitSession;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.exception.MyAuthException;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("admin/nodes")
public class NodeManagerAdmin {
	
	private static final Logger log = LoggerFactory.getLogger(NodeManagerAdmin.class);
	
	RepositoryInitializer repository = StorageHubAppllicationManager.repository;

	@Context ServletContext context;
	
	@RequestScoped
	@PathParam("id") 
	String id;
	
	@GET
	@Produces(MediaType.TEXT_PLAIN)
	@Path("byPath")
	@AuthorizationControl(allowedRoles = {INFRASTRUCTURE_MANAGER_ROLE},exception=MyAuthException.class)
	public String getNode(@QueryParam("path") String path){
		InnerMethodName.instance.set("getNodeByPathAdmin");

		String toReturn= null;
		Session session = null;
		try{
			session = (JackrabbitSession) repository.getRepository().login(CredentialHandler.getAdminCredentials(context));
			
			Node node = session.getNode(path);
			toReturn = infoNodeParser(node);
		}catch(RepositoryException re ){
			log.error("jcr error getting children by path", re);
			GXOutboundErrorResponse.throwException(new BackendGenericError(re));
		}finally{
			if (session!=null) {
				session.logout();
			}
		}
		return toReturn;
	}
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("{id}/children")
	@AuthorizationControl(allowedRoles = {INFRASTRUCTURE_MANAGER_ROLE},exception=MyAuthException.class)
	public List<String> getNodes(@QueryParam("pattern") String namePattern){
		InnerMethodName.instance.set("getNodesChildrenAdmin");

		List<String> nodes =new ArrayList<>();
		Session session = null;
		try{
			session = (JackrabbitSession) repository.getRepository().login(CredentialHandler.getAdminCredentials(context));
			
			Node nodeParent = session.getNodeByIdentifier(id);
			NodeIterator nIt = null;
			if (namePattern==null)
				 nIt = nodeParent.getNodes();
			else
				nIt = nodeParent.getNodes(namePattern);
			while (nIt.hasNext()) {
				Node node = nIt.nextNode();
				nodes.add(infoNodeParser(node));
			}
			
		}catch(RepositoryException re ){
			log.error("jcr error getting children by path", re);
			GXOutboundErrorResponse.throwException(new BackendGenericError(re));
		} finally{
			if (session!=null) {
				session.logout();
			}
		}
		return nodes;
	}

	private String infoNodeParser(Node node) throws RepositoryException {
		/*
		PropertyIterator pIt = node.getProperties();
		while (pIt.hasNext()) {
			Property prop = pIt.nextProperty();
			prop.get
		}*/
			
		return node.getIdentifier()+" "+node.getName()+" "+node.getPrimaryNodeType().getName();
	}

}
