/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.storage.backend.impl;

import java.io.InputStream;
import javax.inject.Singleton;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class GCubeStorageBackend
implements StorageBackend {
    private static final Logger log = LoggerFactory.getLogger(GCubeStorageBackend.class);
    private static final String SERVICE_NAME = "home-library";
    private static final String SERVICE_CLASS = "org.gcube.portlets.user";

    public InputStream getContent(String id) {
        return GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient().get().RFileAsInputStream(id);
    }

    public String getName() {
        return GCubeStorageBackend.class.getName();
    }

    public String copy(String idToCopy, String path) {
        String newStorageID = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient().copyFile(true).from(idToCopy).to(path);
        log.info("copying storage Id {} to newPath {} and the id returned by storage is {}", new Object[]{idToCopy, path, newStorageID});
        return newStorageID;
    }

    public String move(String idToMove) {
        return idToMove;
    }

    public MetaInfo upload(InputStream stream, String itemPath) {
        log.debug("uploading file");
        IClient storageClient = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient();
        String storageId = storageClient.put(true).LFile(stream).RFile(itemPath);
        long size = storageClient.getSize().RFileById(storageId);
        MetaInfo info = new MetaInfo();
        info.setSize(size);
        info.setStorageId(storageId);
        info.setRemotePath(itemPath);
        return info;
    }

    public void delete(String id) {
        log.debug("deleting");
        IClient storageClient = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient();
        storageClient.remove().RFileById(id);
    }

    private static StorageClient getStorageClient(String login) {
        return new StorageClient("org.gcube.portlets.user", "home-library", login, AccessType.SHARED, MemoryType.PERSISTENT);
    }

    public String getTotalSizeStored() {
        IClient storageClient = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient();
        return storageClient.getTotalUserVolume();
    }

    public String getTotalItemsCount() {
        IClient storageClient = GCubeStorageBackend.getStorageClient((String)AuthorizationProvider.instance.get().getClient().getId()).getClient();
        return storageClient.getUserTotalItems();
    }
}

