/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventJournal;
import javax.jcr.query.Query;
import org.apache.jackrabbit.util.ISO9075;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.NodeChildrenFilterIterator;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VREQueryRetriever
implements Callable<List<Item>> {
    private static final Logger logger = LoggerFactory.getLogger(VREQueryRetriever.class);
    private static final int CACHE_DIMENSION = 50;
    private Repository repository;
    private Credentials credentials;
    private Item vreFolder;
    List<Item> cachedList = new ArrayList(50);
    long lastTimestamp = 0L;
    private Node2ItemConverter node2Item = new Node2ItemConverter();

    public VREQueryRetriever(Repository repository, Credentials credentials, Item vreFolder) {
        this.repository = repository;
        this.credentials = credentials;
        this.vreFolder = vreFolder;
    }

    @Override
    public List<Item> call() {
        logger.trace("executing recents task");
        Session ses = null;
        if (this.lastTimestamp == 0L) {
            try {
                long start = System.currentTimeMillis();
                ses = this.repository.login(this.credentials);
                Calendar now = Calendar.getInstance();
                now.add(1, -1);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.ENGLISH);
                String formattedDate = formatter.format(now.getTime());
                String xpath = String.format("/jcr:root%s//element(*,nthl:workspaceLeafItem)[@jcr:lastModified>xs:dateTime('%s')] order by @jcr:lastModified descending", ISO9075.encodePath((String)this.vreFolder.getPath()), formattedDate);
                logger.debug("query for recents is {}", (Object)xpath);
                Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
                jcrQuery.setLimit(50L);
                this.lastTimestamp = System.currentTimeMillis();
                NodeChildrenFilterIterator it = new NodeChildrenFilterIterator(jcrQuery.execute().getNodes());
                logger.debug("query for recents took {}", (Object)(System.currentTimeMillis() - start));
                while (it.hasNext()) {
                    Node node = it.next();
                    Item item = this.node2Item.getItem(node, Excludes.EXCLUDE_ACCOUNTING);
                    logger.debug("RECENTS - adding item {} with timestamp {}", (Object)item.getTitle(), (Object)item.getLastModificationTime().getTimeInMillis());
                    this.cachedList.add(item);
                }
                logger.debug("creating objects took {}", (Object)(System.currentTimeMillis() - start));
                if (this.cachedList.size() <= 10) {
                    List list = this.cachedList;
                    return list;
                }
                List<Item> list = this.cachedList.subList(0, 10);
                return list;
            }
            catch (Exception e) {
                logger.error("error querying vre {}", (Object)this.vreFolder.getTitle(), (Object)e);
                throw new RuntimeException(e);
            }
            finally {
                if (ses != null) {
                    ses.logout();
                }
                logger.trace("recents task finished");
            }
        }
        try {
            long timestampToUse = this.lastTimestamp;
            this.lastTimestamp = System.currentTimeMillis();
            long start = System.currentTimeMillis();
            ses = this.repository.login(this.credentials);
            String[] types = new String[]{"nthl:workspaceLeafItem", "nthl:workspaceItem"};
            EventJournal journalChanged = ses.getWorkspace().getObservationManager().getEventJournal(51, this.vreFolder.getPath(), true, null, types);
            journalChanged.skipTo(timestampToUse);
            logger.trace("getting the journal took {}", (Object)(System.currentTimeMillis() - start));
            int events = 0;
            block19: while (journalChanged.hasNext()) {
                ++events;
                Event event = journalChanged.nextEvent();
                switch (event.getType()) {
                    case 1: {
                        Node nodeAdded;
                        if (!ses.nodeExists(event.getPath()) || !(nodeAdded = ses.getNode(event.getPath())).isNodeType("nthl:workspaceLeafItem")) continue block19;
                        logger.trace("node added event received with name {}", (Object)nodeAdded.getName());
                        Item item = this.node2Item.getItem(nodeAdded, Arrays.asList("hl:accounting"));
                        this.insertItemInTheRightPlace(item);
                        break;
                    }
                    case 16: {
                        Property property;
                        if (!ses.propertyExists(event.getPath()) || !(property = ses.getProperty(event.getPath())).getName().equalsIgnoreCase("jcr:lastModified")) continue block19;
                        logger.trace("event property changed on {} with value {} and parent {}", new Object[]{property.getName(), property.getValue().getString(), property.getParent().getPath()});
                        String identifier = property.getParent().getIdentifier();
                        this.cachedList.removeIf(i -> i.getId().equals(identifier));
                        Item item = this.node2Item.getItem(property.getParent(), Excludes.EXCLUDE_ACCOUNTING);
                        this.insertItemInTheRightPlace(item);
                        break;
                    }
                    case 2: {
                        logger.trace("node removed event received with type {}", (Object)event.getIdentifier());
                        this.cachedList.removeIf(i -> {
                            try {
                                return i.getId().equals(event.getIdentifier()) && i.getLastModificationTime().getTime().getTime() < event.getDate();
                            }
                            catch (RepositoryException repositoryException) {
                                return false;
                            }
                        });
                        break;
                    }
                    case 32: {
                        Node nodeMoved = ses.getNode(event.getPath());
                        logger.trace("node moved event received with type {}", (Object)nodeMoved.getPrimaryNodeType());
                        if (!nodeMoved.isNodeType("nthl:workspaceLeafItem")) continue block19;
                        logger.trace("event node moved on {} with path {}", (Object)nodeMoved.getName(), (Object)nodeMoved.getPath());
                        String identifier = nodeMoved.getIdentifier();
                        this.cachedList.removeIf(i -> i.getId().equals(identifier) && !i.getPath().startsWith(this.vreFolder.getPath()));
                        break;
                    }
                    default: {
                        throw new Exception("error in event handling");
                    }
                }
            }
            if (this.cachedList.size() > 50) {
                this.cachedList.subList(51, this.cachedList.size()).clear();
            }
            logger.trace("retrieving event took {} with {} events", (Object)(System.currentTimeMillis() - start), (Object)events);
            if (this.cachedList.size() <= 10) {
                List list = this.cachedList;
                return list;
            }
            List<Item> list = this.cachedList.subList(0, 10);
            return list;
        }
        catch (Exception e) {
            logger.error("error getting events for vre {}", (Object)this.vreFolder.getTitle(), (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private void insertItemInTheRightPlace(Item item) {
        Iterator it = this.cachedList.iterator();
        int index = 0;
        while (it.hasNext()) {
            Item inListItem = (Item)it.next();
            if (item.getLastModificationTime().getTime().getTime() >= inListItem.getLastModificationTime().getTime().getTime()) break;
            ++index;
        }
        if (index < 50) {
            this.cachedList.add(index, item);
        }
    }
}

