/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.StorageBackendHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TrashHandler {
    private static Logger log = LoggerFactory.getLogger(TrashHandler.class);
    ExecutorService executor = Executors.newFixedThreadPool(100);
    @Inject
    VersionHandler versionHandler;
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    StorageBackendHandler storageHandler;

    public void removeNodes(Session ses, List<Item> itemsToDelete) throws RepositoryException, StorageHubException {
        log.debug("defnitively removing nodes with ids {}", itemsToDelete);
        for (Item item : itemsToDelete) {
            this.removeNodesInternally(ses, item);
        }
    }

    private void removeNodesInternally(Session ses, Item itemToDelete) throws RepositoryException, StorageHubException {
        try {
            HashSet contentIdsToDelete = new HashSet();
            Node nodeToDelete = ses.getNodeByIdentifier(itemToDelete.getId());
            if (itemToDelete instanceof TrashItem) {
                List trashChildren = Utils.getItemList((Node)nodeToDelete, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null);
                for (Item itemContentToRetrieve : trashChildren) {
                    Utils.getAllContentIds((Session)ses, contentIdsToDelete, (Item)itemContentToRetrieve, (VersionHandler)this.versionHandler);
                }
            } else {
                Utils.getAllContentIds((Session)ses, contentIdsToDelete, (Item)itemToDelete, (VersionHandler)this.versionHandler);
            }
            nodeToDelete.remove();
            log.debug("content ids to remove are {}", contentIdsToDelete);
            Runnable deleteFromStorageRunnable = AuthorizedTasks.bind((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            this.executor.execute(deleteFromStorageRunnable);
            ses.save();
        }
        catch (LockException e) {
            throw new ItemLockedException("the selected node or his parent is locked", (Throwable)e);
        }
        catch (Exception e) {
            throw new BackendGenericError("error permanetly deleting items", (Throwable)e);
        }
    }

    public void moveToTrash(Session ses, Node nodeToDelete, Item item) throws RepositoryException, BackendGenericError {
        log.debug("moving node {} to trash ", (Object)item.getId());
        Node trashFolder = ses.getNode(Paths.append((Path)Utils.getWorkspacePath(), (String)"Trash").toPath());
        String login = AuthorizationProvider.instance.get().getClient().getId();
        try {
            try {
                ses.getWorkspace().getLockManager().lock(trashFolder.getPath(), true, true, 0L, login);
                ses.getWorkspace().getLockManager().lock(nodeToDelete.getPath(), true, true, 0L, login);
                log.debug("preparing thrash item");
                TrashItem trashItem = new TrashItem();
                trashItem.setDeletedBy(AuthorizationProvider.instance.get().getClient().getId());
                trashItem.setDeletedFrom(nodeToDelete.getParent().getPath());
                Calendar now = Calendar.getInstance();
                trashItem.setDeletedTime(now);
                trashItem.setHidden(false);
                trashItem.setLastAction(ItemAction.CREATED);
                trashItem.setDescription("trash item of node " + nodeToDelete.getPath());
                trashItem.setParentId(trashFolder.getIdentifier());
                trashItem.setParentPath(trashFolder.getPath());
                trashItem.setTitle(item.getTitle());
                trashItem.setName(item.getId());
                trashItem.setOriginalParentId(nodeToDelete.getParent().getIdentifier());
                trashItem.setOwner(login);
                trashItem.setLastModificationTime(item.getLastModificationTime());
                trashItem.setLastModifiedBy(item.getLastModifiedBy());
                trashItem.setLenght(0L);
                if (item instanceof FolderItem) {
                    trashItem.setFolder(true);
                } else if (item instanceof AbstractFileItem) {
                    AbstractFileItem file = (AbstractFileItem)item;
                    if (file.getContent() != null) {
                        trashItem.setMimeType(file.getContent().getMimeType());
                        trashItem.setLenght(file.getContent().getSize().longValue());
                    }
                    trashItem.setFolder(false);
                }
                log.debug("creating node");
                Node newTrashItemNode = this.item2Node.getNode(trashFolder, (Item)trashItem);
                ses.save();
                log.debug("calling jcr move");
                ses.getWorkspace().move(nodeToDelete.getPath(), Paths.append((Path)Paths.getPath((String)newTrashItemNode.getPath()), (String)nodeToDelete.getName()).toPath());
                String mimetype = null;
                if (item instanceof AbstractFileItem) {
                    if (((AbstractFileItem)item).getContent() != null) {
                        mimetype = ((AbstractFileItem)item).getContent().getMimeType();
                    } else {
                        log.warn("the AbstractFileItem with id {} has no content (check it!!)", (Object)item.getId());
                    }
                }
                this.accountingHandler.createFolderRemoveObj(item.getName(), item.getClass().getSimpleName(), mimetype, ses, ses.getNodeByIdentifier(item.getParentId()), true);
            }
            catch (Throwable t) {
                log.error("error exceuting move to trash", t);
                throw new BackendGenericError(t);
            }
        }
        finally {
            ses.getWorkspace().getLockManager().unlock(nodeToDelete.getPath());
            ses.getWorkspace().getLockManager().unlock(trashFolder.getPath());
        }
    }

    public String restoreItem(Session ses, TrashItem item, FolderItem destination) throws RepositoryException, StorageHubException, BackendGenericError {
        String newNodePath;
        block11: {
            log.debug("restoring node from trash");
            String login = AuthorizationProvider.instance.get().getClient().getId();
            Node destinationNode = null;
            if (destination == null) {
                boolean originalParentExists = true;
                boolean originalParentTrashed = false;
                Node originalParent = null;
                try {
                    originalParent = ses.getNodeByIdentifier(item.getOriginalParentId());
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    originalParentExists = false;
                }
                Item originalParentItem = null;
                if (originalParentExists) {
                    originalParentItem = this.node2Item.getItem(originalParent, Excludes.ALL);
                    originalParentTrashed = originalParentItem.isTrashed();
                }
                if (originalParentExists && !originalParentTrashed) {
                    destinationNode = originalParent;
                } else {
                    Node node;
                    String homeWS = Utils.getWorkspacePath((String)login).toPath();
                    destinationNode = node = ses.getNode(homeWS);
                }
            } else {
                Node node = ses.getNodeByIdentifier(destination.getId());
                if (!this.node2Item.checkNodeType(node, FolderItem.class)) {
                    throw new InvalidCallParameters("destination Node is not a folder");
                }
                destinationNode = node;
            }
            this.authChecker.checkWriteAuthorizationControl(ses, destinationNode.getIdentifier(), true);
            ses.getWorkspace().getLockManager().lock(destinationNode.getPath(), true, true, 0L, login);
            newNodePath = null;
            try {
                List items = Utils.getItemList((Node)ses.getNodeByIdentifier(item.getId()), (List)Excludes.ALL, null, (boolean)false, null);
                if (items.size() != 1) {
                    log.warn("a problem occurred restoring item from trash");
                    throw new BackendGenericError("An error occurred on trash item");
                }
                Item itemToMove = (Item)items.get(0);
                this.item2Node.updateOwnerOnSubTree(ses.getNodeByIdentifier(itemToMove.getId()), login);
                String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destinationNode, (String)itemToMove.getName());
                newNodePath = Paths.append((Path)Paths.getPath((String)destinationNode.getPath()), (String)uniqueName).toPath();
                ses.move(itemToMove.getPath(), newNodePath);
                Utils.setPropertyOnChangeNode((Node)ses.getNode(newNodePath), (String)login, (ItemAction)ItemAction.MOVED);
                ses.removeItem(item.getPath());
                ses.save();
            }
            catch (Exception exception) {
                if (!ses.getWorkspace().getLockManager().isLocked(destinationNode.getPath())) break block11;
                ses.getWorkspace().getLockManager().unlock(destinationNode.getPath());
            }
        }
        return ses.getNode(newNodePath).getIdentifier();
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }
}

