/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.expressions.Expression;
import org.gcube.common.storagehub.model.expressions.logical.And;
import org.gcube.common.storagehub.model.expressions.logical.ISDescendant;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.StorageBackendHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.VRE;
import org.gcube.data.access.storagehub.handlers.VREManager;
import org.gcube.data.access.storagehub.handlers.items.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.query.sql2.evaluators.Evaluators;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class WorkspaceManager {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceManager.class);
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    Evaluators evaluator;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    ServletContext context;
    @Inject
    VREManager vreManager;
    @Inject
    TrashHandler trashHandler;
    @RequestScoped
    @QueryParam(value="exclude")
    private List<String> excludes = Collections.emptyList();
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    StorageBackendHandler storageBackend;

    @Path(value="")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getWorkspace(@QueryParam(value="relPath") String relPath) {
        Item toReturn;
        block10: {
            InnerMethodName.instance.set("getWorkspace");
            Session ses = null;
            org.gcube.common.storagehub.model.Path absolutePath = relPath == null ? Utils.getWorkspacePath() : Paths.append((org.gcube.common.storagehub.model.Path)Utils.getWorkspacePath(), (String)relPath);
            toReturn = null;
            try {
                long start = System.currentTimeMillis();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                String user = AuthorizationProvider.instance.get().getClient().getId();
                org.gcube.common.storagehub.model.Path trashPath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getWorkspacePath(), (String)"Trash");
                if (!ses.nodeExists(trashPath.toPath())) {
                    Utils.createFolderInternally((Session)ses, (Node)ses.getNode(Utils.getWorkspacePath().toPath()), (String)"Trash", (String)("trash of " + user), (boolean)false, (String)user, null);
                    ses.save();
                }
                log.trace("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
                Node node = ses.getNode(absolutePath.toPath());
                this.authChecker.checkReadAuthorizationControl(ses, node.getIdentifier());
                toReturn = this.node2Item.getItem(node, this.excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting workspace item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block10;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block10;
            ses.logout();
        }
        return new ItemWrapper(toReturn);
    }

    @Path(value="vrefolder")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getVreRootFolder() {
        Item vreItem;
        block9: {
            InnerMethodName.instance.set("getVreRootFolder");
            Session ses = null;
            vreItem = null;
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                vreItem = Utils.getVreFolderItem((Session)ses, (Node2ItemConverter)this.node2Item, (VREManager)this.vreManager, (List)this.excludes).getVreFolder();
            }
            catch (RepositoryException re) {
                log.error("jcr error getting vrefolder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemWrapper(vreItem);
    }

    @Path(value="vrefolder/recents")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFolderRecentsDocument() {
        InnerMethodName.instance.set("getVreFolderRecents");
        Session ses = null;
        List recentItems = Collections.emptyList();
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            VRE vre = Utils.getVreFolderItem((Session)ses, (Node2ItemConverter)this.node2Item, (VREManager)this.vreManager, (List)this.excludes);
            log.trace("VRE retrieved {}", (Object)vre.getVreFolder().getTitle());
            recentItems = vre.getRecents();
            log.trace("recents retrieved {}", (Object)vre.getVreFolder().getTitle());
            ItemList itemList = new ItemList(recentItems);
            return itemList;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting recents", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(recentItems);
    }

    @Path(value="trash")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getTrashRootFolder() {
        Item item;
        block9: {
            InnerMethodName.instance.set("getTrashRootFolder");
            Session ses = null;
            org.gcube.common.storagehub.model.Path trashPath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getWorkspacePath(), (String)"Trash");
            item = null;
            try {
                long start = System.currentTimeMillis();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
                Node folder = ses.getNode(trashPath.toPath());
                item = this.node2Item.getItem(folder, this.excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting trash", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemWrapper(item);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Path(value="trash/empty")
    @DELETE
    public String emptyTrash() {
        InnerMethodName.instance.set("emptyTrash");
        Session ses = null;
        org.gcube.common.storagehub.model.Path trashPath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getWorkspacePath(), (String)"Trash");
        String toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node trashNode = ses.getNode(trashPath.toPath());
                List itemsToDelete = Utils.getItemList((Node)trashNode, (List)Excludes.ALL, null, (boolean)true, null);
                this.trashHandler.removeNodes(ses, itemsToDelete);
                toReturn = trashNode.getIdentifier();
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("jcr error emptying trash", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="trash/restore")
    public String restoreItem(@FormParam(value="trashedItemId") String trashedItemId, @FormParam(value="destinationId") String destinationFolderId) {
        InnerMethodName.instance.set("restoreItem");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                log.info("restoring node with id {}", (Object)trashedItemId);
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node nodeToRestore = ses.getNodeByIdentifier(trashedItemId);
                Item itemToRestore = this.node2Item.getItem(nodeToRestore, Excludes.ALL);
                if (!(itemToRestore instanceof TrashItem)) {
                    throw new InvalidItemException("Only trash items can be restored");
                }
                String user = AuthorizationProvider.instance.get().getClient().getId();
                org.gcube.common.storagehub.model.Path trashPath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getWorkspacePath(), (String)"Trash");
                if (!itemToRestore.getPath().startsWith(trashPath.toPath())) {
                    throw new UserNotAuthorizedException("this item is not in the user " + user + " trash");
                }
                Item destinationItem = null;
                if (destinationFolderId != null) {
                    destinationItem = this.node2Item.getItem(ses.getNodeByIdentifier(destinationFolderId), Excludes.ALL);
                    if (!(destinationItem instanceof FolderItem)) {
                        throw new InvalidCallParameters("destintation item is not a folder");
                    }
                    toReturn = this.trashHandler.restoreItem(ses, (TrashItem)itemToRestore, (FolderItem)destinationItem);
                    return toReturn;
                } else {
                    toReturn = this.trashHandler.restoreItem(ses, (TrashItem)itemToRestore, null);
                }
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("error restoring item with id {}", (Object)trashedItemId, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @Path(value="vrefolders")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFolders() {
        List toReturn;
        block9: {
            InnerMethodName.instance.set("getVreFolders");
            Session ses = null;
            org.gcube.common.storagehub.model.Path vrePath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getWorkspacePath(), (String)"MySpecialFolders");
            toReturn = null;
            try {
                log.info("vres folder path is {}", (Object)vrePath.toPath());
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                toReturn = Utils.getItemList((Node)ses.getNode(vrePath.toPath()), (List)this.excludes, null, (boolean)false, null);
            }
            catch (RepositoryException re) {
                log.error("error reading the node children of {}", (Object)vrePath, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemList(toReturn);
    }

    @Path(value="vrefolders/paged")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFoldersPaged(@QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        List toReturn;
        block9: {
            InnerMethodName.instance.set("getVreFoldersPaged");
            Session ses = null;
            org.gcube.common.storagehub.model.Path vrePath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getWorkspacePath(), (String)"MySpecialFolders");
            toReturn = null;
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                toReturn = Utils.getItemList((Node)ses.getNode(vrePath.toPath()), (List)this.excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)false, null);
            }
            catch (RepositoryException re) {
                log.error("(paged) error reading the node children of {}", (Object)vrePath, (Object)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block9;
            ses.logout();
        }
        return new ItemList(toReturn);
    }

    @Path(value="query")
    @GET
    @Produces(value={"application/json"})
    public ItemList searchItems(@QueryParam(value="n") String node, @QueryParam(value="e") String jsonExpr, @QueryParam(value="o") List<String> orderField, @QueryParam(value="l") Integer limit, @QueryParam(value="f") Integer offset) {
        ArrayList<Item> toReturn;
        block13: {
            InnerMethodName.instance.set("searchItems");
            Session ses = null;
            toReturn = new ArrayList<Item>();
            try {
                ObjectMapper mapper = new ObjectMapper();
                Expression expression = (Expression)mapper.readValue(jsonExpr, Expression.class);
                String stringExpression = this.evaluator.evaluate((Expression)new And((Expression)new ISDescendant(Utils.getWorkspacePath()), expression, new Expression[0]));
                String orderBy = "";
                if (orderField != null && orderField.size() > 0) {
                    orderBy = String.format("ORDER BY %s", orderField.stream().collect(Collectors.joining(",")).toString());
                }
                String sql2Query = String.format("SELECT * FROM [%s] AS node WHERE %s %s ", node, stringExpression, orderBy);
                log.info("query sent is {}", (Object)sql2Query);
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(sql2Query, "JCR-SQL2");
                if (limit != null && limit != -1) {
                    jcrQuery.setLimit((long)limit.intValue());
                }
                if (offset != null && offset != -1) {
                    jcrQuery.setOffset((long)offset.intValue());
                }
                QueryResult result = jcrQuery.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    toReturn.add(this.node2Item.getItem(it.nextNode(), null));
                }
            }
            catch (IOException | RepositoryException re) {
                log.error("error executing the query", re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(re));
                if (ses != null) {
                    ses.logout();
                }
                break block13;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block13;
            ses.logout();
        }
        return new ItemList(toReturn);
    }

    @Path(value="count")
    @GET
    public String getTotalItemsCount() {
        InnerMethodName.instance.set("getTotalItemsCount");
        return this.storageBackend.getTotalItemsCount();
    }

    @Path(value="size")
    @GET
    public String getTotalVolume() {
        InnerMethodName.instance.set("getTotalSize");
        return this.storageBackend.getTotalVolume();
    }
}

