/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.VreFolder;
import org.gcube.common.storagehub.model.types.ACLList;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.UnshareHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class ACLManager {
    private static final Logger log = LoggerFactory.getLogger(ACLManager.class);
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    UnshareHandler unshareHandler;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    AuthorizationChecker authChecker;

    @GET
    @Path(value="{id}/acls")
    @Produces(value={"application/json"})
    public ACLList getACL() {
        ArrayList<ACL> acls;
        block13: {
            InnerMethodName.instance.set("getACLById");
            Session ses = null;
            acls = new ArrayList<ACL>();
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                String path = ses.getNodeByIdentifier(this.id).getPath();
                log.info("checking acces for path {}", (Object)path);
                JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)ses, (String)path);
                AccessControlEntry[] accessControlEntryArray = accessControlList.getAccessControlEntries();
                int n = accessControlEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AccessControlEntry aclEntry = accessControlEntryArray[n2];
                    ACL acl = new ACL();
                    acl.setPricipal(aclEntry.getPrincipal().getName());
                    ArrayList<AccessType> types = new ArrayList<AccessType>();
                    Privilege[] privilegeArray = aclEntry.getPrivileges();
                    int n3 = privilegeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Privilege priv = privilegeArray[n4];
                        try {
                            types.add(AccessType.fromValue((String)priv.getName()));
                        }
                        catch (Exception e) {
                            log.warn(String.valueOf(priv.getName()) + " cannot be mapped to AccessTypes", (Throwable)e);
                        }
                        ++n4;
                    }
                    acl.setAccessTypes(types);
                    acls.add(acl);
                    ++n2;
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error getting acl", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting acl", (Throwable)re));
                if (ses != null) {
                    ses.logout();
                }
                break block13;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block13;
            ses.logout();
        }
        return new ACLList(acls);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Consumes(value={"multipart/form-data"})
    @Path(value="{id}/acls")
    public void setACL(@FormDataParam(value="user") String user, @FormDataParam(value="access") AccessType accessType) {
        InnerMethodName.instance.set("setACLById");
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node node = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(node, Excludes.ALL);
                if (!(item instanceof SharedFolder)) {
                    throw new InvalidItemException("the item is not a shared folder");
                }
                if (item.getOwner().equals(user)) {
                    throw new UserNotAuthorizedException("owner acl cannot be changed");
                }
                this.authChecker.checkAdministratorControl(ses, (SharedFolder)item);
                SharedFolder folder = (SharedFolder)item;
                if (folder.isVreFolder()) {
                    if (accessType == AccessType.ADMINISTRATOR) {
                        throw new InvalidCallParameters("A group of a VRE cannot be set as ADMINISTRATOR");
                    }
                    if (!user.equals(folder.getTitle())) {
                        throw new InvalidCallParameters("the groupId in the argument is different to the one of the VREFolder");
                    }
                    AccessControlManager acm = ses.getAccessControlManager();
                    JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)folder.getPath());
                    Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(accessType.getValue())};
                    AccessControlEntry aceToDelete = null;
                    Principal principal = AccessControlUtils.getPrincipal((Session)ses, (String)user);
                    AccessControlEntry[] accessControlEntryArray = acls.getAccessControlEntries();
                    int n = accessControlEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AccessControlEntry ace = accessControlEntryArray[n2];
                        if (ace.getPrincipal().equals(principal)) {
                            aceToDelete = ace;
                            break;
                        }
                        ++n2;
                    }
                    if (aceToDelete != null) {
                        acls.removeAccessControlEntry(aceToDelete);
                    }
                    acls.addAccessControlEntry(principal, userPrivileges);
                    acm.setPolicy(folder.getPath(), (AccessControlPolicy)acls);
                    ses.save();
                    return;
                } else {
                    NodeIterator sharedSet = node.getSharedSet();
                    boolean found = false;
                    while (sharedSet.hasNext() && !found) {
                        Node current = sharedSet.nextNode();
                        if (!current.getPath().startsWith(Utils.getWorkspacePath((String)user).toPath())) continue;
                        found = true;
                    }
                    if (!found) {
                        throw new InvalidCallParameters("shared folder with id " + item.getId() + " is not shared with user " + user);
                    }
                    String path = node.getPath();
                    AccessControlManager acm = ses.getAccessControlManager();
                    JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)path);
                    Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(accessType.getValue())};
                    AccessControlEntry aceToDelete = null;
                    Principal principal = AccessControlUtils.getPrincipal((Session)ses, (String)user);
                    AccessControlEntry[] accessControlEntryArray = acls.getAccessControlEntries();
                    int n = accessControlEntryArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        AccessControlEntry ace = accessControlEntryArray[n3];
                        if (ace.getPrincipal().equals(principal)) {
                            aceToDelete = ace;
                            break;
                        }
                        ++n3;
                    }
                    if (aceToDelete != null) {
                        acls.removeAccessControlEntry(aceToDelete);
                    }
                    acls.addAccessControlEntry(principal, userPrivileges);
                    acm.setPolicy(path, (AccessControlPolicy)acls);
                    ses.save();
                }
                return;
            }
            catch (RepositoryException re) {
                log.error("jcr error extracting archive", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error setting acl", (Throwable)re));
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return;
                ses.logout();
                return;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Consumes(value={"text/plain"})
    @Path(value="{id}/acls/{user}")
    public void removeACL(@PathParam(value="user") String user) {
        InnerMethodName.instance.set("removeACLById");
        Session ses = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                String login = AuthorizationProvider.instance.get().getClient().getId();
                Node node = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(node, Excludes.ALL);
                if (!(item instanceof SharedFolder)) {
                    throw new InvalidItemException("the item is not a shared folder");
                }
                if (item instanceof VreFolder || ((SharedFolder)item).isVreFolder()) {
                    throw new InvalidCallParameters("acls in vreFolder cannot be removed with this method");
                }
                this.authChecker.checkAdministratorControl(ses, (SharedFolder)item);
                this.unshareHandler.unshare(ses, Collections.singleton(user), node, login);
                return;
            }
            catch (RepositoryException re) {
                log.error("jcr error extracting archive", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error setting acl", (Throwable)re));
                if (ses == null) return;
                ses.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return;
                ses.logout();
                return;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Path(value="{id}/acls/write")
    public Boolean canWriteInto() {
        InnerMethodName.instance.set("canWriteIntoFolder");
        Session ses = null;
        Boolean canWrite = false;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node node = ses.getNodeByIdentifier(this.id);
            Item item = this.node2Item.getItem(node, Excludes.ALL);
            if (!(item instanceof FolderItem)) {
                throw new InvalidItemException("this method can be applied only to folder");
            }
            try {
                this.authChecker.checkWriteAuthorizationControl(ses, this.id, true);
            }
            catch (UserNotAuthorizedException userNotAuthorizedException) {
                Boolean bl = false;
                if (ses != null) {
                    ses.logout();
                }
                return bl;
            }
            Boolean bl = true;
            return bl;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting acl", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting acl", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return canWrite;
    }
}

