/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services.admin;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.exception.MyAuthException;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="admin")
public class ItemManagerAdmin {
    private static final Logger log;
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    TrashHandler trashHandler;
    @Context
    ServletContext context;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        ItemManagerAdmin.ajc$preClinit();
        log = LoggerFactory.getLogger(ItemManagerAdmin.class);
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="items/{id}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public String createItem(@PathParam(value="id") String id, Item item) {
        String string = id;
        Item item2 = item;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)item2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("creteItemAdmin)");
        return null;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{user}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public ItemWrapper<Item> getWorkspace(@PathParam(value="user") String user) {
        Item item;
        block9: {
            String string = user;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
            AuthorizationAspect.aspectOf().before(joinPoint);
            InnerMethodName.instance.set("getWorkspaceAdmin");
            item = null;
            JackrabbitSession session = null;
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                String workspacePath = Utils.getWorkspacePath((String)user).toPath();
                Node node = session.getNode(workspacePath);
                item = this.node2Item.getItem(node, Collections.emptyList());
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (session != null) {
                    session.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            if (session == null) break block9;
            session.logout();
        }
        return new ItemWrapper(item);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="items/{id}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public ItemWrapper<Item> getItem(@PathParam(value="id") String id) {
        Item item;
        block9: {
            String string = id;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
            AuthorizationAspect.aspectOf().before(joinPoint);
            InnerMethodName.instance.set("getChildrenAdmin");
            item = null;
            JackrabbitSession session = null;
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node node = session.getNodeByIdentifier(id);
                item = this.node2Item.getItem(node, Collections.emptyList());
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (session != null) {
                    session.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            if (session == null) break block9;
            session.logout();
        }
        return new ItemWrapper(item);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Produces(value={"application/json"})
    @Path(value="items/{id}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public void deleteItem(@PathParam(value="id") String id) {
        String string = id;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("getChildrenAdmin");
        JackrabbitSession session = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node node = session.getNodeByIdentifier(id);
                Item item = this.node2Item.getItem(node, Excludes.GET_ONLY_CONTENT);
                this.trashHandler.removeNodes((Session)session, Collections.singletonList(item));
                return;
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (session == null) return;
                session.logout();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return;
                session.logout();
                return;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="items/{id}/children")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public ItemList getChildren(@PathParam(value="id") String id) {
        List items;
        block9: {
            String string = id;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string);
            AuthorizationAspect.aspectOf().before(joinPoint);
            InnerMethodName.instance.set("getChildrenAdmin");
            items = null;
            JackrabbitSession session = null;
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node node = session.getNodeByIdentifier(id);
                items = Utils.getItemList((Node)node, Collections.emptyList(), null, (boolean)true, null);
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (session != null) {
                    session.logout();
                }
                break block9;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block9;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (session != null) {
                        session.logout();
                    }
                }
            }
            if (session == null) break block9;
            session.logout();
        }
        return new ItemList(items);
    }

    @PUT
    @Consumes(value={"text/plain"})
    @Path(value="items/{id}/{propertyName}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public void setProperty(@PathParam(value="id") String id, @PathParam(value="propertyName") String propertyName, String value) {
        String string = id;
        String string2 = propertyName;
        String string3 = value;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("setPropertyAdmin");
        JackrabbitSession session = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node node = session.getNodeByIdentifier(id);
                node.setProperty(propertyName, value);
                session.save();
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ItemManagerAdmin.java", ItemManagerAdmin.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createItem", "org.gcube.data.access.storagehub.services.admin.ItemManagerAdmin", "java.lang.String:org.gcube.common.storagehub.model.items.Item", "id:item", "", "java.lang.String"), 65);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getWorkspace", "org.gcube.data.access.storagehub.services.admin.ItemManagerAdmin", "java.lang.String", "user", "", "org.gcube.common.storagehub.model.service.ItemWrapper"), 75);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getItem", "org.gcube.data.access.storagehub.services.admin.ItemManagerAdmin", "java.lang.String", "id", "", "org.gcube.common.storagehub.model.service.ItemWrapper"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteItem", "org.gcube.data.access.storagehub.services.admin.ItemManagerAdmin", "java.lang.String", "id", "", "void"), 133);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getChildren", "org.gcube.data.access.storagehub.services.admin.ItemManagerAdmin", "java.lang.String", "id", "", "org.gcube.common.storagehub.model.service.ItemList"), 164);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProperty", "org.gcube.data.access.storagehub.services.admin.ItemManagerAdmin", "java.lang.String:java.lang.String:java.lang.String", "id:propertyName:value", "", "void"), 193);
    }
}

