package org.gcube.data.access.storagehub.services.admin;

import static org.gcube.data.access.storagehub.Roles.*;

import java.util.Collections;
import java.util.List;

import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.jackrabbit.api.JackrabbitSession;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.exception.MyAuthException;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("admin")
public class ItemManagerAdmin {

	private static final Logger log = LoggerFactory.getLogger(ItemManagerAdmin.class);
	
	RepositoryInitializer repository = StorageHubAppllicationManager.repository;

	@Inject 
	Node2ItemConverter node2Item;

	@Context ServletContext context;
	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("items/{id}")
	@AuthorizationControl(allowedRoles = {INFRASTRUCTURE_MANAGER_ROLE},exception=MyAuthException.class)
	public String createItem(@PathParam("id") String id, Item item) {
		InnerMethodName.instance.set("creteItemAdmin)");
		//TODO: implement this method
		return null;
	}

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("{user}")
	@AuthorizationControl(allowedRoles = {INFRASTRUCTURE_MANAGER_ROLE},exception=MyAuthException.class)
	public ItemWrapper<Item> getWorkspace(@PathParam("user") String user) {
		InnerMethodName.instance.set("getWorkspaceAdmin");

		Item item =null;
		Session session = null;
		try{
			session = (JackrabbitSession) repository.getRepository().login(CredentialHandler.getAdminCredentials(context));
			String workspacePath = Utils.getWorkspacePath(user).toPath();
			Node node = session.getNode(workspacePath);
			item = node2Item.getItem(node, Collections.emptyList());
			
		}catch(RepositoryException re ){
			log.error("jcr error moving item", re);
			GXOutboundErrorResponse.throwException(new BackendGenericError(re));
		}catch(StorageHubException she ){
			log.error(she.getErrorMessage(), she);
			GXOutboundErrorResponse.throwException(she, Response.Status.fromStatusCode(she.getStatus()));
		} finally{
			if (session!=null) {
				session.logout();
			}
		}
		return new ItemWrapper<Item>(item);
	}
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("items/{id}")
	@AuthorizationControl(allowedRoles = {INFRASTRUCTURE_MANAGER_ROLE},exception=MyAuthException.class)
	public ItemWrapper<Item> getItem(@PathParam("id") String id) {
		InnerMethodName.instance.set("getChildrenAdmin");

		Item item =null;
		Session session = null;
		try{
			session = (JackrabbitSession) repository.getRepository().login(CredentialHandler.getAdminCredentials(context));
			Node node = session.getNodeByIdentifier(id);
			
			item = node2Item.getItem(node, Collections.emptyList());
			
		}catch(RepositoryException re ){
			log.error("jcr error moving item", re);
			GXOutboundErrorResponse.throwException(new BackendGenericError(re));
		}catch(StorageHubException she ){
			log.error(she.getErrorMessage(), she);
			GXOutboundErrorResponse.throwException(she, Response.Status.fromStatusCode(she.getStatus()));
		} finally{
			if (session!=null) {
				session.logout();
			}
		}
		return new ItemWrapper<Item>(item);
	}
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("items/{id}/children")
	@AuthorizationControl(allowedRoles = {INFRASTRUCTURE_MANAGER_ROLE},exception=MyAuthException.class)
	public ItemList getChildren(@PathParam("id") String id) {
		InnerMethodName.instance.set("getChildrenAdmin");

		List<Item> items =null;
		Session session = null;
		try{
			session = (JackrabbitSession) repository.getRepository().login(CredentialHandler.getAdminCredentials(context));
			Node node = session.getNodeByIdentifier(id);
			
			items = Utils.getItemList(node, Collections.emptyList(), null, true, null);
			
		}catch(RepositoryException re ){
			log.error("jcr error moving item", re);
			GXOutboundErrorResponse.throwException(new BackendGenericError(re));
		}catch(StorageHubException she ){
			log.error(she.getErrorMessage(), she);
			GXOutboundErrorResponse.throwException(she, Response.Status.fromStatusCode(she.getStatus()));
		} finally{
			if (session!=null) {
				session.logout();
			}
		}
		return new ItemList(items);
	}
	
	@PUT
	@Consumes(MediaType.TEXT_PLAIN)
	@Path("items/{id}/{propertyName}")
	@AuthorizationControl(allowedRoles = {INFRASTRUCTURE_MANAGER_ROLE},exception=MyAuthException.class)
	public void setProperty(@PathParam("id") String id, @PathParam("propertyName") String propertyName, String value) {
		InnerMethodName.instance.set("setPropertyAdmin");

		Session session = null;
		try{
			session = (JackrabbitSession) repository.getRepository().login(CredentialHandler.getAdminCredentials(context));
			Node node = session.getNodeByIdentifier(id);
			node.setProperty(propertyName, value);
			session.save();
			
		}catch(RepositoryException re ){
			log.error("jcr error moving item", re);
			GXOutboundErrorResponse.throwException(new BackendGenericError(re));
		} finally{
			if (session!=null) {
				session.logout();
			}
		}
		
	}
	
}
