/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.items;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.annotations.Attribute;
import org.gcube.common.storagehub.model.annotations.AttributeRootNode;
import org.gcube.common.storagehub.model.annotations.ListNodes;
import org.gcube.common.storagehub.model.annotations.MapAttribute;
import org.gcube.common.storagehub.model.annotations.NodeAttribute;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.data.access.storagehub.handlers.ClassHandler;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Singleton
public class Node2ItemConverter {
    private static final Logger logger = LoggerFactory.getLogger(Node2ItemConverter.class);
    private static HashMap<Class, Map<String, Class>> typeToSubtypeMap = new HashMap();

    public <T extends Item> T getFilteredItem(Node node, List<String> excludes, Class<? extends Item> nodeTypeToInclude) throws RepositoryException, BackendGenericError {
        Class classToHandle = ClassHandler.instance().get(node.getPrimaryNodeType().getName());
        if (classToHandle == null) {
            return null;
        }
        if (nodeTypeToInclude != null && !nodeTypeToInclude.isAssignableFrom(classToHandle)) {
            return null;
        }
        return (T)this.retrieveItem(node, excludes, classToHandle);
    }

    public <T extends Item> T getItem(String nodeIdentifier, Session session, List<String> excludes) throws RepositoryException, BackendGenericError {
        Node node = session.getNodeByIdentifier(nodeIdentifier);
        return (T)this.getItem(node, excludes);
    }

    public <T extends Item> T getItem(Node node, List<String> excludes) throws RepositoryException, BackendGenericError {
        Class classToHandle = ClassHandler.instance().get(node.getPrimaryNodeType().getName());
        if (classToHandle == null) {
            return null;
        }
        return (T)this.retrieveItem(node, excludes, classToHandle);
    }

    private <T extends Item> T retrieveItem(Node node, List<String> excludes, Class<T> classToHandle) throws RepositoryException, BackendGenericError {
        Item item;
        try {
            item = (Item)classToHandle.newInstance();
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
        item.setId(node.getIdentifier());
        item.setName(Text.unescapeIllegalJcrChars((String)node.getName()));
        item.setPath(Text.unescapeIllegalJcrChars((String)node.getPath()));
        item.setLocked(node.isLocked());
        item.setPrimaryType(node.getPrimaryNodeType().getName());
        Item parent = null;
        if (item instanceof SharedFolder) {
            logger.trace("I'm in a Shared Folder");
            item.setShared(true);
        } else {
            try {
                parent = this.getItem(node.getParent(), Excludes.ALL);
                item.setShared(parent.isShared());
            }
            catch (Exception exception) {
                item.setShared(false);
            }
        }
        if (item instanceof TrashItem) {
            item.setTrashed(true);
        } else {
            try {
                if (parent == null) {
                    parent = this.getItem(node.getParent(), Excludes.ALL);
                }
                item.setTrashed(parent.isTrashed());
            }
            catch (Exception exception) {
                item.setTrashed(false);
            }
        }
        try {
            item.setParentId(node.getParent().getIdentifier());
            item.setParentPath(node.getParent().getPath());
        }
        catch (Throwable throwable) {
            logger.trace("Root node doesn't have a parent");
        }
        for (Field field : Node2ItemConverter.retrieveAllFields(classToHandle)) {
            if (field.isAnnotationPresent(Attribute.class)) {
                Attribute attribute = field.getAnnotation(Attribute.class);
                field.setAccessible(true);
                try {
                    Class<?> returnType = field.getType();
                    field.set(item, this.getPropertyValue(returnType, node.getProperty(attribute.value())));
                    logger.trace("retrieve item - added field {}", (Object)field.getName());
                }
                catch (PathNotFoundException pathNotFoundException) {
                    logger.trace("the current node dosn't contain {} property", (Object)attribute.value());
                }
                catch (Exception exception) {
                    logger.debug("error setting value for property {} ", (Object)attribute.value());
                }
                continue;
            }
            if (!field.isAnnotationPresent(NodeAttribute.class)) continue;
            String fieldNodeName = field.getAnnotation(NodeAttribute.class).value();
            if (excludes != null && excludes.contains(fieldNodeName)) continue;
            logger.trace("retrieving field node " + field.getName());
            field.setAccessible(true);
            try {
                Node fieldNode = node.getNode(fieldNodeName);
                logger.trace("looking in node {} searched with {}", (Object)fieldNode.getName(), (Object)fieldNodeName);
                field.set(item, this.iterateNodeAttributeFields(field.getType(), fieldNode));
            }
            catch (PathNotFoundException pathNotFoundException) {
                logger.trace("the current node dosn't contain {} node", (Object)fieldNodeName);
            }
            catch (Exception e) {
                logger.debug("error setting value", (Throwable)e);
            }
        }
        return (T)item;
    }

    private <T> T iterateNodeAttributeFields(Class<T> clazz, Node node) throws Exception {
        T obj = clazz.newInstance();
        for (Field field : Node2ItemConverter.retrieveAllFields(clazz)) {
            String exclude;
            if (field.isAnnotationPresent(Attribute.class)) {
                Attribute attribute = field.getAnnotation(Attribute.class);
                field.setAccessible(true);
                try {
                    Class<?> returnType = field.getType();
                    field.set(obj, this.getPropertyValue(returnType, node.getProperty(attribute.value())));
                }
                catch (PathNotFoundException pathNotFoundException) {
                    logger.trace("the current node dosn't contain {} property", (Object)attribute.value());
                }
                catch (Exception e) {
                    logger.debug("error setting value {}", (Object)e.getMessage());
                }
                continue;
            }
            if (field.isAnnotationPresent(MapAttribute.class)) {
                logger.trace("found field {} of type annotated as MapAttribute in class {} and node name {}", new Object[]{field.getName(), clazz.getName(), node.getName()});
                field.setAccessible(true);
                exclude = field.getAnnotation(MapAttribute.class).excludeStartWith();
                HashMap<String, Object> mapToset = new HashMap<String, Object>();
                PropertyIterator iterator = node.getProperties();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Property prop = iterator.nextProperty();
                        if (!exclude.isEmpty() && prop.getName().startsWith(exclude)) continue;
                        try {
                            logger.trace("adding {} in the map", (Object)prop.getName());
                            mapToset.put(prop.getName(), this.getPropertyValue(prop));
                        }
                        catch (PathNotFoundException pathNotFoundException) {
                            logger.warn("the property {}  is not mapped", (Object)prop.getName());
                        }
                        catch (Exception e) {
                            logger.debug("error setting value {}", (Object)e.getMessage());
                        }
                    }
                }
                field.set(obj, mapToset);
                continue;
            }
            if (!field.isAnnotationPresent(ListNodes.class)) continue;
            logger.trace("found field {} of type annotated as ListNodes in class {} on node {}", new Object[]{field.getName(), clazz.getName(), node.getName()});
            field.setAccessible(true);
            exclude = field.getAnnotation(ListNodes.class).excludeTypeStartWith();
            String include = field.getAnnotation(ListNodes.class).includeTypeStartWith();
            Class listType = field.getAnnotation(ListNodes.class).listClass();
            HashMap<String, Class> subTypesMap = Collections.emptyMap();
            if (!typeToSubtypeMap.containsKey(listType)) {
                ConfigurationBuilder config = new ConfigurationBuilder().forPackages(new String[]{listType.getPackage().getName()});
                Reflections reflections = new Reflections((Configuration)config);
                Set subTypes = reflections.getSubTypesOf(listType);
                if (subTypes.size() > 0) {
                    subTypesMap = new HashMap<String, Class>();
                    for (Class subtype : subTypes) {
                        if (!subtype.isAnnotationPresent(AttributeRootNode.class)) continue;
                        AttributeRootNode attributeRootNode = subtype.getAnnotation(AttributeRootNode.class);
                        subTypesMap.put(attributeRootNode.value(), subtype);
                    }
                } else {
                    logger.trace("no subtypes found for {}", (Object)listType.getName());
                }
                typeToSubtypeMap.put(listType, subTypesMap);
            } else {
                logger.info("subtypes already found in cache");
                subTypesMap = (HashMap<String, Class>)typeToSubtypeMap.get(listType);
            }
            ArrayList<Object> toSetList = new ArrayList<Object>();
            NodeIterator iterator = node.getNodes();
            while (iterator.hasNext()) {
                Node currentNode = iterator.nextNode();
                String primaryType = currentNode.getPrimaryNodeType().getName();
                logger.trace("the current node {} has a list", (Object)currentNode.getName());
                if (!include.isEmpty() && !primaryType.startsWith(include) || !exclude.isEmpty() && primaryType.startsWith(exclude)) continue;
                if (subTypesMap.containsKey(primaryType)) {
                    toSetList.add(this.iterateNodeAttributeFields((Class)subTypesMap.get(primaryType), currentNode));
                    continue;
                }
                toSetList.add(this.iterateNodeAttributeFields(listType, currentNode));
            }
            if (toSetList.size() == 0) continue;
            field.set(obj, toSetList);
        }
        return obj;
    }

    private Object getPropertyValue(Class returnType, Property prop) throws Exception {
        if (returnType.equals(String.class)) {
            return prop.getString();
        }
        if (returnType.isEnum()) {
            return Enum.valueOf(returnType, prop.getString());
        }
        if (returnType.equals(Calendar.class)) {
            return prop.getDate();
        }
        if (returnType.equals(URL.class)) {
            return new URI(prop.getString()).toURL();
        }
        if (returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE)) {
            return prop.getBoolean();
        }
        if (returnType.equals(Long.class) || returnType.equals(Long.TYPE)) {
            return prop.getLong();
        }
        if (returnType.equals(Integer.class) || returnType.equals(Integer.TYPE)) {
            return prop.getLong();
        }
        if (returnType.isArray()) {
            if (prop.getType() == 2) {
                byte[] bytes = IOUtils.toByteArray((InputStream)prop.getBinary().getStream());
                return bytes;
            }
            Object[] ret = this.getArrayValue(prop);
            return Arrays.copyOf(ret, ret.length, returnType);
        }
        throw new Exception(String.format("class %s not recognized", returnType.getName()));
    }

    private static Set<Field> retrieveAllFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> currentClass = clazz;
        do {
            List<Field> fieldsFound = Arrays.asList(currentClass.getDeclaredFields());
            fields.addAll(fieldsFound);
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return fields;
    }

    private Object getPropertyValue(Property prop) throws Exception {
        if (prop.isMultiple()) {
            Object[] values = new Object[prop.getValues().length];
            int i = 0;
            Value[] valueArray = prop.getValues();
            int n = valueArray.length;
            int n2 = 0;
            while (n2 < n) {
                Value value = valueArray[n2];
                values[i++] = this.getSingleValue(value);
                ++n2;
            }
            return values;
        }
        return this.getSingleValue(prop.getValue());
    }

    private Object getSingleValue(Value value) throws Exception {
        switch (value.getType()) {
            case 5: {
                return value.getDate();
            }
            case 6: {
                return value.getBoolean();
            }
            case 3: {
                return value.getDate();
            }
        }
        return value.getString();
    }

    private Object[] getArrayValue(Property prop) throws Exception {
        Object[] values = new Object[prop.getValues().length];
        int i = 0;
        Value[] valueArray = prop.getValues();
        int n = valueArray.length;
        int n2 = 0;
        while (n2 < n) {
            Value value = valueArray[n2];
            values[i++] = this.getSingleValue(value);
            ++n2;
        }
        return values;
    }

    public boolean checkNodeType(Node node, Class<? extends Item> classToCompare) throws BackendGenericError {
        try {
            logger.trace("class from nodetype is {} and class to compare is {}", (Object)ClassHandler.instance().get(node.getPrimaryNodeType().getName()), classToCompare);
            return classToCompare.isAssignableFrom(ClassHandler.instance().get(node.getPrimaryNodeType().getName()));
        }
        catch (Throwable e) {
            throw new BackendGenericError(e);
        }
    }
}

