/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.exception.MyAuthException;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.UnshareHandler;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="users")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class UserManager {
    private static final String INFRASTRUCTURE_MANAGER_ROLE = "Infrastructure-Manager";
    @Context
    ServletContext context;
    private static final Logger log;
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    UnshareHandler unshareHandler;
    @Inject
    TrashHandler trashHandler;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        UserManager.ajc$preClinit();
        log = LoggerFactory.getLogger(UserManager.class);
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public List<String> getUsers() {
        InnerMethodName.instance.set("getUsers");
        JackrabbitSession session = null;
        ArrayList<String> users = new ArrayList<String>();
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Iterator result = session.getUserManager().findAuthorizables((org.apache.jackrabbit.api.security.user.Query)new /* Unavailable Anonymous Inner Class!! */);
                while (result.hasNext()) {
                    Authorizable user = (Authorizable)result.next();
                    log.debug("user {} found", (Object)user.getPrincipal().getName());
                    users.add(user.getPrincipal().getName());
                }
            }
            catch (Exception e) {
                log.error("jcr error getting users", (Throwable)e);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)e)));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return users;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Path(value="")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public String createUser(@FormParam(value="user") String user, @FormParam(value="password") String password) {
        String string = user;
        String string2 = password;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("createUser");
        JackrabbitSession session = null;
        String userId = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                org.apache.jackrabbit.api.security.user.UserManager usrManager = session.getUserManager();
                User createdUser = usrManager.createUser(user, password);
                userId = createdUser.getID();
                Node homeNode = session.getNode("/Home");
                Node userHome = homeNode.addNode(user, "nthl:home");
                Node workspaceFolder = Utils.createFolderInternally((Session)session, (Node)userHome, (String)"Workspace", (String)("workspace of " + user), (boolean)false, (String)user, null);
                Utils.createFolderInternally((Session)session, (Node)workspaceFolder, (String)"Trash", (String)("trash of " + user), (boolean)false, (String)user, null);
                Utils.createFolderInternally((Session)session, (Node)workspaceFolder, (String)"MySpecialFolders", (String)("special folder container of " + user), (boolean)false, (String)user, null);
                session.save();
                return userId;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error creating item", (Throwable)re)));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Path(value="{user}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public String deleteUser(@PathParam(value="user") String user) {
        String string = user;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("deleteUser");
        JackrabbitSession session = null;
        String userId = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                org.apache.jackrabbit.api.security.user.UserManager usrManager = session.getUserManager();
                org.gcube.common.storagehub.model.Path path = Utils.getWorkspacePath((String)user);
                String sql2Query = String.format("SELECT * FROM [nthl:workspaceSharedItem] AS node WHERE ISDESCENDANTNODE('%s')", path.toPath());
                log.info("query sent is {}", (Object)sql2Query);
                Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(sql2Query, "JCR-SQL2");
                QueryResult result = jcrQuery.execute();
                NodeIterator nodeIt = result.getNodes();
                while (nodeIt.hasNext()) {
                    Node rNode = nodeIt.nextNode();
                    String title = rNode.hasProperty(NodeProperty.TITLE.toString()) ? rNode.getProperty(NodeProperty.TITLE.toString()).getString() : "unknown";
                    log.debug("removing sharing for folder name {} with title {} and path {} ", new Object[]{rNode.getName(), title, rNode.getPath()});
                    this.unshareHandler.unshare((Session)session, Collections.singleton(user), rNode, user);
                }
                Authorizable authorizable = usrManager.getAuthorizable((Principal)new PrincipalImpl(user));
                if (authorizable != null && !authorizable.isGroup()) {
                    log.info("removing user {}", (Object)user);
                    authorizable.remove();
                } else {
                    log.warn("the user {} was already deleted", (Object)user);
                }
                org.gcube.common.storagehub.model.Path homePath = Utils.getHome((String)user);
                org.gcube.common.storagehub.model.Path workspacePath = Utils.getWorkspacePath((String)user);
                try {
                    Node workspaceNode = session.getNode(workspacePath.toPath());
                    Node homeNode = session.getNode(homePath.toPath());
                    List workspaceItems = Utils.getItemList((Node)workspaceNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null);
                    this.trashHandler.removeNodes((Session)session, workspaceItems);
                    homeNode.remove();
                }
                catch (PathNotFoundException pathNotFoundException) {
                    log.warn("{} home dir was already deleted", (Object)user);
                }
                session.save();
                return userId;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error creating item", (Throwable)re)));
                if (session == null) return userId;
                session.logout();
                return userId;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserManager.java", UserManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createUser", "org.gcube.data.access.storagehub.services.UserManager", "java.lang.String:java.lang.String", "user:password", "", "java.lang.String"), 109);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteUser", "org.gcube.data.access.storagehub.services.UserManager", "java.lang.String", "user", "", "java.lang.String"), 153);
    }
}

