/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.handlers.items.Node2ItemConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuthorizationChecker {
    private static Logger log = LoggerFactory.getLogger(AuthorizationChecker.class);
    @Inject
    Node2ItemConverter node2Item;

    public void checkReadAuthorizationControl(Session session, String id) throws UserNotAuthorizedException, BackendGenericError, RepositoryException {
        Node node = session.getNodeByIdentifier(id);
        String login = AuthorizationProvider.instance.get().getClient().getId();
        Item item = this.node2Item.getItem(node, Excludes.ALL);
        if (item == null) {
            throw new UserNotAuthorizedException("Insufficent Privileges for user " + login + " to read node with id " + id + ": it's  not a valid StorageHub node");
        }
        if (!item.isShared() && item.getOwner() != null && item.getOwner().equals(login)) {
            return;
        }
        if (this.hasParentPublicFolder(session, item)) {
            return;
        }
        if (item.isShared()) {
            SharedFolder parentShared = (SharedFolder)this.node2Item.getItem(this.retrieveSharedFolderParent(node, session), Excludes.EXCLUDE_ACCOUNTING);
            if (parentShared.getUsers().getMap().keySet().contains(login)) {
                return;
            }
            JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)session, (String)parentShared.getPath());
            AccessControlEntry[] entries = accessControlList.getAccessControlEntries();
            Authorizable userAuthorizable = ((JackrabbitSession)session).getUserManager().getAuthorizable(login);
            AccessControlEntry[] accessControlEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlEntry entry = accessControlEntryArray[n2];
                log.debug("checking access right for {} with compared with {}", (Object)login, (Object)entry.getPrincipal());
                Authorizable authorizable = ((JackrabbitSession)session).getUserManager().getAuthorizable(entry.getPrincipal());
                if (authorizable == null) {
                    log.warn("{} doesn't have a correspondant auhtorizable object, check it ", (Object)entry.getPrincipal());
                } else {
                    try {
                        if (!authorizable.isGroup() && entry.getPrincipal().getName().equals(login)) {
                            return;
                        }
                        if (authorizable.isGroup() && ((Group)authorizable).isMember(userAuthorizable)) {
                            return;
                        }
                    }
                    catch (Throwable e) {
                        log.warn("someting went wrong checking authorizations", e);
                    }
                }
                ++n2;
            }
            throw new UserNotAuthorizedException("Insufficent Privileges for user " + login + " to read node with id " + id);
        }
        throw new UserNotAuthorizedException("Insufficent Privileges for user " + login + " to read node with id " + id);
    }

    private boolean hasParentPublicFolder(Session session, Item item) {
        if (item.getParentPath().replaceAll("/Home/[^/]*/Workspace", "").isEmpty() || item.getParentPath().replaceAll("/Share", "").isEmpty()) {
            if (item instanceof FolderItem) {
                return ((FolderItem)item).isPublicItem();
            }
            return false;
        }
        if (item instanceof FolderItem) {
            try {
                return ((FolderItem)item).isPublicItem() || this.hasParentPublicFolder(session, this.node2Item.getItem(item.getParentId(), session, Excludes.ALL));
            }
            catch (Throwable e) {
                log.warn("error checking public parents", e);
                return false;
            }
        }
        try {
            return this.hasParentPublicFolder(session, this.node2Item.getItem(item.getParentId(), session, Excludes.ALL));
        }
        catch (Throwable e) {
            log.warn("error checking public parents", e);
            return false;
        }
    }

    private Node retrieveSharedFolderParent(Node node, Session session) throws BackendGenericError, RepositoryException {
        if (this.node2Item.checkNodeType(node, SharedFolder.class)) {
            return node;
        }
        return this.retrieveSharedFolderParent(node.getParent(), session);
    }

    public void checkWriteAuthorizationControl(Session session, Item item, Node node, boolean isNewItem) throws UserNotAuthorizedException, BackendGenericError, RepositoryException {
        String login = AuthorizationProvider.instance.get().getClient().getId();
        if (item == null) {
            throw new UserNotAuthorizedException("Not valid StorageHub node");
        }
        if (Constants.WRITE_PROTECTED_FOLDER.contains(item.getName()) || Constants.WRITE_PROTECTED_FOLDER.contains(item.getTitle())) {
            throw new UserNotAuthorizedException("Insufficent Privileges for user " + login + " to write into node with id " + item.getId() + ": it's  a protected folder");
        }
        if (item.isShared()) {
            Node parentSharedNode = this.retrieveSharedFolderParent(node, session);
            JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)session, (String)parentSharedNode.getPath());
            AccessControlEntry[] entries = accessControlList.getAccessControlEntries();
            Authorizable UserAuthorizable = ((JackrabbitSession)session).getUserManager().getAuthorizable(login);
            AccessControlEntry[] accessControlEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlEntry entry = accessControlEntryArray[n2];
                Authorizable authorizable = ((JackrabbitSession)session).getUserManager().getAuthorizable(entry.getPrincipal());
                if (!authorizable.isGroup() && entry.getPrincipal().getName().equals(login) || authorizable.isGroup() && ((Group)authorizable).isMember(UserAuthorizable)) {
                    Privilege[] privilegeArray = entry.getPrivileges();
                    int n3 = privilegeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Privilege privilege = privilegeArray[n4];
                        AccessType access = AccessType.fromValue((String)privilege.getName());
                        if (isNewItem && access != AccessType.READ_ONLY) {
                            return;
                        }
                        if (!isNewItem && (access == AccessType.ADMINISTRATOR || access == AccessType.WRITE_ALL || access == AccessType.WRITE_OWNER && item.getOwner().equals(login))) {
                            return;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        } else if (item.getOwner().equals(login)) {
            return;
        }
        throw new UserNotAuthorizedException("Insufficent Privileges for user " + login + " to write into node with id " + item.getId());
    }

    public void checkWriteAuthorizationControl(Session session, String id, boolean isNewItem) throws UserNotAuthorizedException, BackendGenericError, RepositoryException {
        Node node = session.getNodeByIdentifier(id);
        Item item = this.node2Item.getItem(node, Excludes.ALL);
        this.checkWriteAuthorizationControl(session, item, node, isNewItem);
    }

    public void checkMoveOpsForProtectedFolders(Session session, String id) throws InvalidCallParameters, BackendGenericError, RepositoryException {
        Node node = session.getNodeByIdentifier(id);
        Item item = this.node2Item.getItem(node, Excludes.ALL);
        if (Constants.PROTECTED_FOLDER.contains(item.getName()) || Constants.PROTECTED_FOLDER.contains(item.getTitle())) {
            throw new InvalidCallParameters("protected folder cannot be moved or deleted");
        }
    }

    public void checkAdministratorControl(Session session, SharedFolder item) throws UserNotAuthorizedException, BackendGenericError, RepositoryException {
        String login = AuthorizationProvider.instance.get().getClient().getId();
        if (item == null) {
            throw new UserNotAuthorizedException("Insufficent Privileges for user " + login + ": it's  not a valid StorageHub node");
        }
        Node node = session.getNodeByIdentifier(item.getId());
        if (item.isShared()) {
            Node parentSharedNode = this.retrieveSharedFolderParent(node, session);
            JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)session, (String)parentSharedNode.getPath());
            AccessControlEntry[] entries = accessControlList.getAccessControlEntries();
            SharedFolder parentShared = (SharedFolder)this.node2Item.getItem(parentSharedNode, Excludes.EXCLUDE_ACCOUNTING);
            AccessControlEntry[] accessControlEntryArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlEntry entry = accessControlEntryArray[n2];
                if (entry.getPrincipal().getName().equals(login) || parentShared.isVreFolder() && entry.getPrincipal().getName().equals(parentShared.getTitle())) {
                    Privilege[] privilegeArray = entry.getPrivileges();
                    int n3 = privilegeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Privilege privilege = privilegeArray[n4];
                        AccessType access = AccessType.fromValue((String)privilege.getName());
                        if (access == AccessType.ADMINISTRATOR) {
                            return;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        throw new UserNotAuthorizedException("The user " + login + " is not an administrator of node with id " + item.getId());
    }
}

