/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers.content;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Calendar;
import javax.imageio.ImageIO;
import org.apache.commons.io.FilenameUtils;
import org.gcube.common.storagehub.model.annotations.MimeTypeHandler;
import org.gcube.common.storagehub.model.items.ImageFile;
import org.gcube.common.storagehub.model.items.nodes.ImageContent;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.handlers.content.ContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MimeTypeHandler(value={"image/gif", "image/jpeg", "image/png"})
public class ImageHandler
implements ContentHandler {
    private static final int THUMB_MAX_DIM = 300;
    private ImageContent content = new ImageContent();
    private static final Logger logger = LoggerFactory.getLogger(ImageHandler.class);

    public void initiliseSpecificContent(InputStream is, String fileName, String mimeType) throws Exception {
        BufferedImage image = ImageIO.read(is);
        int width = ((Image)image).getWidth(null);
        int height = ((Image)image).getHeight(null);
        this.content.setWidth(Long.valueOf(width));
        this.content.setHeight(Long.valueOf(height));
        try {
            int[] dimension = this.getThumbnailDimension(width, height);
            byte[] buf = this.transform((Image)image, fileName, dimension[0], dimension[1]).toByteArray();
            this.content.setThumbnailHeight(Long.valueOf(dimension[1]));
            this.content.setThumbnailWidth(Long.valueOf(dimension[0]));
            this.content.setThumbnailData(buf);
        }
        catch (Throwable t) {
            logger.warn("thumbnail for file {} cannot be created ", (Object)fileName, (Object)t);
        }
        this.content.setMimeType(mimeType);
    }

    public ImageContent getContent() {
        return this.content;
    }

    private int[] getThumbnailDimension(int original_width, int original_height) {
        int new_width = 0;
        int new_height = 0;
        if (original_width < 300 && original_height < 300) {
            new_width = original_width;
            new_height = original_height;
        }
        if (original_width > 300) {
            new_width = 300;
            new_height = new_width * original_height / original_width;
        }
        if (original_width < 300) {
            new_width = 300;
            new_height = new_width * original_height / original_width;
        }
        if (new_height > 300) {
            new_height = 300;
            new_width = new_height * original_width / original_height;
        }
        if (new_width > 300) {
            new_width = 300;
            new_height = new_width * original_height / original_width;
        }
        int[] dimension = new int[]{new_width, new_height};
        return dimension;
    }

    public ImageFile buildItem(String name, String description, String login) {
        ImageFile item = new ImageFile();
        Calendar now = Calendar.getInstance();
        item.setName(name);
        item.setTitle(name);
        item.setDescription(description);
        item.setHidden(false);
        item.setLastAction(ItemAction.CREATED);
        item.setLastModificationTime(now);
        item.setLastModifiedBy(login);
        item.setOwner(login);
        item.setContent(this.content);
        return item;
    }

    public ByteArrayOutputStream transform(Image image, String originalFile, int thumbWidth, int thumbHeight) throws Exception {
        BufferedImage thumbImage = new BufferedImage(thumbWidth, thumbHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setBackground(Color.WHITE);
        graphics2D.setPaint(Color.WHITE);
        graphics2D.fillRect(0, 0, thumbWidth, thumbHeight);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, thumbWidth, thumbHeight, null);
        String ext = FilenameUtils.getExtension((String)originalFile);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)thumbImage, ext, os);
        return os;
    }
}

