package org.gcube.data.access.storagehub.storage.backend.impl;

import java.io.InputStream;

import javax.inject.Singleton;

import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.storages.StorageBackend;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GCubeStorageBackend implements StorageBackend {
	
	private static final Logger log = LoggerFactory.getLogger(GCubeStorageBackend.class);
	
	private final static String SERVICE_NAME 				= "home-library";	
	private final static String SERVICE_CLASS 				= "org.gcube.portlets.user";
	
	@Override
	public InputStream getContent(String id) {
		return getStorageClient(AuthorizationProvider.instance.get().getClient().getId()).getClient().get().RFileAsInputStream(id);
	}
	
	@Override
	public String getName() {
		return GCubeStorageBackend.class.getName();
	}

	@Override
	public String copy(String idToCopy, String path) {
		String newStorageID = getStorageClient(AuthorizationProvider.instance.get().getClient().getId()).getClient().copyFile(true).from(idToCopy).to(path);
		log.info("copying storage Id {} to newPath {} and the id returned by storage is {}", idToCopy, path, newStorageID);	
		return newStorageID;
	}

	@Override
	public String move(String idToMove) {
		return idToMove;
	}

	@Override
	public MetaInfo upload(InputStream stream, String itemPath) {
		log.debug("uploading file");
		IClient storageClient = getStorageClient(AuthorizationProvider.instance.get().getClient().getId()).getClient();
		String storageId =storageClient.put(true).LFile(stream).RFile(itemPath);
		long size = storageClient.getSize().RFileById(storageId);
		MetaInfo info = new MetaInfo();
		info.setSize(size);
		info.setStorageId(storageId);
		info.setRemotePath(itemPath);
		return info;
	}
	
	@Override
	public void delete(String id) {
		log.debug("deleting");
		IClient storageClient = getStorageClient(AuthorizationProvider.instance.get().getClient().getId()).getClient();
		storageClient.remove().RFileById(id);
	}
	
	private static StorageClient getStorageClient(String login){
		return new StorageClient(SERVICE_CLASS, SERVICE_NAME, login, AccessType.SHARED, MemoryType.PERSISTENT);

	}

	@Override
	public String getTotalSizeStored() {
		IClient storageClient = getStorageClient(AuthorizationProvider.instance.get().getClient().getId()).getClient();
		return storageClient.getTotalUserVolume();
	}

	@Override
	public String getTotalItemsCount() {
		IClient storageClient = getStorageClient(AuthorizationProvider.instance.get().getClient().getId()).getClient();
		return storageClient.getUserTotalItems();
	}

	
	
	

}
