package org.gcube.data.access.storagehub.handlers;

import java.io.InputStream;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.data.access.storagehub.storage.backend.impl.GCubeStorageBackend;


@Singleton
public class StorageBackendHandler {

	@Inject
	private GCubeStorageBackend defaultBackend;
	
	
	public String move(Item item, FolderItem destination) {
		//if item is a folder we have to move everything
		return defaultBackend.move(((AbstractFileItem) item).getContent().getStorageId());
	}
	
	public String copy(AbstractFileItem item) {
		return defaultBackend.copy(item.getContent().getStorageId(), item.getContent().getRemotePath());
	}
	
	public MetaInfo upload(InputStream stream, String itemPath) { 
		return defaultBackend.upload(stream, itemPath);
	}
	
	public InputStream download(String id) {
		return defaultBackend.getContent(id);
	}
	
	public void delete(String id) {
		defaultBackend.delete(id);
	}
	
	public String getTotalVolume() {
		return defaultBackend.getTotalSizeStored();
	}
	
	public String getTotalItemsCount() {
		return defaultBackend.getTotalItemsCount();
	}
	
}
