package org.gcube.data.access.storagehub;


import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.ApplicationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageHubAppllicationManager implements ApplicationManager {

	private static Logger logger = LoggerFactory.getLogger(StorageHubAppllicationManager.class);

	private boolean alreadyShutDown = false;


	public static RepositoryInitializer repository;

	@Override
	public synchronized void onInit() {
		logger.info("jackrabbit initialization started");
		try {
			repository = new RepositoryInitializerImpl();
		} catch (Exception e) {
			logger.error("ERROR INITIALIZING REPOSITORY",e);
		}
		repository.getRepository();
	}

	@Override
	public synchronized void onShutdown() {
		if (!alreadyShutDown)
			try {
				logger.info("jackrabbit is shutting down");
				repository.shutdown();
				alreadyShutDown= true;
			} catch (Exception e) {
				logger.warn("the database was not shutdown properly",e);
			}
	}

}
