package org.gcube.data.access.storagehub;

import javax.inject.Inject;
import javax.ws.rs.ext.Provider;

import org.apache.jackrabbit.api.JackrabbitRepository;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class MyApplicationListener implements ApplicationEventListener {

	private static final Logger log = LoggerFactory.getLogger(MyApplicationListener.class);
	
	@Inject 
	RepositoryInitializer repository;
	
	@Override
	public void onEvent(ApplicationEvent event) {
		log.info("StorageHub - event called");
		switch (event.getType()) {
		case DESTROY_FINISHED:
			log.info("Destroying application storageHub");
			((JackrabbitRepository) repository.getRepository()).shutdown();
			log.info("Jackrabbit repository stopped");
		default:
			break;
		}
	}

	@Override
	public RequestEventListener onRequest(RequestEvent requestEvent) {
		return null;
	}

	
}