/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.query.sql2.evaluators;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.gcube.common.storagehub.model.expressions.Expression;
import org.gcube.data.access.storagehub.query.sql2.evaluators.Evaluator;

@Singleton
public class Evaluators {
    @Inject
    Instance<Evaluator<?>> evaluators;

    public static Evaluator<Expression<?>> getEvaluator(Class<?> type, Iterable<Evaluator<Expression<?>>> evaluators) {
        for (Evaluator<Expression<?>> eval : evaluators) {
            if (!eval.getType().equals(type)) continue;
            return eval;
        }
        throw new IllegalStateException("evaluator not found for class " + type.getName());
    }

    public String evaluate(Expression<?> expression) {
        for (Evaluator eval : this.evaluators) {
            if (!eval.getType().equals(expression.getClass())) continue;
            return eval.evaluate(expression, (Iterable)this.evaluators);
        }
        throw new IllegalStateException("Evaluator not found for expression type " + expression.getClass());
    }

    public Instance<Evaluator<?>> getEvaluators() {
        return this.evaluators;
    }
}

