/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.lang.reflect.Field;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.StringValue;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.annotations.Attribute;
import org.gcube.common.storagehub.model.annotations.AttributeRootNode;
import org.gcube.common.storagehub.model.annotations.ListNodes;
import org.gcube.common.storagehub.model.annotations.MapAttribute;
import org.gcube.common.storagehub.model.annotations.NodeAttribute;
import org.gcube.common.storagehub.model.annotations.RootNode;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.ClassHandler;
import org.gcube.data.access.storagehub.handlers.Item2NodeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Item2NodeConverter {
    private static final Logger logger = LoggerFactory.getLogger(Item2NodeConverter.class);

    public <T extends Item> Node getNode(Node parentNode, T item) {
        try {
            String primaryType = ClassHandler.instance().getNodeType(item.getClass());
            Node newNode = parentNode.addNode(Text.escapeIllegalJcrChars((String)item.getName()), primaryType);
            for (Field field : this.retrieveAllFields(item.getClass())) {
                NodeAttribute nodeAttribute;
                if (field.isAnnotationPresent(Attribute.class)) {
                    Attribute attribute = field.getAnnotation(Attribute.class);
                    if (attribute.isReadOnly()) continue;
                    field.setAccessible(true);
                    try {
                        logger.trace("creating node - added field {}", (Object)field.getName());
                        Values values = this.getObjectValue(field.getType(), field.get(item));
                        if (values.isMulti()) {
                            newNode.setProperty(attribute.value(), values.getValues());
                            continue;
                        }
                        newNode.setProperty(attribute.value(), values.getValue());
                    }
                    catch (Exception e) {
                        logger.warn("error setting value for attribute {}: {}", (Object)attribute.value(), (Object)e.getMessage());
                    }
                    continue;
                }
                if (!field.isAnnotationPresent(NodeAttribute.class) || (nodeAttribute = field.getAnnotation(NodeAttribute.class)).isReadOnly()) continue;
                String nodeName = nodeAttribute.value();
                logger.trace("retrieving field node " + field.getName());
                field.setAccessible(true);
                try {
                    Object obj = field.get(item);
                    if (obj == null) continue;
                    this.iterateItemNodeAttributeFields(obj, newNode, nodeName);
                }
                catch (Exception e) {
                    logger.debug("error setting value", (Throwable)e);
                }
            }
            return newNode;
        }
        catch (RepositoryException e) {
            logger.error("error writing repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void iterateItemNodeAttributeFields(Object object, Node parentNode, String nodeName) throws Exception {
        Node newNode;
        AttributeRootNode attributeRootNode = object.getClass().getAnnotation(AttributeRootNode.class);
        try {
            newNode = attributeRootNode == null || attributeRootNode.value().isEmpty() ? parentNode.addNode(nodeName) : parentNode.addNode(nodeName, attributeRootNode.value());
        }
        catch (ItemExistsException itemExistsException) {
            newNode = parentNode.getNode(nodeName);
        }
        for (Field field : this.retrieveAllFields(object.getClass())) {
            if (field.isAnnotationPresent(Attribute.class)) {
                Attribute attribute = field.getAnnotation(Attribute.class);
                if (attribute.isReadOnly()) continue;
                field.setAccessible(true);
                try {
                    Class<?> clazz = field.getType();
                    Values values = this.getObjectValue(clazz, field.get(object));
                    if (values.isMulti()) {
                        newNode.setProperty(attribute.value(), values.getValues());
                        continue;
                    }
                    newNode.setProperty(attribute.value(), values.getValue());
                }
                catch (Exception exception) {
                    logger.debug("error setting value", (Throwable)exception);
                }
                continue;
            }
            if (field.isAnnotationPresent(MapAttribute.class)) {
                field.setAccessible(true);
                Map mapToset = (Map)field.get(object);
                for (Map.Entry entry : mapToset.entrySet()) {
                    try {
                        Values values = this.getObjectValue(entry.getValue().getClass(), entry.getValue());
                        if (values.isMulti()) {
                            newNode.setProperty((String)entry.getKey(), values.getValues());
                            continue;
                        }
                        newNode.setProperty((String)entry.getKey(), values.getValue());
                    }
                    catch (Exception e) {
                        logger.debug("error setting value", (Throwable)e);
                    }
                }
                continue;
            }
            if (!field.isAnnotationPresent(ListNodes.class)) continue;
            logger.trace("found field {} of type annotated as ListNodes in class {} on node {}", new Object[]{field.getName(), object.getClass().getName(), newNode.getName()});
            field.setAccessible(true);
            List toSetList = (List)field.get(object);
            boolean bl = false;
            for (Object obj : toSetList) {
                void var9_13;
                logger.debug("the current node {} has a list", (Object)newNode.getName());
                this.iterateItemNodeAttributeFields(obj, newNode, String.valueOf(field.getName()) + (int)(++var9_13));
            }
        }
    }

    private Values getObjectValue(Class returnType, Object value) throws Exception {
        if (returnType.equals(String.class)) {
            return new Values((Value)new StringValue((String)value));
        }
        if (returnType.isEnum()) {
            return new Values((Value)new StringValue(((Enum)value).toString()));
        }
        if (returnType.equals(Calendar.class)) {
            return new Values((Value)new DateValue((Calendar)value));
        }
        if (returnType.equals(URL.class)) {
            return new Values((Value)new StringValue(((URL)value).toString()));
        }
        if (returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE)) {
            return new Values((Value)new BooleanValue((Boolean)value));
        }
        if (returnType.equals(Long.class) || returnType.equals(Long.TYPE)) {
            return new Values((Value)new LongValue((Long)value));
        }
        if (returnType.equals(Integer.class) || returnType.equals(Integer.TYPE)) {
            return new Values((Value)new LongValue((Long)value));
        }
        if (returnType.isArray()) {
            if (returnType.getComponentType().equals(Byte.class) || returnType.getComponentType().equals(Byte.TYPE)) {
                return new Values((Value)new BinaryValue((byte[])value));
            }
            Object[] arrayObj = (Object[])value;
            Value[] arrayValue = new Value[arrayObj.length];
            int i = 0;
            Object[] objectArray = arrayObj;
            int n = arrayObj.length;
            int n2 = 0;
            while (n2 < n) {
                Object val = objectArray[n2];
                arrayValue[i++] = this.getObjectValue(returnType.getComponentType(), val).getValue();
                ++n2;
            }
            return new Values(arrayValue);
        }
        throw new Exception(String.format("class %s not recognized", returnType.getName()));
    }

    private Set<Field> retrieveAllFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> currentClass = clazz;
        do {
            List<Field> fieldsFound = Arrays.asList(currentClass.getDeclaredFields());
            fields.addAll(fieldsFound);
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return fields;
    }

    public <F extends AbstractFileItem> void replaceContent(Node node, F item, ItemAction action) {
        try {
            node.setPrimaryType(item.getClass().getAnnotation(RootNode.class).value());
            Node contentNode = node.getNode("jcr:content");
            contentNode.setPrimaryType(item.getContent().getClass().getAnnotation(AttributeRootNode.class).value());
            node.setProperty(NodeProperty.LAST_MODIFIED.toString(), item.getLastModificationTime());
            node.setProperty(NodeProperty.LAST_MODIFIED_BY.toString(), item.getLastModifiedBy());
            node.setProperty(NodeProperty.LAST_ACTION.toString(), action.name());
            for (Field field : this.retrieveAllFields(item.getContent().getClass())) {
                Attribute attribute;
                if (!field.isAnnotationPresent(Attribute.class) || (attribute = field.getAnnotation(Attribute.class)).isReadOnly()) continue;
                field.setAccessible(true);
                try {
                    Values values = this.getObjectValue(field.getType(), field.get(item.getContent()));
                    if (values.isMulti()) {
                        contentNode.setProperty(attribute.value(), values.getValues());
                        continue;
                    }
                    contentNode.setProperty(attribute.value(), values.getValue());
                }
                catch (Exception e) {
                    logger.debug("error setting value for attribute " + attribute.value(), (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("error writing repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void updateHidden(Node node, Boolean hidden, String login) throws RepositoryException {
        Utils.setPropertyOnChangeNode((Node)node, (String)login, (ItemAction)ItemAction.UPDATED);
        node.setProperty(NodeProperty.HIDDEN.toString(), hidden.booleanValue());
    }

    public <I extends Item> void updateMetadataNode(Node node, Map<String, Object> meta, String login) {
        try {
            Node metadataNode;
            Utils.setPropertyOnChangeNode((Node)node, (String)login, (ItemAction)ItemAction.UPDATED);
            try {
                metadataNode = node.getNode(NodeProperty.METADATA.toString());
                metadataNode.remove();
            }
            catch (PathNotFoundException pathNotFoundException) {}
            metadataNode = node.addNode(NodeProperty.METADATA.toString());
            for (Field field : this.retrieveAllFields(Metadata.class)) {
                if (!field.isAnnotationPresent(MapAttribute.class)) continue;
                field.setAccessible(true);
                for (Map.Entry<String, Object> entry : meta.entrySet()) {
                    try {
                        if (entry.getValue() == null) continue;
                        Values values = this.getObjectValue(entry.getValue().getClass(), entry.getValue());
                        if (values.isMulti()) {
                            metadataNode.setProperty(entry.getKey(), values.getValues());
                            continue;
                        }
                        metadataNode.setProperty(entry.getKey(), values.getValue());
                    }
                    catch (Exception e) {
                        logger.debug("error setting value", (Throwable)e);
                    }
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("error writing repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

