/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.FilenameUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.VreFolder;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.common.storagehub.model.service.Version;
import org.gcube.common.storagehub.model.service.VersionList;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.SingleFileStreamingOutput;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.exception.MyAuthException;
import org.gcube.data.access.storagehub.handlers.ClassHandler;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.StorageBackendHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.services.ItemsManager;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="items")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class ItemsManager {
    private static final Logger log;
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    AccountingHandler accountingHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    VersionHandler versionHandler;
    @Inject
    TrashHandler trashHandler;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    StorageBackendHandler storageBackend;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        ItemsManager.ajc$preClinit();
        log = LoggerFactory.getLogger(ItemsManager.class);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getById(@QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.instance.set("getById");
        Session ses = null;
        Item toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node node = ses.getNodeByIdentifier(this.id);
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = this.node2Item.getItem(node, excludes);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemWrapper(toReturn);
            ses.logout();
            return new ItemWrapper(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error searching item", (Throwable)re)));
            return new ItemWrapper(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemWrapper(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemWrapper(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemWrapper(toReturn);
        ses.logout();
        return new ItemWrapper(toReturn);
    }

    @GET
    @Path(value="{id}/path")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getByRelativePath(@QueryParam(value="path") String path, @QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.instance.set("getByPath");
        Session ses = null;
        Item toReturn = null;
        try {
            String[] paths;
            String relativePath;
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            String string = relativePath = path.startsWith("/") ? path.substring(1) : path;
            if (path.endsWith("/")) {
                relativePath.substring(0, relativePath.lastIndexOf("/"));
            }
            if (relativePath.isEmpty()) {
                throw new InvalidCallParameters("empty path");
            }
            Item item = null;
            String nextId = this.id;
            String[] stringArray = paths = relativePath.split("/");
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                String actualPath = stringArray[n2];
                item = this.getChildrenMatchingName(ses, nextId, actualPath, Excludes.ALL);
                if (item == null) {
                    throw new InvalidCallParameters("relative path " + actualPath + " not found under item with id " + nextId);
                }
                this.authChecker.checkReadAuthorizationControl(ses, item.getId());
                nextId = item.getId();
                ++n2;
            }
            if (excludes.containsAll(Excludes.ALL)) {
                ItemWrapper itemWrapper = new ItemWrapper(item);
                return itemWrapper;
            }
            ItemWrapper itemWrapper = new ItemWrapper(this.node2Item.getItem(ses.getNodeByIdentifier(item.getId()), excludes));
            return itemWrapper;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item  by path", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error getting item by path", (Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemWrapper(toReturn);
    }

    private Item getChildrenMatchingName(Session ses, String id, String name, List<String> excludes) throws ItemNotFoundException, RepositoryException, StorageHubException {
        NodeIterator it = ses.getNodeByIdentifier(id).getNodes();
        while (it.hasNext()) {
            Node child = it.nextNode();
            String nodeName = child.getName();
            if (!child.hasProperty(NodeProperty.TITLE.toString())) continue;
            String title = child.getProperty(NodeProperty.TITLE.toString()).getString();
            if (!nodeName.equals(name) && !title.equals(name)) continue;
            return this.node2Item.getItem(child, excludes);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}/items/{name}")
    @Produces(value={"application/json"})
    public ItemList findChildrenByNamePattern(@QueryParam(value="exclude") List<String> excludes, @PathParam(value="name") String name) {
        InnerMethodName.instance.set("findChildrenByNamePattern");
        Session ses = null;
        ArrayList<Item> toReturn = new ArrayList<Item>();
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            NodeIterator it = ses.getNodeByIdentifier(this.id).getNodes();
            while (it.hasNext()) {
                Node child = it.nextNode();
                String nodeName = child.getName();
                if (!child.hasProperty(NodeProperty.TITLE.toString())) continue;
                String title = child.getProperty(NodeProperty.TITLE.toString()).getString();
                String cleanedName = name;
                if (name.startsWith("*")) {
                    cleanedName = name.substring(1);
                }
                if (name.endsWith("*")) {
                    cleanedName = name.substring(0, name.length() - 1);
                }
                if ((!name.startsWith("*") || !nodeName.endsWith(cleanedName) && !title.endsWith(cleanedName)) && (!name.endsWith("*") || !nodeName.startsWith(cleanedName) && !title.startsWith(cleanedName)) && !nodeName.equals(cleanedName) && !title.equals(cleanedName)) continue;
                toReturn.add(this.node2Item.getItem(child, excludes));
            }
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error searching item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError("jcr error searching item", (Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}/children/count")
    @Produces(value={"application/json"})
    public Long countById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.instance.set("countById");
        Session ses = null;
        Long toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                toReturn = Utils.getItemCount((Node)ses.getNodeByIdentifier(this.id), (boolean)(showHidden == null ? false : showHidden), nodeType != null ? ClassHandler.instance().get(nodeType) : null);
                return toReturn;
            }
            catch (ItemNotFoundException e) {
                log.error("id {} not found", (Object)this.id, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (RuntimeException | RepositoryException re) {
                log.error("jcr error counting item", re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError(re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}/children")
    @Produces(value={"application/json"})
    public ItemList listById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.instance.set("listById");
        Session ses = null;
        List toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.getItemList((Node)ses.getNodeByIdentifier(this.id), excludes, null, (boolean)(showHidden == null ? false : showHidden), nodeType != null ? ClassHandler.instance().get(nodeType) : null);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}/search")
    @Produces(value={"application/json"})
    public ItemList searchItems(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="excludeTrashed") Boolean excludeTrashed, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType, @QueryParam(value="name") String name) {
        InnerMethodName.instance.set("search");
        Session ses = null;
        List toReturn = null;
        try {
            log.debug("search for node {}", (Object)name);
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.serachByNameOnFolder((Session)ses, (AuthorizationChecker)this.authChecker, (Node)ses.getNodeByIdentifier(this.id), excludes, null, (boolean)(showHidden == null ? false : showHidden), (boolean)(excludeTrashed != false ? false : excludeTrashed), (Class)(nodeType != null ? ClassHandler.instance().get(nodeType) : null), (String)name);
            log.debug("search retrieved {} elements", (Object)toReturn.size());
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}/children/paged")
    @Produces(value={"application/json"})
    public ItemList listByIdPaged(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="exclude") List<String> excludes, @QueryParam(value="onlyType") String nodeType) {
        InnerMethodName.instance.set("listByIdPaged");
        Session ses = null;
        List toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.getItemList((Node)ses.getNodeByIdentifier(this.id), excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)(showHidden == null ? false : showHidden), nodeType != null ? ClassHandler.instance().get(nodeType) : null);
        }
        catch (ItemNotFoundException e) {
            log.error("id {} not found", (Object)this.id, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new IdNotFoundException(this.id, (Throwable)e), (Response.Status)Response.Status.NOT_FOUND);
            if (ses == null) return new ItemList(toReturn);
            ses.logout();
            return new ItemList(toReturn);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting paged children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return new ItemList(toReturn);
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return new ItemList(toReturn);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return new ItemList(toReturn);
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return new ItemList(toReturn);
        ses.logout();
        return new ItemList(toReturn);
    }

    @GET
    @Path(value="publiclink/{id}")
    @AuthorizationControl(allowedUsers={"URIResolver"}, exception=MyAuthException.class)
    public Response resolvePublicLink() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("resolvePubliclink");
        log.warn("arrived id is {}", (Object)this.id);
        Session ses = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            String complexId = this.id;
            if (this.id.startsWith("E_")) {
                String currentScope = ScopeProvider.instance.get();
                try {
                    try {
                        ScopeBean bean = new ScopeBean(currentScope);
                        while (!bean.is(ScopeBean.Type.INFRASTRUCTURE)) {
                            bean = bean.enclosingScope();
                        }
                        ScopeProvider.instance.set(bean.toString());
                        complexId = StringEncrypter.getEncrypter().decrypt(new String(Base64.getUrlDecoder().decode(this.id.replace("E_", ""))), new Key[0]);
                    }
                    catch (Exception e) {
                        throw new BackendGenericError("invalid public url", (Throwable)e);
                    }
                }
                finally {
                    ScopeProvider.instance.set(currentScope);
                }
            }
            String itemId = complexId;
            String versionName = null;
            if (complexId.contains("_v")) {
                String[] split = complexId.split("_v");
                itemId = split[0];
                versionName = split[1];
            }
            log.warn("item id to retrieve is {}", (Object)itemId);
            Node selectedNode = ses.getNodeByIdentifier(itemId);
            Item item = this.node2Item.getItem(selectedNode, Arrays.asList("hl:accounting", "hl:metadata"));
            if (!(item instanceof AbstractFileItem)) {
                throw new InvalidCallParameters("the choosen item is not a File");
            }
            if (versionName != null) {
                Response response = this.downloadVersionInternal(ses, login, itemId, versionName, false);
                return response;
            }
            Response response = this.downloadFileInternal(ses, (AbstractFileItem)item, login, true);
            return response;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting public link", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.serverError().build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}/publiclink")
    public URL getPublicLink(@QueryParam(value="version") String version) {
        InnerMethodName.instance.set("getPubliclink");
        Session ses = null;
        URL toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                Node selectedNode = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(selectedNode, Arrays.asList("hl:accounting", "hl:metadata"));
                if (!(item instanceof AbstractFileItem)) {
                    throw new InvalidCallParameters("the choosen item is not a File");
                }
                if (version != null) {
                    boolean versionFound = false;
                    VersionList versions = this.getVersions();
                    for (Version v : versions.getItemlist()) {
                        if (!v.getName().equals(version)) continue;
                        versionFound = true;
                        break;
                    }
                    if (!versionFound) {
                        throw new InvalidCallParameters("the selected file has no version " + version);
                    }
                }
                String url = null;
                String currentScope = ScopeProvider.instance.get();
                try {
                    try {
                        ScopeBean bean = new ScopeBean(currentScope);
                        while (!bean.is(ScopeBean.Type.INFRASTRUCTURE)) {
                            bean = bean.enclosingScope();
                        }
                        ScopeProvider.instance.set(bean.toString());
                        String toEnchript = version != null ? String.format("%s%s%s", this.id, "_v", version) : this.id;
                        String enchriptedQueryString = StringEncrypter.getEncrypter().encrypt(toEnchript, new Key[0]);
                        url = this.createPublicLink(new String(Base64.getUrlEncoder().encode(enchriptedQueryString.getBytes())));
                    }
                    catch (Exception e) {
                        throw new BackendGenericError((Throwable)e);
                    }
                }
                finally {
                    ScopeProvider.instance.set(currentScope);
                }
                toReturn = new URL(url);
                return toReturn;
            }
            catch (MalformedURLException | RepositoryException re) {
                log.error("jcr error getting public link", re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError(re)));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private String createPublicLink(String enchriptedString) {
        String basepath = this.context.getInitParameter("resolver-basepath");
        String filePublicUrl = String.format("%s/%s%s", basepath, "E_", enchriptedString);
        return filePublicUrl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{id}/publish")
    @Produces(value={"application/json"})
    public String makeFolderPublic(@FormParam(value="publish") boolean publish) {
        InnerMethodName.instance.set("makeFolderPublic(" + publish + ")");
        Session ses = null;
        Item folder = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkWriteAuthorizationControl(ses, this.id, false);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                log.trace("current node is {}", (Object)currentNode.getPath());
                folder = this.node2Item.getItem(currentNode, Excludes.ALL);
                if (!(folder instanceof FolderItem)) {
                    throw new InvalidCallParameters("item is not a folder");
                }
                currentNode.setProperty(NodeProperty.IS_PUBLIC.toString(), publish);
                ses.save();
                return this.id;
            }
            catch (RepositoryException re) {
                log.error("jcr error getting rootSharedFolder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Path(value="{id}/rootSharedFolder")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getRootSharedFolder(@QueryParam(value="exclude") List<String> excludes) {
        Item sharedParent;
        block10: {
            InnerMethodName.instance.set("getRootSharedFolder");
            Session ses = null;
            sharedParent = null;
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                log.trace("current node is {}", (Object)currentNode.getPath());
                Node sharedParentNode = this.getSharedParentNode(currentNode);
                if (sharedParentNode == null) {
                    throw new InvalidCallParameters("item is not shared");
                }
                sharedParent = this.node2Item.getItem(sharedParentNode, excludes);
            }
            catch (RepositoryException re) {
                log.error("jcr error getting rootSharedFolder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block10;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block10;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block10;
            ses.logout();
        }
        return new ItemWrapper(sharedParent);
    }

    private Node getSharedParentNode(Node node) throws RepositoryException, BackendGenericError {
        Item currentItem = this.node2Item.getItem(node, Excludes.ALL);
        if (!currentItem.isShared()) {
            return null;
        }
        Node currentNode = node;
        while (!this.node2Item.checkNodeType(currentNode, SharedFolder.class)) {
            currentNode = currentNode.getParent();
        }
        return currentNode;
    }

    @GET
    @Path(value="{id}/versions")
    @Produces(value={"application/json"})
    public VersionList getVersions() {
        ArrayList<Version> versions;
        block11: {
            InnerMethodName.instance.set("getVersions");
            Session ses = null;
            versions = new ArrayList<Version>();
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                Node node = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(node, Excludes.GET_ONLY_CONTENT);
                if (!(currentItem instanceof AbstractFileItem)) {
                    throw new InvalidItemException("this item is not versioned");
                }
                List jcrVersions = this.versionHandler.getContentVersionHistory(node, ses);
                for (javax.jcr.version.Version version : jcrVersions) {
                    boolean currentVersion = ((AbstractFileItem)currentItem).getContent().getStorageId().equals(version.getFrozenNode().getProperty(NodeProperty.STORAGE_ID.toString()).getString());
                    versions.add(new Version(version.getIdentifier(), version.getName(), version.getCreated(), currentVersion));
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error retrieving versions", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block11;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block11;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block11;
            ses.logout();
        }
        return new VersionList(versions);
    }

    @GET
    @Path(value="{id}/versions/{version}/download")
    public Response downloadVersion(@PathParam(value="version") String versionName) {
        InnerMethodName.instance.set("downloadSpecificVersion");
        Session ses = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            Response response = this.downloadVersionInternal(ses, login, this.id, versionName, true);
            return response;
        }
        catch (RepositoryException re) {
            log.error("jcr error downloading version", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.serverError().build();
    }

    private Response downloadVersionInternal(Session ses, String login, String id, String versionName, boolean withAccounting) throws RepositoryException, StorageHubException {
        Node node = ses.getNodeByIdentifier(id);
        Item currentItem = this.node2Item.getItem(node, Excludes.ALL);
        if (!(currentItem instanceof AbstractFileItem)) {
            throw new InvalidItemException("this item is not a file");
        }
        List jcrVersions = this.versionHandler.getContentVersionHistory(ses.getNodeByIdentifier(id), ses);
        for (javax.jcr.version.Version version : jcrVersions) {
            log.debug("retrieved version id {}, name {}", (Object)version.getIdentifier(), (Object)version.getName());
            if (!version.getName().equals(versionName)) continue;
            long size = version.getFrozenNode().getProperty(NodeProperty.SIZE.toString()).getLong();
            String mimeType = version.getFrozenNode().getProperty(NodeProperty.MIME_TYPE.toString()).getString();
            String storageId = version.getFrozenNode().getProperty(NodeProperty.STORAGE_ID.toString()).getString();
            InputStream streamToWrite = this.storageBackend.download(storageId);
            String oldfilename = FilenameUtils.getBaseName((String)currentItem.getTitle());
            String ext = FilenameUtils.getExtension((String)currentItem.getTitle());
            String fileName = String.format("%s_v%s.%s", oldfilename, version.getName(), ext);
            if (withAccounting) {
                this.accountingHandler.createReadObj(fileName, ses, node, true);
            }
            SingleFileStreamingOutput so = new SingleFileStreamingOutput(streamToWrite);
            return Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + fileName)).header("Content-Length", (Object)size).header("Content-Type", (Object)mimeType).build();
        }
        throw new InvalidItemException("the version is not valid");
    }

    @GET
    @Path(value="{id}/anchestors")
    @Produces(value={"application/json"})
    public ItemList getAnchestors(@QueryParam(value="exclude") List<String> excludes) {
        LinkedList<Item> toReturn;
        block13: {
            InnerMethodName.instance.set("getAnchestors");
            org.gcube.common.storagehub.model.Path absolutePath = Utils.getWorkspacePath();
            Session ses = null;
            toReturn = new LinkedList<Item>();
            try {
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                Node currentNode = ses.getNodeByIdentifier(this.id);
                Item currentItem = this.node2Item.getItem(currentNode, excludes);
                log.trace("current node is {}", (Object)currentNode.getPath());
                while (!(String.valueOf(currentNode.getPath()) + "/").equals(absolutePath.toPath())) {
                    if (currentItem instanceof SharedFolder) {
                        NodeIterator sharedSetIterator = currentNode.getSharedSet();
                        while (sharedSetIterator.hasNext()) {
                            Node sharedNode = sharedSetIterator.nextNode();
                            if (!sharedNode.getPath().startsWith(Utils.getWorkspacePath((String)login).toPath())) continue;
                            currentNode = sharedNode.getParent();
                            break;
                        }
                        currentItem = this.node2Item.getItem(currentNode, excludes);
                    } else {
                        currentNode = currentNode.getParent();
                        currentItem = this.node2Item.getItem(currentNode, excludes);
                    }
                    log.trace("current node is {}", (Object)currentNode.getPath());
                    toReturn.add(currentItem);
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error getting anchestors", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block13;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block13;
            ses.logout();
        }
        log.trace("item list to return is empty ? {}", (Object)toReturn.isEmpty());
        return new ItemList(toReturn);
    }

    @GET
    @Path(value="{id}/download")
    public Response download(@QueryParam(value="exclude") List<String> excludes) {
        Response response;
        block15: {
            InnerMethodName.instance.set("downloadById");
            Session ses = null;
            response = null;
            try {
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node node = ses.getNodeByIdentifier(this.id);
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                Item item = this.node2Item.getItem(node, null);
                if (item instanceof AbstractFileItem) {
                    Response response2 = this.downloadFileInternal(ses, (AbstractFileItem)item, login, true);
                    return response2;
                }
                try {
                    if (item instanceof FolderItem) {
                        try {
                            Deque allNodes = Utils.getAllNodesForZip((FolderItem)((FolderItem)item), (Session)ses, (AccountingHandler)this.accountingHandler, excludes);
                            org.gcube.common.storagehub.model.Path originalPath = Paths.getPath((String)item.getParentPath());
                            1 so = new /* Unavailable Anonymous Inner Class!! */;
                            response = Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + item.getTitle() + ".zip")).header("Content-Type", (Object)"application/zip").header("Content-Length", (Object)-1L).build();
                            this.accountingHandler.createReadObj(item.getTitle(), ses, ses.getNodeByIdentifier(item.getId()), false);
                            break block15;
                        }
                        finally {
                            if (ses != null) {
                                ses.save();
                            }
                        }
                    }
                    throw new InvalidItemException("item type not supported for download: " + item.getClass());
                }
                catch (RepositoryException re) {
                    log.error("jcr error download", (Throwable)re);
                    GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                }
                catch (StorageHubException she) {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                }
            }
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        return response;
    }

    private Response downloadFileInternal(Session ses, AbstractFileItem fileItem, String login, boolean withAccounting) throws RepositoryException {
        InputStream streamToWrite = this.storageBackend.download(fileItem.getContent().getStorageId());
        if (withAccounting) {
            this.accountingHandler.createReadObj(fileItem.getTitle(), ses, ses.getNodeByIdentifier(fileItem.getId()), true);
        }
        SingleFileStreamingOutput so = new SingleFileStreamingOutput(streamToWrite);
        return Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + fileItem.getName())).header("Content-Length", (Object)fileItem.getContent().getSize()).header("Content-Type", (Object)fileItem.getContent().getMimeType()).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{id}/move")
    public String move(@FormParam(value="destinationId") String destinationId) {
        InnerMethodName.instance.set("move");
        Session ses = null;
        try {
            try {
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkMoveOpsForProtectedFolders(ses, this.id);
                this.authChecker.checkWriteAuthorizationControl(ses, destinationId, true);
                this.authChecker.checkWriteAuthorizationControl(ses, this.id, false);
                Node nodeToMove = ses.getNodeByIdentifier(this.id);
                Node destination = ses.getNodeByIdentifier(destinationId);
                Node originalParent = nodeToMove.getParent();
                Item destinationItem = this.node2Item.getItem(destination, null);
                Item item = this.node2Item.getItem(nodeToMove, null);
                if (item instanceof SharedFolder) {
                    throw new InvalidItemException("shared folder cannot be moved");
                }
                if (item instanceof FolderItem && Utils.hasSharedChildren((Node)nodeToMove)) {
                    throw new InvalidItemException("folder item with shared children cannot be moved");
                }
                if (Constants.FOLDERS_TO_EXLUDE.contains(item.getTitle()) || Constants.FOLDERS_TO_EXLUDE.contains(destinationItem.getTitle())) {
                    throw new InvalidItemException("protected folder cannot be moved");
                }
                if (!(destinationItem instanceof FolderItem)) {
                    throw new InvalidItemException("destination item is not a folder");
                }
                if (!(!item.isShared() || destinationItem.isShared() && this.getSharedParentNode(nodeToMove).getIdentifier().equals(this.getSharedParentNode(destination).getIdentifier()))) {
                    throw new InvalidCallParameters("shared Item cannot be moved in a different shared folder or in a private folder");
                }
                try {
                    ses.getWorkspace().getLockManager().lock(destination.getPath(), false, true, 0L, login);
                    ses.getWorkspace().getLockManager().lock(nodeToMove.getPath(), true, true, 0L, login);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destination, (String)nodeToMove.getName());
                    String newPath = String.format("%s/%s", destination.getPath(), uniqueName);
                    ses.getWorkspace().move(nodeToMove.getPath(), newPath);
                    Utils.setPropertyOnChangeNode((Node)ses.getNode(newPath), (String)login, (ItemAction)ItemAction.MOVED);
                    String mimeTypeForAccounting = item instanceof AbstractFileItem ? ((AbstractFileItem)item).getContent().getMimeType() : null;
                    this.accountingHandler.createFolderAddObj(uniqueName, item.getClass().getSimpleName(), mimeTypeForAccounting, ses, destination, false);
                    this.accountingHandler.createFolderRemoveObj(item.getTitle(), item.getClass().getSimpleName(), mimeTypeForAccounting, ses, originalParent, false);
                    ses.save();
                    return this.id;
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToMove.getPath());
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return this.id;
                ses.logout();
                return this.id;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{id}/copy")
    public String copy(@FormParam(value="destinationId") String destinationId, @FormParam(value="fileName") String newFileName) {
        InnerMethodName.instance.set("copy");
        Session ses = null;
        String newFileIdentifier = null;
        try {
            try {
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkWriteAuthorizationControl(ses, destinationId, true);
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                Node nodeToCopy = ses.getNodeByIdentifier(this.id);
                Node destination = ses.getNodeByIdentifier(destinationId);
                Item item = this.node2Item.getItem(nodeToCopy, Arrays.asList("hl:accounting", "hl:metadata"));
                if (item instanceof FolderItem) {
                    throw new InvalidItemException("folder cannot be copied");
                }
                try {
                    ses.getWorkspace().getLockManager().lock(destination.getPath(), false, true, 0L, login);
                    ses.getWorkspace().getLockManager().lock(nodeToCopy.getPath(), true, true, 0L, login);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destination, (String)newFileName);
                    String newPath = String.format("%s/%s", destination.getPath(), uniqueName);
                    ses.getWorkspace().copy(nodeToCopy.getPath(), newPath);
                    Node newNode = ses.getNode(newPath);
                    newFileIdentifier = newNode.getIdentifier();
                    if (item instanceof AbstractFileItem) {
                        ((AbstractFileItem)item).getContent().setRemotePath(newPath);
                        String newStorageID = this.storageBackend.copy((AbstractFileItem)item);
                        ((AbstractFileItem)item).getContent().setStorageId(newStorageID);
                        this.item2Node.replaceContent(newNode, (AbstractFileItem)item, ItemAction.CLONED);
                    }
                    Utils.setPropertyOnChangeNode((Node)newNode, (String)login, (ItemAction)ItemAction.CLONED);
                    newNode.setProperty(NodeProperty.PORTAL_LOGIN.toString(), login);
                    newNode.setProperty(NodeProperty.IS_PUBLIC.toString(), false);
                    newNode.setProperty(NodeProperty.TITLE.toString(), uniqueName);
                    String mimeTypeForAccounting = item instanceof AbstractFileItem ? ((AbstractFileItem)item).getContent().getMimeType() : null;
                    this.accountingHandler.createFolderAddObj(uniqueName, item.getClass().getSimpleName(), mimeTypeForAccounting, ses, destination, false);
                    ses.save();
                    return newFileIdentifier;
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToCopy.getPath());
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses == null) return newFileIdentifier;
                ses.logout();
                return newFileIdentifier;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return newFileIdentifier;
                ses.logout();
                return newFileIdentifier;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @PUT
    @Path(value="{id}/rename")
    public Response rename(@FormParam(value="newName") String newName) {
        block17: {
            InnerMethodName.instance.set("rename");
            Session ses = null;
            try {
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkMoveOpsForProtectedFolders(ses, this.id);
                this.authChecker.checkWriteAuthorizationControl(ses, this.id, false);
                Node nodeToMove = ses.getNodeByIdentifier(this.id);
                Item item = this.node2Item.getItem(nodeToMove, null);
                if (item instanceof SharedFolder) {
                    throw new InvalidItemException("shared folder");
                }
                if (Constants.FOLDERS_TO_EXLUDE.contains(item.getTitle())) {
                    throw new InvalidItemException("protected folder cannot be renamed");
                }
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToMove.getPath(), true, true, 0L, login);
                    ses.getWorkspace().getLockManager().lock(nodeToMove.getParent().getPath(), false, true, 0L, login);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)nodeToMove.getParent(), (String)newName);
                    String newPath = String.format("%s/%s", nodeToMove.getParent().getPath(), uniqueName);
                    nodeToMove.setProperty(NodeProperty.TITLE.toString(), uniqueName);
                    Utils.setPropertyOnChangeNode((Node)nodeToMove, (String)login, (ItemAction)ItemAction.RENAMED);
                    ses.move(nodeToMove.getPath(), newPath);
                    this.accountingHandler.createRename(item.getTitle(), uniqueName, ses.getNode(newPath), ses, false);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToMove.getPath());
                    ses.getWorkspace().getLockManager().unlock(nodeToMove.getParent().getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block17;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block17;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block17;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{id}/hidden")
    public Response setItemAsHidden(Boolean hidden) {
        block15: {
            InnerMethodName.instance.set("setHidden");
            Session ses = null;
            try {
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkWriteAuthorizationControl(ses, this.id, false);
                Node nodeToUpdate = ses.getNodeByIdentifier(this.id);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToUpdate.getPath(), false, true, 0L, login);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    this.item2Node.updateHidden(nodeToUpdate, hidden, login);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToUpdate.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block15;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block15;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{id}/metadata")
    public Response setMetadata(Metadata metadata) {
        block15: {
            InnerMethodName.instance.set("updateMetadata");
            Session ses = null;
            try {
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkWriteAuthorizationControl(ses, this.id, false);
                Node nodeToUpdate = ses.getNodeByIdentifier(this.id);
                try {
                    ses.getWorkspace().getLockManager().lock(nodeToUpdate.getPath(), false, true, 0L, login);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    this.item2Node.updateMetadataNode(nodeToUpdate, metadata.getMap(), login);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(nodeToUpdate.getPath());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error moving item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
                if (ses != null) {
                    ses.logout();
                }
                break block15;
            }
            catch (StorageHubException she) {
                try {
                    log.error(she.getErrorMessage(), (Throwable)she);
                    GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                    break block15;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block15;
            ses.logout();
        }
        return Response.ok((Object)this.id).build();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Path(value="{id}")
    public Response deleteItem(@QueryParam(value="force") boolean force) {
        InnerMethodName.instance.set("deleteItem(" + force + ")");
        Session ses = null;
        try {
            log.info("removing node with id {}", (Object)this.id);
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkMoveOpsForProtectedFolders(ses, this.id);
            this.authChecker.checkWriteAuthorizationControl(ses, this.id, false);
            Node nodeToDelete = ses.getNodeByIdentifier(this.id);
            Item itemToDelete = this.node2Item.getItem(nodeToDelete, Excludes.GET_ONLY_CONTENT);
            if (itemToDelete instanceof SharedFolder || itemToDelete instanceof VreFolder || itemToDelete instanceof FolderItem && Utils.hasSharedChildren((Node)nodeToDelete)) {
                throw new InvalidItemException("SharedFolder, VreFolder or folders with shared children cannot be deleted");
            }
            log.debug("item is trashed? {}", (Object)itemToDelete.isTrashed());
            if (!itemToDelete.isTrashed() && !force) {
                this.trashHandler.moveToTrash(ses, nodeToDelete, itemToDelete);
            } else {
                this.trashHandler.removeNodes(ses, Collections.singletonList(itemToDelete));
            }
        }
        catch (LockException lockException) {
            if (ses == null) return Response.ok().build();
            ses.logout();
            return Response.ok().build();
        }
        catch (RepositoryException re) {
            log.error("jcr error moving item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)((Object)new BackendGenericError((Throwable)re)));
            return Response.ok().build();
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
            if (ses == null) return Response.ok().build();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            ses.logout();
            return Response.ok().build();
        }
        {
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        if (ses == null) return Response.ok().build();
        ses.logout();
        return Response.ok().build();
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ItemsManager.java", ItemsManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "resolvePublicLink", "org.gcube.data.access.storagehub.services.ItemsManager", "", "", "", "javax.ws.rs.core.Response"), 377);
    }
}

