/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.Node2ItemConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class UnshareHandler {
    private static final Logger log = LoggerFactory.getLogger(UnshareHandler.class);
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    Item2NodeConverter item2Node;

    public String unshare(Session ses, Set<String> users, Node sharedNode, String login) throws RepositoryException, StorageHubException {
        Item item = this.node2Item.getItem(sharedNode, Excludes.ALL);
        if (!(item instanceof FolderItem) || !((FolderItem)item).isShared() || ((SharedFolder)item).isVreFolder()) {
            return null;
        }
        SharedFolder sharedItem = (SharedFolder)item;
        HashSet usersInSharedFolder = new HashSet(sharedItem.getUsers().getMap().keySet());
        usersInSharedFolder.removeAll(users);
        if (users == null || users.size() == 0) {
            return this.unshareAll(login, ses, sharedItem);
        }
        if (usersInSharedFolder.size() <= 1) {
            if (users.size() == 1 && users.contains(login)) {
                return this.unshareAll(sharedItem.getOwner(), ses, sharedItem);
            }
            return this.unshareAll(login, ses, sharedItem);
        }
        try {
            ses.getWorkspace().getLockManager().lock(sharedNode.getPath(), true, true, 0L, login);
        }
        catch (LockException e) {
            throw new ItemLockedException((Throwable)e);
        }
        try {
            if (users.size() == 1 && users.contains(login)) {
                String string = this.unshareCaller(login, ses, sharedItem);
                return string;
            }
            String string = this.unsharePartial(users, login, ses, sharedItem);
            return string;
        }
        finally {
            ses.getWorkspace().getLockManager().unlock(sharedNode.getPath());
        }
    }

    private String unshareAll(String login, Session ses, SharedFolder item) throws StorageHubException, BackendGenericError, RepositoryException {
        Node unsharedNode;
        log.info("unshare all called");
        if (!login.equals(item.getOwner())) {
            throw new UserNotAuthorizedException("user " + login + " not authorized to unshare all");
        }
        Node sharedItemNode = ses.getNodeByIdentifier(item.getId());
        try {
            ses.getWorkspace().getLockManager().lock(sharedItemNode.getPath(), true, true, 0L, login);
        }
        catch (LockException e) {
            throw new ItemLockedException((Throwable)e);
        }
        try {
            try {
                log.debug("user list is empty, I'm going to remove also the shared dir");
                String adminDirPath = (String)item.getUsers().getMap().get(login);
                String[] splitString = adminDirPath.split("/");
                String parentDirectoryId = splitString[0];
                String directoryName = splitString[1];
                Node parentNode = ses.getNodeByIdentifier(parentDirectoryId);
                log.debug("parent node path is {}/{}", (Object)parentNode.getPath(), (Object)directoryName);
                Node adminNode = ses.getNode(String.format("%s/%s", parentNode.getPath(), directoryName));
                adminNode.removeShare();
                unsharedNode = this.createUnsharedFolder(ses, parentNode, directoryName, item.getDescription(), login);
                List itemsToCopy = Utils.getItemList((Node)sharedItemNode, (List)Excludes.ALL, null, (boolean)true, null);
                for (Item itemCopy : itemsToCopy) {
                    Node itemToCopyNode = ses.getNodeByIdentifier(itemCopy.getId());
                    log.debug("copying {} to {}", (Object)itemToCopyNode.getPath(), (Object)unsharedNode.getPath());
                    ses.move(itemToCopyNode.getPath(), String.format("%s/%s", unsharedNode.getPath(), itemToCopyNode.getName()));
                }
                unsharedNode.getNode(NodeProperty.ACCOUNTING.toString()).remove();
                ses.move(sharedItemNode.getNode(NodeProperty.ACCOUNTING.toString()).getPath(), String.format("%s/%s", unsharedNode.getPath(), NodeProperty.ACCOUNTING.toString()));
                this.accountingHandler.createUnshareFolder(sharedItemNode.getProperty(NodeProperty.TITLE.toString()).getString(), "ALL", ses, unsharedNode, false);
                ses.save();
            }
            catch (Throwable t) {
                log.error("erro unsharing all", t);
                throw t;
            }
        }
        finally {
            ses.getWorkspace().getLockManager().unlock(sharedItemNode.getPath());
        }
        sharedItemNode.removeSharedSet();
        ses.save();
        log.debug("all the users have been removed, the folder is totally unshared");
        return unsharedNode.getIdentifier();
    }

    private String unshareCaller(String login, Session ses, SharedFolder item) throws StorageHubException, RepositoryException {
        if (login.equals(item.getOwner())) {
            throw new InvalidCallParameters("the caller is the owner, the folder cannot be unshared");
        }
        if (item.getUsers().getMap().get(login) == null) {
            throw new InvalidCallParameters("the folder is not shared with user " + login);
        }
        Node sharedFolderNode = ses.getNodeByIdentifier(item.getId());
        String parentId = this.removeSharingForUser(login, ses, item);
        AccessControlManager acm = ses.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)sharedFolderNode.getPath());
        AccessControlEntry entryToDelete = null;
        AccessControlEntry[] accessControlEntryArray = acls.getAccessControlEntries();
        int n = accessControlEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            AccessControlEntry ace = accessControlEntryArray[n2];
            if (ace.getPrincipal().getName().equals(login)) {
                entryToDelete = ace;
                break;
            }
            ++n2;
        }
        if (entryToDelete != null) {
            acls.removeAccessControlEntry(entryToDelete);
        }
        log.debug("removed Access control entry for user {}", (Object)login);
        Node sharedItemNode = ses.getNodeByIdentifier(item.getId());
        this.accountingHandler.createUnshareFolder(sharedItemNode.getProperty(NodeProperty.TITLE.toString()).getString(), login, ses, sharedItemNode, false);
        Node usersNode = sharedItemNode.getNode("hl:users");
        usersNode.remove();
        Node newUsersNode = sharedItemNode.addNode("hl:users");
        item.getUsers().getMap().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(login)).forEach(entry -> {
            try {
                newUsersNode.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            catch (Exception exception) {
                log.error("error adding property to shared node users node under {}", (Object)item.getId());
            }
        });
        acm.setPolicy(sharedFolderNode.getPath(), (AccessControlPolicy)acls);
        ses.save();
        return parentId;
    }

    private String unsharePartial(Set<String> usersToUnshare, String login, Session ses, SharedFolder item) throws StorageHubException, RepositoryException {
        this.authChecker.checkAdministratorControl(ses, item);
        if (usersToUnshare.contains(item.getOwner())) {
            throw new UserNotAuthorizedException("user " + login + " not authorized to unshare owner");
        }
        Node sharedFolderNode = ses.getNodeByIdentifier(item.getId());
        AccessControlManager acm = ses.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)sharedFolderNode.getPath());
        for (String user : usersToUnshare) {
            this.removeSharingForUser(user, ses, item);
            AccessControlEntry entryToDelete = null;
            AccessControlEntry[] accessControlEntryArray = acls.getAccessControlEntries();
            int n = accessControlEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlEntry ace = accessControlEntryArray[n2];
                if (ace.getPrincipal().getName().equals(user)) {
                    entryToDelete = ace;
                    break;
                }
                ++n2;
            }
            if (entryToDelete != null) {
                acls.removeAccessControlEntry(entryToDelete);
            }
            log.debug("removed Access control entry for user {}", (Object)user);
        }
        Node sharedItemNode = ses.getNodeByIdentifier(item.getId());
        Node usersNode = sharedItemNode.getNode("hl:users");
        usersNode.remove();
        Node newUsersNode = sharedItemNode.addNode("hl:users");
        item.getUsers().getMap().entrySet().stream().filter(entry -> !usersToUnshare.contains(entry.getKey())).forEach(entry -> {
            try {
                newUsersNode.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            catch (Exception exception) {
                log.error("error adding property to shared node users node under " + item.getId());
            }
        });
        acm.setPolicy(sharedFolderNode.getPath(), (AccessControlPolicy)acls);
        for (String user : usersToUnshare) {
            this.accountingHandler.createUnshareFolder(sharedItemNode.getProperty(NodeProperty.TITLE.toString()).getString(), user, ses, sharedItemNode, false);
        }
        ses.save();
        return item.getId();
    }

    private String removeSharingForUser(String user, Session ses, SharedFolder item) throws RepositoryException {
        String userDirPath = (String)item.getUsers().getMap().get(user);
        if (userDirPath == null) {
            return null;
        }
        String[] splitString = userDirPath.split("/");
        String parentDirectoryId = splitString[0];
        String directoryName = splitString[1];
        Node parentNode = ses.getNodeByIdentifier(parentDirectoryId);
        Node userNode = ses.getNode(String.format("%s/%s", parentNode.getPath(), directoryName));
        userNode.removeShare();
        log.debug("directory removed for user {}", (Object)user);
        return parentDirectoryId;
    }

    private Node createUnsharedFolder(Session ses, Node destinationNode, String name, String description, String login) {
        FolderItem item = new FolderItem();
        Calendar now = Calendar.getInstance();
        item.setName(name);
        item.setTitle(name);
        item.setDescription(description);
        item.setHidden(false);
        item.setLastAction(ItemAction.CREATED);
        item.setLastModificationTime(now);
        item.setLastModifiedBy(login);
        item.setOwner(login);
        Node newNode = this.item2Node.getNode(destinationNode, (Item)item);
        return newNode;
    }
}

