/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.query.Query;
import org.apache.commons.io.FilenameUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.ExternalLink;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.StorageBackendHandler;
import org.gcube.data.access.storagehub.handlers.VRE;
import org.gcube.data.access.storagehub.handlers.VREManager;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final String SERVICE_NAME = "home-library";
    public static final String SERVICE_CLASS = "org.gcube.portlets.user";
    private static final String FOLDERS_TYPE = "nthl:workspaceItem";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getSecurePassword(String user) throws Exception {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(user.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            byte[] byArray = hash;
            int n = hash.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                sb.append(String.format("%02x", b & 0xFF));
                ++n2;
            }
            digest = sb.toString();
        }
        catch (Exception e) {
            logger.error("error getting secure password", (Throwable)e);
        }
        return digest;
    }

    public static long getItemCount(Node parent, boolean showHidden, Class<? extends Item> nodeType) throws RepositoryException, BackendGenericError {
        return Utils.getItemList((Node)parent, (List)Excludes.ALL, null, (boolean)showHidden, nodeType).size();
    }

    public static void acquireLockWithWait(Session ses, String nodePath, boolean isDeep, String login, int maxTries) throws RepositoryException, ItemLockedException {
        Lock lock = null;
        int tries = 0;
        while (lock == null && tries <= maxTries) {
            try {
                lock = ses.getWorkspace().getLockManager().lock(nodePath, isDeep, true, 0L, login);
                logger.info("lock acquired(try n. {})", (Object)tries);
            }
            catch (LockException lockException) {
                try {
                    if (maxTries >= tries) {
                        int waitTime = (int)(Math.random() * 5000.0);
                        logger.info("lock NOT acquired, waiting (try n. {}) for {}", (Object)tries, (Object)waitTime);
                        Thread.sleep(waitTime);
                    }
                }
                catch (InterruptedException interruptedException) {}
                ++tries;
            }
        }
        if (lock == null) {
            throw new ItemLockedException("the item is locked");
        }
    }

    public static <T extends Item> List<T> serachByNameOnFolder(Session ses, AuthorizationChecker authChecker, Node parent, List<String> excludes, Range range, boolean showHidden, boolean excludeTrashed, Class<? extends Item> nodeTypeToInclude, String nameParam) throws RepositoryException, BackendGenericError {
        String xpath = String.format("/jcr:root%s//element(*,nthl:workspaceItem)[jcr:like(fn:lower-case(@jcr:title), '%s')]", ISO9075.encodePath((String)parent.getPath()), nameParam.toLowerCase());
        logger.debug("query for search is {}", (Object)xpath);
        long start = System.currentTimeMillis();
        Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        NodeIterator it = jcrQuery.execute().getNodes();
        logger.debug("[SEARCH] real search took {} millis", (Object)(System.currentTimeMillis() - start));
        return Utils.getItemListFromNodeIterator((AuthorizationChecker)authChecker, (NodeIterator)it, excludes, (Range)range, (boolean)showHidden, (boolean)excludeTrashed, nodeTypeToInclude);
    }

    public static <T extends Item> List<T> getItemList(Node parent, List<String> excludes, Range range, boolean showHidden, Class<? extends Item> nodeTypeToInclude) throws RepositoryException, BackendGenericError {
        logger.trace("getting children of node {}", (Object)parent.getIdentifier());
        long start = System.currentTimeMillis();
        NodeIterator iterator = parent.getNodes();
        logger.trace("time to get iterator {}", (Object)(System.currentTimeMillis() - start));
        return Utils.getItemListFromNodeIterator(null, (NodeIterator)iterator, excludes, (Range)range, (boolean)showHidden, (boolean)false, nodeTypeToInclude);
    }

    private static <T extends Item> List<T> getItemListFromNodeIterator(AuthorizationChecker authChecker, NodeIterator iterator, List<String> excludes, Range range, boolean showHidden, boolean excludeTrashed, Class<? extends Item> nodeTypeToInclude) throws RepositoryException, BackendGenericError {
        ArrayList<Item> returnList = new ArrayList<Item>();
        logger.trace("nodeType is {}", nodeTypeToInclude);
        int count = 0;
        logger.trace("selected range is {}", (Object)range);
        Node2ItemConverter node2Item = new Node2ItemConverter();
        while (iterator.hasNext()) {
            Node current = iterator.nextNode();
            logger.debug("[SEARCH] evaluating node {} ", (Object)current.getProperty(NodeProperty.TITLE.toString()));
            if (authChecker != null) {
                try {
                    authChecker.checkReadAuthorizationControl(current.getSession(), current.getIdentifier());
                }
                catch (RepositoryException | BackendGenericError | UserNotAuthorizedException throwable) {
                    continue;
                }
            }
            if (Utils.isToExclude((Node)current, (boolean)showHidden)) continue;
            logger.debug("[SEARCH] current node not excluded {} ", (Object)current.getProperty(NodeProperty.TITLE.toString()));
            if (range == null || count >= range.getStart() && returnList.size() < range.getLimit()) {
                Item item = node2Item.getFilteredItem(current, excludes, nodeTypeToInclude);
                if (item == null || item.isTrashed() && excludeTrashed) continue;
                returnList.add(item);
            }
            ++count;
        }
        return returnList;
    }

    private static boolean isToExclude(Node node, boolean showHidden) throws RepositoryException {
        return node.getName().startsWith("rep:") || node.getName().startsWith("hl:") || !showHidden && node.hasProperty(NodeProperty.HIDDEN.toString()) && node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean() || node.getPrimaryNodeType().getName().equals("nthl:workspaceItem") && Constants.FOLDERS_TO_EXLUDE.contains(node.getName());
    }

    public static Path getWorkspacePath() {
        return Paths.getPath((String)String.format("/Home/%s/Workspace", AuthorizationProvider.instance.get().getClient().getId()));
    }

    public static Path getWorkspacePath(String login) {
        return Paths.getPath((String)String.format("/Home/%s/Workspace", login));
    }

    public static Path getHome(String login) {
        return Paths.getPath((String)String.format("/Home/%s", login));
    }

    public static Deque<Item> getAllNodesForZip(FolderItem directory, Session session, AccountingHandler accountingHandler, List<String> excludes) throws RepositoryException, BackendGenericError {
        LinkedList<Item> queue = new LinkedList<Item>();
        Node currentNode = session.getNodeByIdentifier(directory.getId());
        queue.push((Item)directory);
        LinkedList tempQueue = new LinkedList();
        logger.trace("adding directory {}", (Object)currentNode.getPath());
        for (Item item : Utils.getItemList((Node)currentNode, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)false, null)) {
            if (excludes.contains(item.getId())) continue;
            if (item instanceof FolderItem) {
                tempQueue.addAll(Utils.getAllNodesForZip((FolderItem)((FolderItem)item), (Session)session, (AccountingHandler)accountingHandler, excludes));
                continue;
            }
            if (!(item instanceof AbstractFileItem)) continue;
            logger.trace("adding file {}", (Object)item.getPath());
            AbstractFileItem fileItem = (AbstractFileItem)item;
            accountingHandler.createReadObj(fileItem.getTitle(), session, session.getNodeByIdentifier(item.getId()), false);
            queue.addLast(item);
        }
        queue.addAll(tempQueue);
        return queue;
    }

    public static void zipNode(ZipOutputStream zos, Deque<Item> queue, String login, Path originalPath, StorageBackendHandler storageHandler) throws Exception {
        logger.trace("originalPath is {}", (Object)originalPath.toPath());
        Path actualPath = Paths.getPath((String)"");
        while (!queue.isEmpty()) {
            Item item = queue.pop();
            if (item instanceof FolderItem) {
                actualPath = Paths.getPath((String)item.getPath());
                logger.trace("actualPath is {}", (Object)actualPath.toPath());
                String name = Paths.remove((Path)actualPath, (Path)originalPath).toPath().replaceFirst("/", "");
                logger.trace("writing dir {}", (Object)name);
                if (name.isEmpty()) continue;
                try {
                    zos.putNextEntry(new ZipEntry(name));
                    continue;
                }
                finally {
                    zos.closeEntry();
                }
            }
            if (!(item instanceof AbstractFileItem)) continue;
            try {
                block22: {
                    InputStream streamToWrite = storageHandler.download(((AbstractFileItem)item).getContent().getStorageId());
                    if (streamToWrite == null) {
                        logger.warn("discarding item {} ", (Object)item.getName());
                        continue;
                    }
                    try {
                        try {
                            Throwable throwable = null;
                            Object var9_13 = null;
                            try (BufferedInputStream is = new BufferedInputStream(streamToWrite);){
                                String name = (String.valueOf(Paths.remove((Path)actualPath, (Path)originalPath).toPath()) + item.getName()).replaceFirst("/", "");
                                logger.trace("writing file {}", (Object)name);
                                zos.putNextEntry(new ZipEntry(name));
                                Utils.copyStream((InputStream)is, (OutputStream)zos);
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            logger.warn("error writing item {}", (Object)item.getName(), (Object)e);
                            zos.closeEntry();
                            break block22;
                        }
                    }
                    catch (Throwable throwable) {
                        zos.closeEntry();
                        throw throwable;
                    }
                    zos.closeEntry();
                }
                zos.flush();
            }
            catch (Throwable e) {
                logger.warn("error reading content for item {}", (Object)item.getPath(), (Object)e);
            }
        }
        zos.close();
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[2048];
        int readcount = 0;
        while ((readcount = in.read(buffer)) != -1) {
            out.write(buffer, 0, readcount);
        }
    }

    public static boolean hasSharedChildren(Node node) throws RepositoryException, BackendGenericError {
        Node2ItemConverter node2Item = new Node2ItemConverter();
        NodeIterator children = node.getNodes();
        while (children.hasNext()) {
            Node child = children.nextNode();
            if (node2Item.checkNodeType(child, SharedFolder.class)) {
                return true;
            }
            if (!node2Item.checkNodeType(child, FolderItem.class) || !Utils.hasSharedChildren((Node)child)) continue;
            return true;
        }
        return false;
    }

    public static void getAllContentIds(Session ses, Set<String> idsToDelete, Item itemToDelete, VersionHandler versionHandler) throws Exception {
        if (itemToDelete instanceof AbstractFileItem) {
            List versions = versionHandler.getContentVersionHistory(ses.getNodeByIdentifier(itemToDelete.getId()), ses);
            versions.forEach(v -> {
                try {
                    String storageId = v.getFrozenNode().getProperty(NodeProperty.STORAGE_ID.toString()).getString();
                    idsToDelete.add(storageId);
                    logger.info("retrieved StorageId {} for version {}", (Object)storageId, (Object)v.getName());
                }
                catch (Exception e) {
                    logger.warn("error retreiving sotrageId version for item with id {}", (Object)itemToDelete.getId(), (Object)e);
                }
            });
            idsToDelete.add(((AbstractFileItem)itemToDelete).getContent().getStorageId());
        } else if (itemToDelete instanceof FolderItem) {
            List items = Utils.getItemList((Node)ses.getNodeByIdentifier(itemToDelete.getId()), (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null);
            for (Item item : items) {
                Utils.getAllContentIds((Session)ses, idsToDelete, (Item)item, (VersionHandler)versionHandler);
            }
        }
    }

    public static String checkExistanceAndGetUniqueName(Session ses, Node destination, String name) throws BackendGenericError {
        try {
            destination.getNode(name);
        }
        catch (PathNotFoundException pathNotFoundException) {
            return Text.escapeIllegalJcrChars((String)name);
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
        try {
            String filename = FilenameUtils.getBaseName((String)name);
            String ext = FilenameUtils.getExtension((String)name);
            String nameTocheck = ext.isEmpty() ? String.format("%s(*)", filename) : String.format("%s(*).%s", filename, ext);
            logger.trace("filename is {}, extension is {} , and name to check is {}", new Object[]{filename, ext, nameTocheck});
            NodeIterator ni = destination.getNodes(nameTocheck);
            int maxval = 0;
            while (ni.hasNext()) {
                Node n = ni.nextNode();
                int actual = Integer.parseInt(n.getName().replaceAll(String.format("%s\\((\\d*)\\).*", filename), "$1"));
                if (actual <= maxval) continue;
                maxval = actual;
            }
            String newName = ext.isEmpty() ? String.format("%s(%d)", filename, maxval + 1) : String.format("%s(%d).%s", filename, maxval + 1, ext);
            return Text.escapeIllegalJcrChars((String)newName);
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
    }

    public static Node createFolderInternally(Session ses, Node destinationNode, String name, String description, boolean hidden, String login, AccountingHandler accountingHandler) throws BackendGenericError {
        String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destinationNode, (String)name);
        FolderItem item = new FolderItem();
        Calendar now = Calendar.getInstance();
        item.setName(uniqueName);
        item.setTitle(uniqueName);
        item.setDescription(description);
        boolean hiddenDestNode = false;
        try {
            hiddenDestNode = destinationNode.getProperty(NodeProperty.HIDDEN.toString()).getBoolean();
        }
        catch (Throwable throwable) {}
        item.setHidden(hidden || hiddenDestNode);
        item.setLastAction(ItemAction.CREATED);
        item.setLastModificationTime(now);
        item.setLastModifiedBy(login);
        item.setOwner(login);
        item.setPublicItem(false);
        Node newNode = new Item2NodeConverter().getNode(destinationNode, (Item)item);
        if (accountingHandler != null) {
            accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), null, ses, destinationNode, false);
            accountingHandler.createEntryCreate(item.getTitle(), ses, newNode, false);
        }
        return newNode;
    }

    public static Node createURLInternally(Session ses, Node destinationNode, String name, URL value, String description, String login, AccountingHandler accountingHandler) throws BackendGenericError {
        String uniqueName = Utils.checkExistanceAndGetUniqueName((Session)ses, (Node)destinationNode, (String)name);
        ExternalLink item = new ExternalLink();
        Calendar now = Calendar.getInstance();
        item.setName(uniqueName);
        item.setTitle(uniqueName);
        item.setDescription(description);
        item.setLastAction(ItemAction.CREATED);
        item.setLastModificationTime(now);
        item.setLastModifiedBy(login);
        item.setOwner(login);
        item.setPublicItem(false);
        item.setValue(value);
        try {
            item.setHidden(destinationNode.getProperty(NodeProperty.HIDDEN.toString()).getBoolean());
        }
        catch (Throwable throwable) {
            item.setHidden(false);
        }
        Node newNode = new Item2NodeConverter().getNode(destinationNode, (Item)item);
        if (accountingHandler != null) {
            accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), null, ses, destinationNode, false);
            accountingHandler.createEntryCreate(item.getTitle(), ses, newNode, false);
        }
        return newNode;
    }

    public static Node createGcubeItemInternally(Session ses, Node destinationNode, String name, String description, String login, GCubeItem gcubeItem, AccountingHandler accountingHandler) throws BackendGenericError {
        Calendar now = Calendar.getInstance();
        gcubeItem.setName(name);
        gcubeItem.setTitle(name);
        gcubeItem.setDescription(description);
        gcubeItem.setHidden(false);
        gcubeItem.setLastAction(ItemAction.CREATED);
        gcubeItem.setLastModificationTime(now);
        gcubeItem.setLastModifiedBy(login);
        gcubeItem.setOwner(login);
        Node newNode = new Item2NodeConverter().getNode(destinationNode, (Item)gcubeItem);
        return newNode;
    }

    public static void setPropertyOnChangeNode(Node node, String login, ItemAction action) throws RepositoryException {
        node.setProperty(NodeProperty.LAST_MODIFIED.toString(), Calendar.getInstance());
        node.setProperty(NodeProperty.LAST_MODIFIED_BY.toString(), login);
        node.setProperty(NodeProperty.LAST_ACTION.toString(), action.name());
    }

    public static synchronized VRE getVreFolderItem(Session ses, Node2ItemConverter node2Item, VREManager vreManager, List<String> excludes) throws RepositoryException, BackendGenericError {
        Path vrePath = Paths.append((Path)Utils.getWorkspacePath(), (String)"MySpecialFolders");
        ScopeBean bean = new ScopeBean(ScopeProvider.instance.get());
        if (!bean.is(ScopeBean.Type.VRE)) {
            throw new BackendGenericError("the current scope is not a VRE");
        }
        String entireScopeName = bean.toString().replaceAll("^/(.*)/?$", "$1").replaceAll("/", "-");
        VRE vre = vreManager.getVRE(entireScopeName);
        if (vre != null) {
            return vre;
        }
        String query = String.format("SELECT * FROM [nthl:workspaceItem] As node WHERE node.[jcr:title] like '%s' AND ISDESCENDANTNODE('%s')", entireScopeName, vrePath.toPath());
        Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
        NodeIterator it = jcrQuery.execute().getNodes();
        if (!it.hasNext()) {
            throw new BackendGenericError("vre folder not found for context " + entireScopeName);
        }
        Node folder = it.nextNode();
        Item vreFolder = node2Item.getItem(folder, excludes);
        return vreManager.putVRE(vreFolder);
    }

    public static synchronized VRE getVreFolderItemByGroupNameAndUser(Session ses, String goupName, String userId, Node2ItemConverter node2Item, VREManager vreManager, List<String> excludes) throws RepositoryException, BackendGenericError {
        Path vrePath = Paths.append((Path)Utils.getWorkspacePath((String)userId), (String)"MySpecialFolders");
        VRE vre = vreManager.getVRE(goupName);
        if (vre != null) {
            return vre;
        }
        String query = String.format("SELECT * FROM [nthl:workspaceItem] As node WHERE node.[jcr:title] like '%s' AND ISDESCENDANTNODE('%s')", goupName, vrePath.toPath());
        Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
        NodeIterator it = jcrQuery.execute().getNodes();
        if (!it.hasNext()) {
            throw new BackendGenericError("vre folder not found for context " + goupName);
        }
        Node folder = it.nextNode();
        Item vreFolder = node2Item.getItem(folder, excludes);
        return vreManager.putVRE(vreFolder);
    }
}

