/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.MultipleOutputStream;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.StorageBackendHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandlerFactory;
import org.gcube.data.access.storagehub.services.ItemsCreator;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
@ManagedBy(value=StorageHubAppllicationManager.class)
public class ItemsCreator {
    private static final Logger log = LoggerFactory.getLogger(ItemsCreator.class);
    private static ExecutorService executor = Executors.newFixedThreadPool(100);
    @Context
    ServletContext context;
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    ContentHandlerFactory contenthandlerFactory;
    @Inject
    VersionHandler versionHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    StorageBackendHandler storageBackend;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}/create/FOLDER")
    public Response createFolder(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="hidden") boolean hidden) {
        String toReturn;
        block16: {
            InnerMethodName.instance.set("createItem(FOLDER)");
            log.info("create folder item called");
            Session ses = null;
            toReturn = null;
            try {
                Node newNode;
                Node destination;
                String login = AuthorizationProvider.instance.get().getClient().getId();
                long start = System.currentTimeMillis();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
                try {
                    destination = ses.getNodeByIdentifier(id);
                }
                catch (RepositoryException repositoryException) {
                    throw new IdNotFoundException(id);
                }
                if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                    throw new InvalidItemException("the destination item is not a folder");
                }
                this.authChecker.checkWriteAuthorizationControl(ses, destination.getIdentifier(), true);
                Utils.acquireLockWithWait((Session)ses, (String)destination.getPath(), (boolean)false, (String)login, (int)10);
                try {
                    newNode = Utils.createFolderInternally((Session)ses, (Node)destination, (String)name, (String)description, (boolean)hidden, (String)login, (AccountingHandler)this.accountingHandler);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
                log.info("item with id {} correctly created", (Object)newNode.getIdentifier());
                toReturn = newNode.getIdentifier();
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses != null) {
                    ses.logout();
                }
                break block16;
            }
            catch (RepositoryException re) {
                try {
                    log.error("jcr error creating item", (Throwable)re);
                    GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block16;
            ses.logout();
        }
        return Response.ok(toReturn).build();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}/create/URL")
    public Response createURL(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="value") URL value) {
        String toReturn;
        block16: {
            InnerMethodName.instance.set("createItem(URL)");
            log.info("create url called");
            Session ses = null;
            toReturn = null;
            try {
                Node newNode;
                Node destination;
                String login = AuthorizationProvider.instance.get().getClient().getId();
                long start = System.currentTimeMillis();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
                try {
                    destination = ses.getNodeByIdentifier(id);
                }
                catch (RepositoryException repositoryException) {
                    throw new IdNotFoundException(id);
                }
                if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                    throw new InvalidItemException("the destination item is not a folder");
                }
                this.authChecker.checkWriteAuthorizationControl(ses, destination.getIdentifier(), true);
                Utils.acquireLockWithWait((Session)ses, (String)destination.getPath(), (boolean)false, (String)login, (int)10);
                try {
                    newNode = Utils.createURLInternally((Session)ses, (Node)destination, (String)name, (URL)value, (String)description, (String)login, (AccountingHandler)this.accountingHandler);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
                log.info("item with id {} correctly created", (Object)newNode.getIdentifier());
                toReturn = newNode.getIdentifier();
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses != null) {
                    ses.logout();
                }
                break block16;
            }
            catch (RepositoryException re) {
                try {
                    log.error("jcr error creating item", (Throwable)re);
                    GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                    break block16;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (ses != null) {
                        ses.logout();
                    }
                }
            }
            if (ses == null) break block16;
            ses.logout();
        }
        return Response.ok(toReturn).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/create/GCUBEITEM")
    public String createGcubeItem(@PathParam(value="id") String id, GCubeItem item) {
        InnerMethodName.instance.set("createItem(GCUBEITEM)");
        log.info("create Gcube item called");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                Node newNode;
                Node destination;
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                try {
                    destination = ses.getNodeByIdentifier(id);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    throw new IdNotFoundException(id);
                }
                if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                    throw new InvalidItemException("the destination item is not a folder");
                }
                this.authChecker.checkWriteAuthorizationControl(ses, destination.getIdentifier(), true);
                Utils.acquireLockWithWait((Session)ses, (String)destination.getPath(), (boolean)false, (String)login, (int)10);
                try {
                    newNode = Utils.createGcubeItemInternally((Session)ses, (Node)destination, (String)item.getName(), (String)item.getDescription(), (String)login, (GCubeItem)item, (AccountingHandler)this.accountingHandler);
                    ses.save();
                }
                finally {
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
                log.info("item with id {} correctly created", (Object)newNode.getIdentifier());
                toReturn = newNode.getIdentifier();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * Loose catch block
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/{id}/create/FILE")
    public String createFileItem(@PathParam(value="id") String id, @FormDataParam(value="name") String name, @FormDataParam(value="description") String description, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.instance.set("createItem(FILE)");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                if (name == null || name.trim().isEmpty() || description == null) {
                    throw new InvalidCallParameters("name or description are null or empty");
                }
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node destination = ses.getNodeByIdentifier(id);
                log.info("create file called with filename {} in dir {} ", (Object)name, (Object)destination.getPath());
                if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                    throw new InvalidItemException("the destination item is not a folder");
                }
                log.info("session: {}", (Object)ses.toString());
                Node newNode = this.createFileItemInternally(ses, destination, stream, name, description, login, true);
                ses.save();
                this.versionHandler.checkinContentNode(newNode, ses);
                log.info("file with id {} correctly created", (Object)newNode.getIdentifier());
                toReturn = newNode.getIdentifier();
            }
            catch (RepositoryException re) {
                log.error("jcr error creating file item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating file item", (Throwable)re));
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
            catch (Throwable e) {
                log.error("unexpected error", e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                if (ses != null && ses.isLive()) {
                    log.info("session closed");
                    ses.logout();
                }
            }
        }
        finally {
            if (ses != null && ses.isLive()) {
                log.info("session closed");
                ses.logout();
            }
        }
        return toReturn;
    }

    private Node createFileItemInternally(Session ses, Node destinationNode, InputStream stream, String name, String description, String login, boolean withLock) throws RepositoryException, UserNotAuthorizedException, ItemLockedException, BackendGenericError {
        Node newNode;
        try {
            newNode = ses.getNode(Paths.append((org.gcube.common.storagehub.model.Path)Paths.getPath((String)destinationNode.getPath()), (String)name).toPath());
            this.authChecker.checkWriteAuthorizationControl(ses, newNode.getIdentifier(), false);
            AbstractFileItem item = this.fillItemWithContent(stream, name, description, destinationNode.getPath(), login);
            item.setHidden(destinationNode.getProperty(NodeProperty.HIDDEN.toString()).getBoolean());
            if (withLock) {
                try {
                    ses.getWorkspace().getLockManager().lock(newNode.getPath(), true, true, 0L, login);
                }
                catch (LockException le) {
                    throw new ItemLockedException((Throwable)le);
                }
            }
            try {
                this.versionHandler.checkoutContentNode(newNode, ses);
                log.trace("replacing content of class {}", item.getContent().getClass());
                this.item2Node.replaceContent(newNode, item, ItemAction.UPDATED);
                this.accountingHandler.createFileUpdated(item.getTitle(), ses, newNode, false);
                ses.save();
            }
            finally {
                if (withLock) {
                    ses.getWorkspace().getLockManager().unlock(newNode.getPath());
                }
            }
        }
        catch (PathNotFoundException pathNotFoundException) {
            this.authChecker.checkWriteAuthorizationControl(ses, destinationNode.getIdentifier(), true);
            AbstractFileItem item = this.fillItemWithContent(stream, name, description, destinationNode.getPath(), login);
            if (withLock) {
                try {
                    log.debug("trying to acquire lock");
                    Utils.acquireLockWithWait((Session)ses, (String)destinationNode.getPath(), (boolean)false, (String)login, (int)10);
                }
                catch (LockException le) {
                    throw new ItemLockedException((Throwable)le);
                }
            }
            try {
                newNode = this.item2Node.getNode(destinationNode, (Item)item);
                this.accountingHandler.createEntryCreate(item.getTitle(), ses, newNode, false);
                ses.save();
            }
            finally {
                if (withLock) {
                    ses.getWorkspace().getLockManager().unlock(destinationNode.getPath());
                }
            }
            this.versionHandler.makeVersionableContent(newNode, ses);
            this.accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), item.getContent().getMimeType(), ses, destinationNode, false);
        }
        return newNode;
    }

    private AbstractFileItem fillItemWithContent(InputStream stream, String name, String description, String path, String login) throws BackendGenericError {
        ContentHandler handler = this.getContentHandler(stream, name, path, login);
        AbstractFileItem item = handler.buildItem(name, description, login);
        return item;
    }

    /*
     * Exception decompiling
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/{id}/create/ARCHIVE")
    public String uploadArchive(@PathParam(value="id") String id, @FormDataParam(value="parentFolderName") String parentFolderName, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ContentHandler getContentHandler(InputStream stream, String name, String path, String login) throws BackendGenericError {
        MultipleOutputStream mos;
        try {
            mos = new MultipleOutputStream(stream, 2);
        }
        catch (IOException e) {
            throw new BackendGenericError((Throwable)e);
        }
        1 mimeTypeDector = new /* Unavailable Anonymous Inner Class!! */;
        2 uploader = new /* Unavailable Anonymous Inner Class!! */;
        Future detectorF = executor.submit(AuthorizedTasks.bind((Callable)mimeTypeDector));
        Future uploaderF = executor.submit(AuthorizedTasks.bind((Callable)uploader));
        long start = System.currentTimeMillis();
        log.debug("TIMING: writing the stream - start");
        try {
            mos.startWriting();
            log.debug("TIMING: writing the stream - finished in {}", (Object)(System.currentTimeMillis() - start));
            ContentHandler handler = (ContentHandler)detectorF.get();
            MetaInfo info = (MetaInfo)uploaderF.get();
            handler.getContent().setData("jcr:content");
            handler.getContent().setStorageId(info.getStorageId());
            handler.getContent().setSize(Long.valueOf(info.getSize()));
            handler.getContent().setRemotePath(info.getRemotePath());
            return handler;
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }
}

