/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.StorageHubAppllicationManager;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.UnshareHandler;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
public class ItemSharing {
    private static final Logger log = LoggerFactory.getLogger(ItemSharing.class);
    RepositoryInitializer repository = StorageHubAppllicationManager.repository;
    @Inject
    AccountingHandler accountingHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    UnshareHandler unshareHandler;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{id}/share")
    @Consumes(value={"multipart/form-data"})
    public String share(@FormDataParam(value="users") Set<String> users, @FormDataParam(value="defaultAccessType") AccessType accessType) {
        InnerMethodName.instance.set("shareFolder");
        Session ses = null;
        String toReturn = null;
        try {
            try {
                Node sharedFolderNode;
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                this.authChecker.checkWriteAuthorizationControl(ses, this.id, false);
                Item item = this.node2Item.getItem(ses.getNodeByIdentifier(this.id), Excludes.ALL);
                if (accessType == null) {
                    accessType = AccessType.READ_ONLY;
                }
                if (users == null || users.isEmpty()) {
                    throw new InvalidCallParameters("users is empty");
                }
                Node nodeToShare = ses.getNodeByIdentifier(this.id);
                boolean alreadyShared = false;
                if (!this.node2Item.checkNodeType(nodeToShare, SharedFolder.class)) {
                    sharedFolderNode = this.shareFolder(nodeToShare, ses);
                } else {
                    sharedFolderNode = nodeToShare;
                    alreadyShared = true;
                }
                ses.save();
                try {
                    ses.getWorkspace().getLockManager().lock(sharedFolderNode.getPath(), true, true, 0L, login);
                }
                catch (LockException e) {
                    throw new ItemLockedException((Throwable)e);
                }
                try {
                    AccessControlManager acm = ses.getAccessControlManager();
                    JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)sharedFolderNode.getPath());
                    if (!alreadyShared) {
                        Privilege[] adminPrivileges = new Privilege[]{acm.privilegeFromName(AccessType.ADMINISTRATOR.getValue())};
                        this.addUserToSharing(sharedFolderNode, ses, login, item, adminPrivileges, acls);
                        users.remove(login);
                    }
                    Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(accessType.getValue())};
                    for (String user : users) {
                        try {
                            this.addUserToSharing(sharedFolderNode, ses, user, null, userPrivileges, acls);
                        }
                        catch (Exception exception) {
                            log.warn("error adding user {} to sharing of folder {}", (Object)user, (Object)sharedFolderNode.getName());
                        }
                    }
                    acm.setPolicy(sharedFolderNode.getPath(), (AccessControlPolicy)acls);
                    this.accountingHandler.createShareFolder(sharedFolderNode.getProperty(NodeProperty.TITLE.toString()).getString(), users, ses, sharedFolderNode, false);
                    ses.save();
                    toReturn = sharedFolderNode.getIdentifier();
                    return toReturn;
                }
                finally {
                    if (!ses.hasPendingChanges()) {
                        ses.getWorkspace().getLockManager().unlock(sharedFolderNode.getPath());
                    }
                }
            }
            catch (RepositoryException re) {
                log.error("jcr sharing", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error sharing folder", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private Node shareFolder(Node node, Session ses) throws RepositoryException, BackendGenericError, StorageHubException {
        String login = AuthorizationProvider.instance.get().getClient().getId();
        if (!this.node2Item.checkNodeType(node, FolderItem.class) || Utils.hasSharedChildren((Node)node) || !node.getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString().equals(login)) {
            throw new InvalidItemException("item with id " + this.id + " cannot be shared");
        }
        String sharedFolderName = node.getIdentifier();
        String newNodePath = "/Share/" + sharedFolderName;
        ses.move(node.getPath(), newNodePath);
        Node sharedFolderNode = ses.getNode(newNodePath);
        sharedFolderNode.setPrimaryType("nthl:workspaceSharedItem");
        return sharedFolderNode;
    }

    private void addUserToSharing(Node sharedFolderNode, Session ses, String user, Item itemToShare, Privilege[] userPrivileges, JackrabbitAccessControlList acls) throws RepositoryException {
        String userPath;
        String userRootWSId;
        if (itemToShare == null) {
            String userRootWS = Utils.getWorkspacePath((String)user).toPath();
            userRootWSId = ses.getNode(userRootWS).getIdentifier();
            userPath = String.format("%s%s", userRootWS, sharedFolderNode.getProperty(NodeProperty.TITLE.toString()).getString());
        } else {
            userPath = itemToShare.getPath();
            userRootWSId = itemToShare.getParentId();
        }
        log.info("cloning directory to {} ", (Object)userPath);
        ses.getWorkspace().clone(ses.getWorkspace().getName(), sharedFolderNode.getPath(), userPath, false);
        acls.addAccessControlEntry(AccessControlUtils.getPrincipal((Session)ses, (String)user), userPrivileges);
        Node usersNode = null;
        usersNode = sharedFolderNode.hasNode("hl:users") ? sharedFolderNode.getNode("hl:users") : sharedFolderNode.addNode("hl:users");
        usersNode.setProperty(user, String.format("%s/%s", userRootWSId, sharedFolderNode.getProperty(NodeProperty.TITLE.toString()).getString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{id}/unshare")
    @Consumes(value={"multipart/form-data"})
    public String unshare(@FormDataParam(value="users") Set<String> users) {
        InnerMethodName.instance.set("unshareFolder");
        String login = AuthorizationProvider.instance.get().getClient().getId();
        Session ses = null;
        String toReturn = null;
        try {
            try {
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node sharedNode = ses.getNodeByIdentifier(this.id);
                toReturn = this.unshareHandler.unshare(ses, users, sharedNode, login);
                if (toReturn != null) return toReturn;
                throw new InvalidItemException("item with id " + this.id + " cannot be unshared");
            }
            catch (RepositoryException re) {
                log.error("jcr unsharing", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", (Throwable)re));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (ses == null) return toReturn;
                ses.logout();
                return toReturn;
            }
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }
}

